/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestPartitionStat
extends MetaStoreClientTest {
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private static final String DB_NAME = "test_part_stat";
    private static final String TABLE_NAME = "test_part_stat_table";
    private static final String DEFAULT_COL_TYPE = "int";
    private static final String PART_COL_NAME = "year";
    private static final Partition[] PARTITIONS = new Partition[5];

    public TestPartitionStat(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @BeforeClass
    public static void startMetaStores() {
        HashMap<MetastoreConf.ConfVars, String> msConf = new HashMap<MetastoreConf.ConfVars, String>();
        HashMap<String, String> extraConf = new HashMap<String, String>();
        extraConf.put(MetastoreConf.ConfVars.HIVE_IN_TEST.getVarname(), "true");
        extraConf.put(MetastoreConf.ConfVars.STATS_FETCH_BITVECTOR.getVarname(), "true");
        extraConf.put(MetastoreConf.ConfVars.STATS_FETCH_KLL.getVarname(), "true");
        TestPartitionStat.startMetaStores(msConf, extraConf);
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        DatabaseBuilder databaseBuilder = new DatabaseBuilder().setName(DB_NAME);
        databaseBuilder.create(this.client, this.metaStore.getConf());
        this.createTable(TABLE_NAME, TestPartitionStat.getYearPartCol());
        this.createPartitions();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    private void createPartitions() throws Exception {
        TestPartitionStat.PARTITIONS[0] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2017"}), TestPartitionStat.getYearPartCol());
        TestPartitionStat.PARTITIONS[1] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2018"}), TestPartitionStat.getYearPartCol());
        TestPartitionStat.PARTITIONS[2] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2019"}), TestPartitionStat.getYearPartCol());
        TestPartitionStat.PARTITIONS[3] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2020"}), TestPartitionStat.getYearPartCol());
        TestPartitionStat.PARTITIONS[4] = this.createPartition(Lists.newArrayList((Object[])new String[]{"2021"}), TestPartitionStat.getYearPartCol());
    }

    private Table createTable(String tableName, List<FieldSchema> partCols) throws Exception {
        String type = "MANAGED_TABLE";
        String location = this.metaStore.getWarehouseRoot() + "/" + tableName;
        return ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(tableName).setType(type).addCol("test_id", DEFAULT_COL_TYPE, "test col id")).addCol("test_value", "string", "test col value")).setPartCols(partCols).setLocation(location)).create(this.client, this.metaStore.getConf());
    }

    private Partition createPartition(List<String> values, List<FieldSchema> partCols) throws Exception {
        ((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).setValues(values).setCols(partCols)).addToTable(this.client, this.metaStore.getConf());
        return this.client.getPartition(DB_NAME, TABLE_NAME, values);
    }

    private static List<FieldSchema> getYearPartCol() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(PART_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        return cols;
    }

    private ColumnStatisticsData createStatsData(long numNulls, long numDVs, long low, long high, HyperLogLog hll, KllFloatsSketch kll) {
        ColumnStatisticsData data = new ColumnStatisticsData();
        LongColumnStatsDataInspector stats = new LongColumnStatsDataInspector();
        stats.setLowValue(low);
        stats.setHighValue(high);
        stats.setNumNulls(numNulls);
        stats.setNumDVs(numDVs);
        stats.setBitVectors(hll.serialize());
        stats.setHistogram(kll.toByteArray());
        data.setLongStats((LongColumnStatsData)stats);
        return data;
    }

    private ColumnStatistics createPartColStats(List<String> partValue, ColumnStatisticsData partitionStats) {
        String pName = FileUtils.makePartName(Collections.singletonList(PART_COL_NAME), partValue);
        ColumnStatistics colStats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(false, DB_NAME, TABLE_NAME);
        statsDesc.setPartName(pName);
        colStats.setStatsDesc(statsDesc);
        colStats.setEngine("hive");
        ColumnStatisticsObj statObj = new ColumnStatisticsObj(PART_COL_NAME, DEFAULT_COL_TYPE, partitionStats);
        colStats.addToStatsObj(statObj);
        return colStats;
    }

    private void assertLongStatsEquals(LongColumnStatsData expectedData, LongColumnStatsData actualData) {
        Assert.assertEquals((long)expectedData.getNumDVs(), (long)actualData.getNumDVs());
        Assert.assertEquals((long)expectedData.getNumNulls(), (long)actualData.getNumNulls());
        Assert.assertEquals((long)expectedData.getHighValue(), (long)actualData.getHighValue());
        Assert.assertEquals((long)expectedData.getLowValue(), (long)actualData.getLowValue());
        Assert.assertArrayEquals((byte[])expectedData.getBitVectors(), (byte[])actualData.getBitVectors());
        Assert.assertArrayEquals((byte[])expectedData.getHistogram(), (byte[])actualData.getHistogram());
    }

    private List<String> updatePartColStat(Map<List<String>, ColumnStatisticsData> partitionStats) throws Exception {
        SetPartitionsStatsRequest rqst = new SetPartitionsStatsRequest();
        rqst.setEngine("hive");
        ArrayList<String> pNameList = new ArrayList<String>();
        for (Map.Entry<List<String>, ColumnStatisticsData> entry : partitionStats.entrySet()) {
            ColumnStatistics colStats = this.createPartColStats(entry.getKey(), entry.getValue());
            String pName = FileUtils.makePartName(Collections.singletonList(PART_COL_NAME), entry.getKey());
            rqst.addToColStats(colStats);
            pNameList.add(pName);
        }
        this.client.setPartitionColumnStatistics(rqst);
        return pNameList;
    }

    private void validateStats(Map<List<String>, ColumnStatisticsData> partitionStats, List<String> pNameList) throws Exception {
        Map statistics = this.client.getPartitionColumnStatistics(DB_NAME, TABLE_NAME, pNameList, Collections.singletonList(PART_COL_NAME), "hive");
        for (Map.Entry<List<String>, ColumnStatisticsData> entry : partitionStats.entrySet()) {
            String pName = FileUtils.makePartName(Collections.singletonList(PART_COL_NAME), entry.getKey());
            ColumnStatisticsObj statisticsObjs = (ColumnStatisticsObj)((List)statistics.get(pName)).get(0);
            ColumnStatisticsData data = entry.getValue();
            this.assertLongStatsEquals(statisticsObjs.getStatsData().getLongStats(), data.getLongStats());
        }
    }

    @Test
    public void testUpdateStatSingle() throws Exception {
        HashMap<List<String>, ColumnStatisticsData> partitionStats = new HashMap<List<String>, ColumnStatisticsData>();
        HyperLogLog hll = HyperLogLog.builder().build();
        hll.addLong(1L);
        hll.addLong(2L);
        hll.addLong(3L);
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        kll.update(1.0f);
        kll.update(2.0f);
        kll.update(3.0f);
        partitionStats.put(PARTITIONS[0].getValues(), this.createStatsData(100L, 50L, 1L, 100L, hll, kll));
        List<String> pNameList = this.updatePartColStat(partitionStats);
        this.validateStats(partitionStats, pNameList);
    }

    @Test
    public void testUpdateStatMultiple() throws Exception {
        HyperLogLog hll = HyperLogLog.builder().build();
        hll.addLong(1L);
        hll.addLong(2L);
        hll.addLong(4L);
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        kll.update(1.0f);
        kll.update(2.0f);
        kll.update(5.0f);
        HashMap<List<String>, ColumnStatisticsData> partitionStats = new HashMap<List<String>, ColumnStatisticsData>();
        partitionStats.put(PARTITIONS[0].getValues(), this.createStatsData(100L, 50L, 1L, 100L, hll, kll));
        partitionStats.put(PARTITIONS[1].getValues(), this.createStatsData(100L, 500L, 1L, 100L, hll, kll));
        partitionStats.put(PARTITIONS[2].getValues(), this.createStatsData(100L, 150L, 1L, 100L, hll, kll));
        hll = HyperLogLog.builder().build();
        hll.addLong(1L);
        hll.addLong(3L);
        hll.addLong(4L);
        kll = KllFloatsSketch.newHeapInstance();
        kll.update(1.0f);
        kll.update(3.0f);
        kll.update(5.0f);
        partitionStats.put(PARTITIONS[3].getValues(), this.createStatsData(100L, 50L, 2L, 100L, hll, kll));
        partitionStats.put(PARTITIONS[4].getValues(), this.createStatsData(100L, 50L, 1L, 1000L, hll, kll));
        List<String> pNameList = this.updatePartColStat(partitionStats);
        this.validateStats(partitionStats, pNameList);
    }
}

