/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestHiveMetaStoreClient
extends MetaStoreClientTest {
    private boolean isRemote;
    private AbstractMetaStoreService metaStore;

    public TestHiveMetaStoreClient(String name, AbstractMetaStoreService metaStore) {
        this.isRemote = name.equals("Remote");
        this.metaStore = metaStore;
    }

    @After
    public void cleanUp() throws Exception {
        HiveMetaStoreClient.getConnCount().set(0);
    }

    @Test
    public void testTTransport() throws MetaException {
        HiveMetaStoreClient client = this.metaStore.getClient();
        Assert.assertTrue((boolean)(this.isRemote ? client.getTTransport().isOpen() : client.getTTransport() == null));
        client.close();
        Assert.assertTrue((boolean)(this.isRemote ? !client.getTTransport().isOpen() : client.getTTransport() == null));
    }

    @Test
    public void testReconnect() throws MetaException {
        HiveMetaStoreClient client = this.metaStore.getClient();
        Assert.assertEquals((long)(this.isRemote ? 1L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        try {
            client.reconnect();
        }
        catch (MetaException e) {
            Assert.assertFalse((boolean)this.isRemote);
        }
        Assert.assertEquals((long)(this.isRemote ? 1L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        client.close();
        Assert.assertEquals((long)0L, (long)HiveMetaStoreClient.getConnCount().get());
    }

    @Test
    public void testCloseClient() throws MetaException {
        HiveMetaStoreClient client1 = this.metaStore.getClient();
        Assert.assertEquals((long)(this.isRemote ? 1L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        HiveMetaStoreClient client2 = this.metaStore.getClient();
        Assert.assertEquals((long)(this.isRemote ? 2L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        client1.close();
        Assert.assertEquals((long)(this.isRemote ? 1L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        client1.close();
        Assert.assertEquals((long)(this.isRemote ? 1L : 0L), (long)HiveMetaStoreClient.getConnCount().get());
        client2.close();
        Assert.assertEquals((long)0L, (long)HiveMetaStoreClient.getConnCount().get());
    }
}

