/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AllTableConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLAllTableConstraints;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLCheckConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLDefaultConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLForeignKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLNotNullConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLPrimaryKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLUniqueConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestGetAllTableConstraints
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_constraints_other_database";
    private static final String OTHER_CATALOG = "test_constraints_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_constraints_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[2];

    public TestGetAllTableConstraints(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.testTables[0] = ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "int")).addCol("col3", "boolean")).addCol("col4", "int")).addCol("col5", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void noConstraints() throws TException {
        Table table = this.testTables[0];
        SQLAllTableConstraints constraints = new SQLAllTableConstraints();
        constraints.setPrimaryKeys(new ArrayList());
        constraints.setForeignKeys(new ArrayList());
        constraints.setNotNullConstraints(new ArrayList());
        constraints.setCheckConstraints(new ArrayList());
        constraints.setDefaultConstraints(new ArrayList());
        constraints.setUniqueConstraints(new ArrayList());
        AllTableConstraintsRequest request = new AllTableConstraintsRequest(table.getDbName(), table.getTableName(), table.getCatName());
        SQLAllTableConstraints fetched = this.client.getAllTableConstraints(request);
        Assert.assertEquals((Object)constraints, (Object)fetched);
    }

    @Test
    public void fewPresentWithMultipleConstraints() throws TException {
        Table table = this.testTables[0];
        SQLAllTableConstraints expected = new SQLAllTableConstraints();
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).setConstraintName("col1_pk")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        expected.setPrimaryKeys(pk);
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col2")).setConstraintName("col2_unique")).build(this.metaStore.getConf());
        this.client.addUniqueConstraint(uc);
        expected.setUniqueConstraints(uc);
        List dv = ((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)new SQLDefaultConstraintBuilder().onTable(table)).addColumn("col3")).setConstraintName("col3_default")).setDefaultVal((Object)false).build(this.metaStore.getConf());
        this.client.addDefaultConstraint(dv);
        expected.setDefaultConstraints(dv);
        SQLNotNullConstraint nnCol2 = new SQLNotNullConstraint(table.getCatName(), table.getDbName(), table.getTableName(), "col2", "col2_not_null", true, true, true);
        SQLNotNullConstraint nnCol3 = new SQLNotNullConstraint(table.getCatName(), table.getDbName(), table.getTableName(), "col3", "col3_not_null", true, true, true);
        ArrayList<SQLNotNullConstraint> nn = new ArrayList<SQLNotNullConstraint>();
        nn.add(nnCol2);
        nn.add(nnCol3);
        this.client.addNotNullConstraint(nn);
        expected.setNotNullConstraints(nn);
        expected.setForeignKeys(new ArrayList());
        expected.setCheckConstraints(new ArrayList());
        AllTableConstraintsRequest request = new AllTableConstraintsRequest(table.getDbName(), table.getTableName(), table.getCatName());
        SQLAllTableConstraints fetched = this.client.getAllTableConstraints(request);
        Assert.assertEquals((Object)expected, (Object)fetched);
    }

    @Test
    public void allConstraintsPresent() throws TException {
        Table table = this.testTables[0];
        Table parentTable = this.testTables[1];
        SQLAllTableConstraints expected = new SQLAllTableConstraints();
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(table)).addColumn("col1")).setConstraintName("col1_pk")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        expected.setPrimaryKeys(pk);
        String uniqueConstraintName = "col2_unique";
        List uc = ((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)((SQLUniqueConstraintBuilder)new SQLUniqueConstraintBuilder().onTable(table)).addColumn("col2")).setConstraintName("col2_unique")).build(this.metaStore.getConf());
        this.client.addUniqueConstraint(uc);
        expected.setUniqueConstraints(uc);
        List dv = ((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)((SQLDefaultConstraintBuilder)new SQLDefaultConstraintBuilder().onTable(table)).addColumn("col3")).setConstraintName("col3_default")).setDefaultVal((Object)false).build(this.metaStore.getConf());
        this.client.addDefaultConstraint(dv);
        expected.setDefaultConstraints(dv);
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col3")).setConstraintName("col3_not_null")).build(this.metaStore.getConf());
        this.client.addNotNullConstraint(nn);
        expected.setNotNullConstraints(nn);
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col2")).setConstraintName("col2_check")).setCheckExpression("= 5").build(this.metaStore.getConf());
        this.client.addCheckConstraint(cc);
        expected.setCheckConstraints(cc);
        List parentPk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).setConstraintName("parentpk")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(parentPk);
        String fkConstraintName = "fk";
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(parentPk).onTable(table)).setConstraintName(fkConstraintName)).addColumn("col4")).build(this.metaStore.getConf());
        this.client.addForeignKey(fk);
        expected.setForeignKeys(fk);
        AllTableConstraintsRequest request = new AllTableConstraintsRequest(table.getDbName(), table.getTableName(), table.getCatName());
        SQLAllTableConstraints actual = this.client.getAllTableConstraints(request);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

