/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestExchangePartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    protected static final String DB_NAME = "test_partition_db";
    private static final String STRING_COL_TYPE = "string";
    protected static final String INT_COL_TYPE = "int";
    protected static final String YEAR_COL_NAME = "year";
    protected static final String MONTH_COL_NAME = "month";
    protected static final String DAY_COL_NAME = "day";
    protected static final short MAX = -1;
    private Table sourceTable;
    private Table destTable;
    private Partition[] partitions;

    public TestExchangePartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        this.createTestTables();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    protected IMetaStoreClient getClient() {
        return this.client;
    }

    protected void setClient(IMetaStoreClient client) {
        this.client = client;
    }

    protected AbstractMetaStoreService getMetaStore() {
        return this.metaStore;
    }

    protected Table getSourceTable() {
        return this.sourceTable;
    }

    protected Table getDestTable() {
        return this.destTable;
    }

    protected Partition[] getPartitions() {
        return this.partitions;
    }

    @Test
    public void testExchangePartitions() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        List exchangedPartitions = this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        Assert.assertEquals((long)1L, (long)exchangedPartitions.size());
        String partitionName = Warehouse.makePartName((List)this.sourceTable.getPartitionKeys(), (List)this.partitions[1].getValues());
        String exchangedPartitionName = Warehouse.makePartName((List)this.sourceTable.getPartitionKeys(), (List)((Partition)exchangedPartitions.get(0)).getValues());
        Assert.assertEquals((Object)partitionName, (Object)exchangedPartitionName);
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionsDestTableHasPartitions() throws Exception {
        this.createPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), this.destTable.getSd().getLocation() + "/destPart1");
        this.createPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), this.destTable.getSd().getLocation() + "/destPart2");
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partitionNames = this.client.listPartitionNames(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertEquals((long)3L, (long)partitionNames.size());
        Assert.assertTrue((boolean)partitionNames.containsAll(Lists.newArrayList((Object[])new String[]{"year=2019/month=march/day=15", "year=2019/month=march/day=22"})));
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.destTable.getSd().getLocation() + "/destPart1")));
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.destTable.getSd().getLocation() + "/destPart2")));
    }

    @Test
    public void testExchangePartitionsYearSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        List exchangedPartitions = this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        Assert.assertEquals((long)4L, (long)exchangedPartitions.size());
        ArrayList<String> exchangedPartNames = new ArrayList<String>();
        for (Partition exchangedPartition : exchangedPartitions) {
            String partName = Warehouse.makePartName((List)this.sourceTable.getPartitionKeys(), (List)exchangedPartition.getValues());
            exchangedPartNames.add(partName);
        }
        Assert.assertTrue((boolean)exchangedPartNames.contains("year=2017/month=march/day=15"));
        Assert.assertTrue((boolean)exchangedPartNames.contains("year=2017/month=march/day=22"));
        Assert.assertTrue((boolean)exchangedPartNames.contains("year=2017/month=april/day=23"));
        Assert.assertTrue((boolean)exchangedPartNames.contains("year=2017/month=may/day=23"));
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionsYearAndMonthSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", ""}));
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionsBetweenDBs() throws Exception {
        String dbName = "newDatabase";
        this.createDB(dbName);
        Table dest = this.createTable(dbName, "test_dest_table_diff_db", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", ""}));
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkExchangedPartitions(this.sourceTable, dest, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, dest, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
        this.client.dropDatabase(dbName, true, true, true);
    }

    @Test
    public void testExchangePartitionsCustomTableLocations() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable(DB_NAME, "test_dest_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "15"}), null), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "june", "14"}), null)};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        this.client.exchange_partitions(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
    }

    @Test
    public void testExchangePartitionsCustomTableAndPartLocation() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable(DB_NAME, "test_dest_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "11"}), source.getSd().getLocation() + "/2019m11"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "july", "23"}), source.getSd().getLocation() + "/2019j23")};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        try {
            this.client.exchange_partitions(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0], parts[1]}));
        List destTablePartitions = this.client.listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertTrue((boolean)destTablePartitions.isEmpty());
    }

    @Test
    public void testExchangePartitionsCustomPartLocation() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), source.getSd().getLocation() + "/2019m15"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), source.getSd().getLocation() + "/2019m22")};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        try {
            this.client.exchange_partitions(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0], parts[1]}));
        List destTablePartitions = this.client.listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertTrue((boolean)destTablePartitions.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingPartLocation() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.metaStore.cleanWarehouseDirs();
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingSourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, DB_NAME, "nonexistingtable", this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingSourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, "nonexistingdb", this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, "nonexistingtable");
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), "nonexistingdb", this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsEmptySourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, DB_NAME, "", this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsEmptySourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, "", this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsEmptyDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, "");
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsEmptyDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), "", this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNullSourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, DB_NAME, null, this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNullSourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, null, this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNullDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, null);
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNullDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), null, this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsEmptyPartSpec() throws Exception {
        HashMap partitionSpecs = new HashMap();
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNullPartSpec() throws Exception {
        this.client.exchange_partitions(null, this.sourceTable.getDbName(), this.sourceTable.getTableName(), null, this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsPartAlreadyExists() throws Exception {
        Partition partition = this.buildPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "22"}), null);
        this.client.add_partition(partition);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
    }

    @Test
    public void testExchangePartitionsOneFail() throws Exception {
        Partition partition = this.buildPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "22"}), null);
        this.client.add_partition(partition);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        try {
            this.client.exchange_partitions(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
            Assert.fail((String)"Exception should have been thrown as one of the partitions already exists in the dest table.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partitionsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)partitionsInDestTable.size());
        Assert.assertEquals((Object)this.partitions[1].getValues(), (Object)((Partition)partitionsInDestTable.get(0)).getValues());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(((Partition)partitionsInDestTable.get(0)).getSd().getLocation())));
        Partition resultPart = this.client.getPartition(this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.partitions[1].getValues());
        Assert.assertNotNull((Object)resultPart);
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.partitions[1].getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentColsInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", INT_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        cols.add(new FieldSchema("test_name", STRING_COL_TYPE, "test col name"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentColNameInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("id", INT_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentColTypesInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", STRING_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentPartColsInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, STRING_COL_TYPE, "month part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentPartColNameInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, STRING_COL_TYPE, "month part col"));
        cols.add(new FieldSchema("nap", STRING_COL_TYPE, "day part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsDifferentPartColTypesInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, INT_COL_TYPE, "month part col"));
        cols.add(new FieldSchema(DAY_COL_NAME, STRING_COL_TYPE, "day part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test
    public void testExchangePartitionsLessValueInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionsMoreValueInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        partitionSpecs.put(DAY_COL_NAME, "22");
        partitionSpecs.put("hour", "18");
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionsDifferentValuesInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put("honap", "march");
        partitionSpecs.put("nap", "22");
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[4]}));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingValuesInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("ev", "2017");
        partitionSpecs.put("honap", "march");
        partitionSpecs.put("nap", "22");
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test
    public void testExchangePartitionsOnlyMonthSetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        partitionSpecs.put(DAY_COL_NAME, "");
        try {
            this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertTrue((boolean)partsInDestTable.isEmpty());
    }

    @Test
    public void testExchangePartitionsYearAndDaySetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "");
        partitionSpecs.put(DAY_COL_NAME, "22");
        try {
            this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertTrue((boolean)partsInDestTable.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNoPartExists() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", "25"}));
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNoPartExistsYearAndMonthSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "august", ""}));
        this.client.exchange_partitions(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test
    public void testExchangePartition() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        Partition exchangedPartition = this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        Assert.assertEquals((Object)new Partition(), (Object)exchangedPartition);
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionDestTableHasPartitions() throws Exception {
        this.createPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), this.destTable.getSd().getLocation() + "/destPart1");
        this.createPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), this.destTable.getSd().getLocation() + "/destPart2");
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partitionNames = this.client.listPartitionNames(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertEquals((long)3L, (long)partitionNames.size());
        Assert.assertTrue((boolean)partitionNames.containsAll(Lists.newArrayList((Object[])new String[]{"year=2019/month=march/day=15", "year=2019/month=march/day=22"})));
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.destTable.getSd().getLocation() + "/destPart1")));
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.destTable.getSd().getLocation() + "/destPart2")));
    }

    @Test
    public void testExchangePartitionYearSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        Partition exchangedPartition = this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        Assert.assertEquals((Object)new Partition(), (Object)exchangedPartition);
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionYearAndMonthSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", ""}));
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionBetweenDBs() throws Exception {
        String dbName = "newDatabase";
        this.createDB(dbName);
        Table dest = this.createTable(dbName, "test_dest_table_diff_db", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", ""}));
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkExchangedPartitions(this.sourceTable, dest, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, dest, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
        this.client.dropDatabase(dbName, true, true, true);
    }

    @Test
    public void testExchangePartitionCustomTableLocations() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable(DB_NAME, "test_dest_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "15"}), null), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "june", "14"}), null)};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        this.client.exchange_partition(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
    }

    @Test
    public void testExchangePartitionCustomTableAndPartLocation() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable(DB_NAME, "test_dest_table_cust_loc", TestExchangePartitions.getYearMonthAndDayPartCols(), this.metaStore.getExternalWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "11"}), source.getSd().getLocation() + "/2019m11"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "july", "23"}), source.getSd().getLocation() + "/2019j23")};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        try {
            this.client.exchange_partition(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0], parts[1]}));
        List destTablePartitions = this.client.listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertTrue((boolean)destTablePartitions.isEmpty());
    }

    @Test
    public void testExchangePartitionCustomPartLocation() throws Exception {
        Table source = this.createTable(DB_NAME, "test_source_table", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), source.getSd().getLocation() + "/2019m15"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), source.getSd().getLocation() + "/2019m22")};
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(parts[1]);
        try {
            this.client.exchange_partition(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0], parts[1]}));
        List destTablePartitions = this.client.listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertTrue((boolean)destTablePartitions.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingPartLocation() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.metaStore.cleanWarehouseDirs();
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingSourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, DB_NAME, "nonexistingtable", this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingSourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, "nonexistingdb", this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, "nonexistingtable");
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), "nonexistingdb", this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionEmptySourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, DB_NAME, "", this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionEmptySourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, "", this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionEmptyDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, "");
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionEmptyDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), "", this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNullSourceTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, DB_NAME, null, this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNullSourceDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, null, this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNullDestTable() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), DB_NAME, null);
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNullDestDB() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), null, this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionEmptyPartSpec() throws Exception {
        HashMap partitionSpecs = new HashMap();
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNullPartSpec() throws Exception {
        this.client.exchange_partition(null, this.sourceTable.getDbName(), this.sourceTable.getTableName(), null, this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionPartAlreadyExists() throws Exception {
        Partition partition = this.buildPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "22"}), null);
        this.client.add_partition(partition);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
    }

    @Test
    public void testExchangePartitionOneFail() throws Exception {
        Partition partition = this.buildPartition(this.destTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "22"}), null);
        this.client.add_partition(partition);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        try {
            this.client.exchange_partition(partitionSpecs, DB_NAME, this.sourceTable.getTableName(), DB_NAME, this.destTable.getTableName());
            Assert.fail((String)"Exception should have been thrown as one of the partitions already exists in the dest table.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partitionsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)partitionsInDestTable.size());
        Assert.assertEquals((Object)this.partitions[1].getValues(), (Object)((Partition)partitionsInDestTable.get(0)).getValues());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(((Partition)partitionsInDestTable.get(0)).getSd().getLocation())));
        Partition resultPart = this.client.getPartition(this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.partitions[1].getValues());
        Assert.assertNotNull((Object)resultPart);
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(this.partitions[1].getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentColsInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", INT_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        cols.add(new FieldSchema("test_name", STRING_COL_TYPE, "test col name"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentColNameInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("id", INT_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentColTypesInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", STRING_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", TestExchangePartitions.getYearMonthAndDayPartCols(), cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentPartColsInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, STRING_COL_TYPE, "month part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentPartColNameInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, STRING_COL_TYPE, "month part col"));
        cols.add(new FieldSchema("nap", STRING_COL_TYPE, "day part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionDifferentPartColTypesInTables() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, INT_COL_TYPE, "month part col"));
        cols.add(new FieldSchema(DAY_COL_NAME, STRING_COL_TYPE, "day part col"));
        Table dest = this.createTable(DB_NAME, "test_dest_table", cols, null);
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(this.partitions[1]);
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), dest.getDbName(), dest.getTableName());
    }

    @Test
    public void testExchangePartitionLessValueInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionMoreValueInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        partitionSpecs.put(DAY_COL_NAME, "22");
        partitionSpecs.put("hour", "18");
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[1]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[2], this.partitions[3], this.partitions[4]}));
    }

    @Test
    public void testExchangePartitionDifferentValuesInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put("honap", "march");
        partitionSpecs.put("nap", "22");
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
        this.checkExchangedPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3]}));
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[4]}));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingValuesInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("ev", "2017");
        partitionSpecs.put("honap", "march");
        partitionSpecs.put("nap", "22");
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test
    public void testExchangePartitionOnlyMonthSetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "");
        partitionSpecs.put(MONTH_COL_NAME, "march");
        partitionSpecs.put(DAY_COL_NAME, "");
        try {
            this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertTrue((boolean)partsInDestTable.isEmpty());
    }

    @Test
    public void testExchangePartitionYearAndDaySetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put(YEAR_COL_NAME, "2017");
        partitionSpecs.put(MONTH_COL_NAME, "");
        partitionSpecs.put(DAY_COL_NAME, "22");
        try {
            this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.checkRemainingPartitions(this.sourceTable, this.destTable, Lists.newArrayList((Object[])new Partition[]{this.partitions[0], this.partitions[1], this.partitions[2], this.partitions[3], this.partitions[4]}));
        List partsInDestTable = this.client.listPartitions(this.destTable.getDbName(), this.destTable.getTableName(), (short)-1);
        Assert.assertTrue((boolean)partsInDestTable.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNoPartExists() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "march", "25"}));
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNoPartExistsYearAndMonthSet() throws Exception {
        Map<String, String> partitionSpecs = TestExchangePartitions.getPartitionSpec(Lists.newArrayList((Object[])new String[]{"2017", "august", ""}));
        this.client.exchange_partition(partitionSpecs, this.sourceTable.getDbName(), this.sourceTable.getTableName(), this.destTable.getDbName(), this.destTable.getTableName());
    }

    protected void createTestTables() throws Exception {
        this.createDB(DB_NAME);
        this.sourceTable = this.createSourceTable();
        this.destTable = this.createDestTable();
        this.partitions = this.createTestPartitions();
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createSourceTable() throws Exception {
        return this.createTable(DB_NAME, "test_part_exch_table_source", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
    }

    private Table createDestTable() throws Exception {
        return this.createTable(DB_NAME, "test_part_exch_table_dest", TestExchangePartitions.getYearMonthAndDayPartCols(), null);
    }

    protected Table createTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", INT_COL_TYPE, "test col id"));
        cols.add(new FieldSchema("test_value", STRING_COL_TYPE, "test col value"));
        return this.createTable(dbName, tableName, partCols, cols, location);
    }

    protected Table createTable(String dbName, String tableName, List<FieldSchema> partCols, List<FieldSchema> cols, String location) throws Exception {
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).setType(TableType.EXTERNAL_TABLE.name()).setCols(cols)).setPartCols(partCols).setLocation(location)).create(this.client, this.metaStore.getConf());
        return this.client.getTable(dbName, tableName);
    }

    private Partition[] createTestPartitions() throws Exception {
        Partition partition1 = this.buildPartition(this.sourceTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "15"}), null);
        Partition partition2 = this.buildPartition(this.sourceTable, Lists.newArrayList((Object[])new String[]{"2017", "march", "22"}), null);
        Partition partition3 = this.buildPartition(this.sourceTable, Lists.newArrayList((Object[])new String[]{"2017", "april", "23"}), null);
        Partition partition4 = this.buildPartition(this.sourceTable, Lists.newArrayList((Object[])new String[]{"2017", "may", "23"}), null);
        Partition partition5 = this.buildPartition(this.sourceTable, Lists.newArrayList((Object[])new String[]{"2018", "april", "23"}), null);
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition1, partition2, partition3, partition4, partition5}));
        Partition[] parts = new Partition[]{this.client.getPartition(DB_NAME, this.sourceTable.getTableName(), partition1.getValues()), this.client.getPartition(DB_NAME, this.sourceTable.getTableName(), partition2.getValues()), this.client.getPartition(DB_NAME, this.sourceTable.getTableName(), partition3.getValues()), this.client.getPartition(DB_NAME, this.sourceTable.getTableName(), partition4.getValues()), this.client.getPartition(DB_NAME, this.sourceTable.getTableName(), partition5.getValues())};
        return parts;
    }

    protected Partition createPartition(Table table, List<String> values, String location) throws Exception {
        Partition partition = this.buildPartition(table, values, location);
        this.client.add_partition(partition);
        return this.client.getPartition(DB_NAME, table.getTableName(), partition.getValues());
    }

    private Partition buildPartition(Table table, List<String> values, String location) throws MetaException {
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(table.getDbName()).setTableName(table.getTableName()).setValues(values).addPartParam("test_exch_param_key", "test_exch_param_value").setInputFormat("TestInputFormat")).setOutputFormat("TestOutputFormat")).addStorageDescriptorParam("test_exch_sd_param_key", "test_exch_sd_param_value")).setCols(TestExchangePartitions.getYearMonthAndDayPartCols())).setLocation(location)).build(this.metaStore.getConf());
        return partition;
    }

    protected void checkExchangedPartitions(Table sourceTable, Table destTable, List<Partition> partitions) throws Exception {
        for (Partition partition : partitions) {
            Partition resultPart = this.client.getPartition(destTable.getDbName(), destTable.getTableName(), partition.getValues());
            Assert.assertNotNull((Object)resultPart);
            Assert.assertEquals((Object)destTable.getDbName(), (Object)resultPart.getDbName());
            Assert.assertEquals((Object)destTable.getTableName(), (Object)resultPart.getTableName());
            String partName = Warehouse.makePartName((List)sourceTable.getPartitionKeys(), (List)partition.getValues());
            Assert.assertEquals((Object)(destTable.getSd().getLocation() + "/" + partName), (Object)resultPart.getSd().getLocation());
            Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(resultPart.getSd().getLocation())));
            try {
                this.client.getPartition(sourceTable.getDbName(), sourceTable.getTableName(), partition.getValues());
                Assert.fail((String)("The partition ' " + partition.getValues().toString() + " ' should not exists, therefore NoSuchObjectException should have been thrown."));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partition.getSd().getLocation())));
            partition.getSd().setLocation(resultPart.getSd().getLocation());
            partition.setDbName(destTable.getDbName());
            partition.setTableName(destTable.getTableName());
            Assert.assertEquals((Object)partition, (Object)resultPart);
        }
    }

    protected void checkRemainingPartitions(Table sourceTable, Table destTable, List<Partition> partitions) throws Exception {
        for (Partition partition : partitions) {
            Partition resultPart = this.client.getPartition(sourceTable.getDbName(), sourceTable.getTableName(), partition.getValues());
            Assert.assertNotNull((Object)resultPart);
            Assert.assertEquals((Object)partition, (Object)resultPart);
            Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(partition.getSd().getLocation())));
            try {
                this.client.getPartition(destTable.getDbName(), destTable.getTableName(), partition.getValues());
                Assert.fail((String)("The partition '" + partition.getValues().toString() + "'should not exists, therefore NoSuchObjectException should have been thrown."));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            String partName = Warehouse.makePartName((List)sourceTable.getPartitionKeys(), (List)partition.getValues());
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(destTable.getSd().getLocation() + "/" + partName)));
        }
    }

    protected static Map<String, String> getPartitionSpec(Partition partition) {
        return TestExchangePartitions.getPartitionSpec(partition.getValues());
    }

    protected static Map<String, String> getPartitionSpec(List<String> values) {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        List<FieldSchema> partCols = TestExchangePartitions.getYearMonthAndDayPartCols();
        for (int i = 0; i < partCols.size(); ++i) {
            FieldSchema partCol = partCols.get(i);
            String value = values.get(i);
            partitionSpecs.put(partCol.getName(), value);
        }
        return partitionSpecs;
    }

    protected static List<FieldSchema> getYearMonthAndDayPartCols() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, STRING_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, STRING_COL_TYPE, "month part col"));
        cols.add(new FieldSchema(DAY_COL_NAME, STRING_COL_TYPE, "day part col"));
        return cols;
    }
}

