/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.ConditionalIgnoreOnSessionHiveMetastoreClient;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestAddPartitions
extends MetaStoreClientTest {
    private AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    protected static final String DB_NAME = "test_partition_db";
    protected static final String TABLE_NAME = "test_partition_table";
    protected static final String DEFAULT_PARAM_VALUE = "partparamvalue";
    protected static final String DEFAULT_PARAM_KEY = "partparamkey";
    protected static final String DEFAULT_YEAR_VALUE = "2017";
    protected static final String DEFAULT_COL_TYPE = "string";
    protected static final String YEAR_COL_NAME = "year";
    private static final String MONTH_COL_NAME = "month";
    private static final short MAX = -1;

    public TestAddPartitions(String name, AbstractMetaStoreService metaStore) {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(DB_NAME, true, true, true);
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(DB_NAME).create(this.client, this.metaStore.getConf());
    }

    @After
    public void tearDown() throws Exception {
        try {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.client = null;
        }
    }

    protected AbstractMetaStoreService getMetaStore() {
        return this.metaStore;
    }

    protected IMetaStoreClient getClient() {
        return this.client;
    }

    protected void setClient(IMetaStoreClient client) {
        this.client = client;
    }

    @Test
    public void testAddPartition() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), TestAddPartitions.getYearPartCol(), 1);
        Partition resultPart = this.client.add_partition(partition);
        Assert.assertNotNull((Object)resultPart);
        this.verifyPartition(table, "year=2017", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), 1);
    }

    @Test
    public void testAddPartitionTwoValues() throws Exception {
        String tableLocation = this.metaStore.getWarehouseRoot() + "/test_partition_table";
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getYearAndMonthPartCols(), tableLocation);
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), TestAddPartitions.getYearAndMonthPartCols(), 1);
        this.client.add_partition(partition);
        this.verifyPartition(table, "year=2017/month=march", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), 1);
    }

    @Test
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void addPartitionOtherCatalog() throws TException {
        int i;
        String catName = "add_partition_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "add_partition_database_in_other_catalog";
        Database db = new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        String tableName = "table_in_other_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(db).setTableName(tableName).addCol("id", "int")).addCol("name", DEFAULT_COL_TYPE)).addPartCol("partcol", DEFAULT_COL_TYPE).create(this.client, this.metaStore.getConf());
        Partition[] parts = new Partition[5];
        for (i = 0; i < parts.length; ++i) {
            parts[i] = new PartitionBuilder().inTable(table).addValue("a" + i).build(this.metaStore.getConf());
        }
        this.client.add_partition(parts[0]);
        Assert.assertEquals((long)2L, (long)this.client.add_partitions(Arrays.asList(parts[1], parts[2])));
        this.client.add_partitions(Arrays.asList(parts), true, false);
        for (i = 0; i < parts.length; ++i) {
            Partition fetched = this.client.getPartition(catName, dbName, tableName, Collections.singletonList("a" + i));
            Assert.assertEquals((Object)catName, (Object)fetched.getCatName());
            Assert.assertEquals((Object)dbName, (Object)fetched.getDbName());
            Assert.assertEquals((Object)tableName, (Object)fetched.getTableName());
        }
        this.client.dropDatabase(catName, dbName, true, true, true);
        this.client.dropCatalog(catName);
    }

    @Test(expected=InvalidObjectException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void noSuchCatalog() throws TException {
        String tableName = "table_for_no_such_catalog";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName(tableName).addCol("id", "int")).addCol("name", DEFAULT_COL_TYPE)).addPartCol("partcol", DEFAULT_COL_TYPE).create(this.client, this.metaStore.getConf());
        Partition part = new PartitionBuilder().inTable(table).addValue("a").build(this.metaStore.getConf());
        part.setCatName("nosuch");
        this.client.add_partition(part);
    }

    @Test
    public void testAddPartitionWithDefaultAttributes() throws Exception {
        Table table = this.createTable();
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addValue(DEFAULT_YEAR_VALUE).setCols(TestAddPartitions.getYearPartCol())).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).build(this.metaStore.getConf());
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)TABLE_NAME, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), (Object)part.getValues());
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.addAll(TestAddPartitions.getYearPartCol());
        cols.add(new FieldSchema("test_id", "int", "test col id"));
        cols.add(new FieldSchema("test_value", DEFAULT_COL_TYPE, "test col value"));
        Assert.assertEquals(cols, (Object)part.getSd().getCols());
        this.verifyPartitionAttributesDefaultValues(part, table.getSd().getLocation());
    }

    @Test
    public void testAddPartitionUpperCase() throws Exception {
        String tableLocation = this.metaStore.getWarehouseRoot() + "/test_partition_table";
        this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getMonthPartCol(), tableLocation);
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{"APRIL"}), TestAddPartitions.getMonthPartCol(), 1);
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "month=APRIL");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)TABLE_NAME, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)"APRIL", part.getValues().get(0));
        Assert.assertEquals((Object)(tableLocation + "/month=APRIL"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionUpperCaseDBAndTableName() throws Exception {
        String tableName = "test_add_part_table";
        String tableLocation = this.metaStore.getWarehouseRoot() + "/" + tableName.toUpperCase();
        this.createTable(DB_NAME, tableName, TestAddPartitions.getYearPartCol(), tableLocation);
        Partition partition = this.buildPartition(DB_NAME.toUpperCase(), tableName.toUpperCase(), "2013", tableLocation + "/year=2013");
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, tableName, "year=2013");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)tableName, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)(tableLocation + "/year=2013"), (Object)part.getSd().getLocation());
        Partition part1 = this.client.getPartition(DB_NAME.toUpperCase(), tableName.toUpperCase(), "year=2013");
        Assert.assertEquals((Object)part, (Object)part1);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionNonExistingDb() throws Exception {
        Partition partition = this.buildPartition("nonexistingdb", TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionNonExistingTable() throws Exception {
        Partition partition = this.buildPartition(DB_NAME, "nonexistingtable", DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullDb() throws Exception {
        Partition partition = this.buildPartition(null, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullTable() throws Exception {
        Partition partition = this.buildPartition(DB_NAME, null, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionEmptyDb() throws Exception {
        Partition partition = this.buildPartition("", TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionEmptyTable() throws Exception {
        Partition partition = this.buildPartition(DB_NAME, "", DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testAddPartitionAlreadyExists() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition1);
        this.client.add_partition(partition2);
    }

    @Test
    public void testAddPartitionsWithSameNameCaseSensitive() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getMonthPartCol(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"may"}), TestAddPartitions.getMonthPartCol(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"MAY"}), TestAddPartitions.getMonthPartCol(), 2);
        this.client.add_partition(partition1);
        this.client.add_partition(partition2);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "month=MAY");
        Assert.assertEquals((Object)"partparamvalue2", part.getParameters().get("partparamkey2"));
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/test_partition_table/month=MAY"), (Object)part.getSd().getLocation());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.setSd(null);
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitionNullColsInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setCols(null);
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertNull((Object)part.getSd().getCols());
    }

    @Test
    public void testAddPartitionEmptyColsInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setCols(new ArrayList());
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertTrue((boolean)part.getSd().getCols().isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullColTypeInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setType(null);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullColNameInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setName(null);
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitionInvalidColTypeInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setType("xyz");
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)"xyz", (Object)((FieldSchema)part.getSd().getCols().get(0)).getType());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionEmptySerdeInfo() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setSerdeInfo(null);
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitionNullLocation() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, this.metaStore.getWarehouseRoot() + "/addparttest2");
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, null);
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/addparttest2/year=2017"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionEmptyLocation() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, this.metaStore.getWarehouseRoot() + "/addparttest3");
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, "");
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/addparttest3/year=2017"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionNullLocationInTableToo() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, null);
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, null);
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/year=2017"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void testAddPartitionForView() throws Exception {
        String tableName = "test_add_partition_view";
        this.createView(tableName);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void testAddPartitionsForViewNullPartLocation() throws Exception {
        String tableName = "test_add_partition_view";
        this.createView(tableName);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE);
        partition.getSd().setLocation(null);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition});
        this.client.add_partitions((List)partitions);
        Partition part = this.client.getPartition(DB_NAME, tableName, "year=2017");
        Assert.assertNull((Object)part.getSd().getLocation());
    }

    @Test
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void testAddPartitionsForViewNullPartSd() throws Exception {
        String tableName = "test_add_partition_view";
        this.createView(tableName);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE);
        partition.setSd(null);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition});
        this.client.add_partitions((List)partitions);
        Partition part = this.client.getPartition(DB_NAME, tableName, "year=2017");
        Assert.assertNull((Object)part.getSd());
    }

    @Test
    public void testAddPartitionForExternalTable() throws Exception {
        String tableName = "part_add_ext_table";
        String tableLocation = this.metaStore.getWarehouseRoot() + "/" + tableName;
        String partitionLocation = tableLocation + "/addparttest";
        this.createExternalTable(tableName, tableLocation);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE, partitionLocation);
        this.client.add_partition(partition);
        Partition resultPart = this.client.getPartition(DB_NAME, tableName, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)resultPart);
        Assert.assertNotNull((Object)resultPart.getSd());
        Assert.assertEquals((Object)partitionLocation, (Object)resultPart.getSd().getLocation());
    }

    @Test
    public void testAddPartitionForExternalTableNullLocation() throws Exception {
        String tableName = "part_add_ext_table";
        this.createExternalTable(tableName, null);
        Table table = this.client.getTable(DB_NAME, tableName);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE, null);
        this.client.add_partition(partition);
        Partition resultPart = this.client.getPartition(DB_NAME, tableName, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)resultPart);
        Assert.assertNotNull((Object)resultPart.getSd());
        String defaultTableLocation = table.getSd().getLocation();
        String defaulPartitionLocation = defaultTableLocation + "/year=2017";
        Assert.assertEquals((Object)defaulPartitionLocation, (Object)resultPart.getSd().getLocation());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionTooManyValues() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), TestAddPartitions.getYearAndMonthPartCols(), 1);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNoPartColOnTable() throws Exception {
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).create(this.client, this.metaStore.getConf());
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNoColInPartition() throws Exception {
        this.createTable();
        Partition partition = ((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addValue(DEFAULT_YEAR_VALUE).setLocation(this.metaStore.getWarehouseRoot() + "/addparttest")).build(this.metaStore.getConf());
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitionDifferentNamesAndTypesInColAndTableCol() throws Exception {
        this.createTable();
        Partition partition = ((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addValue("1000").addCol("time", "int")).build(this.metaStore.getConf());
        this.client.add_partition(partition);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=1000");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)TABLE_NAME, (Object)part.getTableName());
        Assert.assertEquals((Object)"1000", part.getValues().get(0));
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNoValueInPartition() throws Exception {
        this.createTable();
        Partition partition = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol(YEAR_COL_NAME, DEFAULT_COL_TYPE)).setLocation(this.metaStore.getWarehouseRoot() + "/addparttest")).build(this.metaStore.getConf());
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionMorePartColInTable() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getYearAndMonthPartCols(), null);
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullPartition() throws Exception {
        this.client.add_partition(null);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionNullValues() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, null);
        partition.setValues(null);
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitionEmptyValue() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "");
        this.client.add_partition(partition);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)10);
        Assert.assertNotNull((Object)partitionNames);
        Assert.assertTrue((partitionNames.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"year=__HIVE_DEFAULT_PARTITION__", partitionNames.get(0));
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionSetInvalidLocation() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, "%^#$$%#$testlocation/part1");
        this.client.add_partition(partition);
    }

    @Test
    public void testAddPartitions() throws Exception {
        Table table = this.createTable();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), TestAddPartitions.getYearPartCol(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2016"}), TestAddPartitions.getYearPartCol(), 2);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2015"}), TestAddPartitions.getYearPartCol(), 3);
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        int numberOfCreatedParts = this.client.add_partitions(partitions);
        Assert.assertEquals((long)3L, (long)numberOfCreatedParts);
        this.verifyPartition(table, "year=2017", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), 1);
        this.verifyPartition(table, "year=2016", Lists.newArrayList((Object[])new String[]{"2016"}), 2);
        this.verifyPartition(table, "year=2015", Lists.newArrayList((Object[])new String[]{"2015"}), 3);
    }

    @Test
    public void testAddPartitionsMultipleValues() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getYearAndMonthPartCols(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), TestAddPartitions.getYearAndMonthPartCols(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "june"}), TestAddPartitions.getYearAndMonthPartCols(), 2);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2016", "march"}), TestAddPartitions.getYearAndMonthPartCols(), 3);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions);
        this.verifyPartition(table, "year=2017/month=march", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), 1);
        this.verifyPartition(table, "year=2017/month=june", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "june"}), 2);
        this.verifyPartition(table, "year=2016/month=march", Lists.newArrayList((Object[])new String[]{"2016", "march"}), 3);
    }

    @Test
    public void testAddPartitionsWithDefaultAttributes() throws Exception {
        Table table = this.createTable();
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addValue(DEFAULT_YEAR_VALUE).setCols(TestAddPartitions.getYearPartCol())).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).build(this.metaStore.getConf());
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        List parts = this.client.getPartitionsByNames(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{"year=2017"}));
        Assert.assertEquals((long)1L, (long)parts.size());
        Partition part = (Partition)parts.get(0);
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)TABLE_NAME, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), (Object)part.getValues());
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.addAll(TestAddPartitions.getYearPartCol());
        cols.add(new FieldSchema("test_id", "int", "test col id"));
        cols.add(new FieldSchema("test_value", DEFAULT_COL_TYPE, "test col value"));
        Assert.assertEquals(cols, (Object)part.getSd().getCols());
        this.verifyPartitionAttributesDefaultValues(part, table.getSd().getLocation());
    }

    @Test
    public void testAddPartitionsUpperCaseDBAndTableName() throws Exception {
        String tableName = "test_add_part_table";
        String tableLocation = this.metaStore.getWarehouseRoot() + "/" + tableName.toUpperCase();
        this.createTable(DB_NAME, tableName, TestAddPartitions.getYearPartCol(), tableLocation);
        Partition partition1 = this.buildPartition(DB_NAME.toUpperCase(), tableName.toUpperCase(), DEFAULT_YEAR_VALUE, tableLocation + "/year=2017");
        Partition partition2 = this.buildPartition(DB_NAME.toUpperCase(), tableName.toUpperCase(), "2018", tableLocation + "/year=2018");
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition1, partition2}));
        Partition part = this.client.getPartition(DB_NAME, tableName, "year=2017");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)tableName, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)(tableLocation + "/year=2017"), (Object)part.getSd().getLocation());
        part = this.client.getPartition(DB_NAME, tableName, "year=2018");
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)tableName, (Object)part.getTableName());
        Assert.assertEquals((Object)DB_NAME, (Object)part.getDbName());
        Assert.assertEquals((Object)(tableLocation + "/year=2018"), (Object)part.getSd().getLocation());
    }

    @Test
    public void testAddPartitionsUpperCaseDBAndTableNameInOnePart() throws Exception {
        String tableName = "test_add_part_table";
        String tableLocation = this.metaStore.getWarehouseRoot() + "/" + tableName.toUpperCase();
        this.createTable(DB_NAME, tableName, TestAddPartitions.getYearPartCol(), tableLocation);
        Partition partition1 = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE, tableLocation + "/year=2017");
        Partition partition2 = this.buildPartition(DB_NAME.toUpperCase(), tableName.toUpperCase(), "2018", tableLocation + "/year=2018");
        Partition partition3 = this.buildPartition(DB_NAME, tableName, "2019", tableLocation + "/year=2019");
        try {
            this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition1, partition2, partition3}));
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException e) {
            System.out.println((Object)e);
        }
        List partitionNames = this.client.listPartitionNames(DB_NAME, tableName, (short)-1);
        Assert.assertNotNull((Object)partitionNames);
        Assert.assertTrue((boolean)partitionNames.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullList() throws Exception {
        this.client.add_partitions(null);
    }

    @Test
    public void testAddPartitionsEmptyList() throws Exception {
        this.client.add_partitions(new ArrayList());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsDifferentTable() throws Exception {
        String tableName1 = "test_partition_table1";
        String tableName2 = "test_partition_table2";
        this.createTable(DB_NAME, tableName1, null);
        this.createTable(DB_NAME, tableName2, null);
        Partition partition1 = this.buildPartition(DB_NAME, tableName1, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, tableName2, "2016");
        Partition partition3 = this.buildPartition(DB_NAME, tableName1, "2018");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions);
    }

    @Test
    public void testAddPartitionsDifferentDBs() throws Exception {
        this.createDB("parttestdb2");
        this.createTable();
        this.createTable("parttestdb2", TABLE_NAME, null);
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition("parttestdb2", TABLE_NAME, "2016");
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, "2018");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.client.dropDatabase("parttestdb2", true, true, true);
    }

    @Test
    public void testAddPartitionsDuplicateInTheList() throws Exception {
        Table table = this.createTable();
        List<Partition> partitions = this.buildPartitions(table, Lists.newArrayList((Object[])new String[]{"2014", "2015", DEFAULT_YEAR_VALUE, DEFAULT_YEAR_VALUE, "2018", "2019"}));
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"MetaException should have happened.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertTrue((boolean)parts.isEmpty());
        for (Partition partition : partitions) {
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partition.getSd().getLocation())));
        }
    }

    @Test
    public void testAddPartitionsWithSameNameInTheListCaseSensitive() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "this");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, "next");
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, "THIS");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions);
        List parts = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertTrue((boolean)parts.contains("year=this"));
        Assert.assertTrue((boolean)parts.contains("year=next"));
        Assert.assertTrue((boolean)parts.contains("year=THIS"));
    }

    @Test
    public void testAddPartitionsAlreadyExists() throws Exception {
        Table table = this.createTable();
        String tableLocation = table.getSd().getLocation();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, "2016", tableLocation + "/year=2016a");
        this.client.add_partition(partition);
        List<Partition> partitions = this.buildPartitions(table, Lists.newArrayList((Object[])new String[]{"2014", "2015", "2016", DEFAULT_YEAR_VALUE, "2018"}));
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"AlreadyExistsException should have happened.");
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertEquals((Object)partition.getValues(), (Object)((Partition)parts.get(0)).getValues());
        for (Partition part : partitions) {
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
        }
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNonExistingTable() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition(DB_NAME, "nonexistingtable", DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test(expected=InvalidObjectException.class)
    public void testAddPartitionsNonExistingDb() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition("nonexistingdb", TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullDb() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition2.setDbName(null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsEmptyDb() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition("", TABLE_NAME, DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullTable() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition2.setTableName(null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsEmptyTable() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition2 = this.buildPartition(DB_NAME, "", DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
    }

    @Test
    public void testAddPartitionsOneInvalid() throws Exception {
        this.createTable();
        String tableLocation = this.metaStore.getWarehouseRoot() + "/test_partition_table";
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2016", tableLocation + "/year=2016");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, tableLocation + "/year=2017");
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2015", "march"}), TestAddPartitions.getYearAndMonthPartCols(), 1);
        partition3.getSd().setLocation(tableLocation + "/year=2015/month=march");
        Partition partition4 = this.buildPartition(DB_NAME, TABLE_NAME, "2018", tableLocation + "/year=2018");
        Partition partition5 = this.buildPartition(DB_NAME, TABLE_NAME, "2019", tableLocation + "/year=2019");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        partitions.add(partition4);
        partitions.add(partition5);
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"MetaException should have happened.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertTrue((boolean)parts.isEmpty());
        for (Partition part : partitions) {
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
        }
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.setSd(null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition);
        this.client.add_partitions(partitions);
    }

    @Test
    public void testAddPartitionsNullColsInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setCols(null);
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertNull((Object)part.getSd().getCols());
    }

    @Test
    public void testAddPartitionsEmptyColsInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setCols(new ArrayList());
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertTrue((boolean)part.getSd().getCols().isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullColTypeInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setType(null);
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullColNameInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setName(null);
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
    }

    @Test
    public void testAddPartitionsInvalidColTypeInSd() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ((FieldSchema)partition.getSd().getCols().get(0)).setType("xyz");
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, (List)Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}));
        Assert.assertNotNull((Object)part);
        Assert.assertEquals((Object)"xyz", (Object)((FieldSchema)part.getSd().getCols().get(0)).getType());
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsEmptySerdeInfo() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        partition.getSd().setSerdeInfo(null);
        this.client.add_partitions((List)Lists.newArrayList((Object[])new Partition[]{partition}));
    }

    @Test
    public void testAddPartitionNullAndEmptyLocation() throws Exception {
        this.createTable(DB_NAME, TABLE_NAME, this.metaStore.getWarehouseRoot() + "/addparttest2");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, null);
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, "2016", "");
        partitions.add(partition1);
        partitions.add(partition2);
        this.client.add_partitions(partitions);
        Partition part1 = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/addparttest2/year=2017"), (Object)part1.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part1.getSd().getLocation())));
        Partition part2 = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2016");
        Assert.assertEquals((Object)(this.metaStore.getWarehouseRoot() + "/addparttest2/year=2016"), (Object)part2.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part2.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionsNullLocationInTableToo() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE, null);
        partitions.add(partition);
        this.client.add_partitions(partitions);
        Partition part = this.client.getPartition(DB_NAME, TABLE_NAME, "year=2017");
        Assert.assertEquals((Object)(table.getSd().getLocation() + "/year=2017"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.metaStore.isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test(expected=MetaException.class)
    @ConditionalIgnoreOnSessionHiveMetastoreClient
    public void testAddPartitionsForView() throws Exception {
        String tableName = "test_add_partition_view";
        this.createView(tableName);
        Partition partition = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition});
        this.client.add_partitions((List)partitions);
    }

    @Test
    public void testAddPartitionsForExternalTable() throws Exception {
        String tableName = "part_add_ext_table";
        String tableLocation = this.metaStore.getWarehouseRoot() + "/" + tableName;
        this.createExternalTable(tableName, tableLocation);
        String location1 = tableLocation + "/addparttest2017";
        String location2 = tableLocation + "/addparttest2018";
        Partition partition1 = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE, location1);
        Partition partition2 = this.buildPartition(DB_NAME, tableName, "2018", location2);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2});
        this.client.add_partitions((List)partitions);
        List resultParts = this.client.getPartitionsByNames(DB_NAME, tableName, (List)Lists.newArrayList((Object[])new String[]{"year=2017", "year=2018"}));
        Assert.assertNotNull((Object)resultParts);
        Assert.assertEquals((long)2L, (long)resultParts.size());
        if (((String)((Partition)resultParts.get(0)).getValues().get(0)).equals(DEFAULT_YEAR_VALUE)) {
            Assert.assertEquals((Object)location1, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)location2, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        } else {
            Assert.assertEquals((Object)location2, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)location1, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        }
    }

    @Test
    public void testAddPartitionsForExternalTableNullLocation() throws Exception {
        String tableName = "part_add_ext_table";
        this.createExternalTable(tableName, null);
        Table table = this.client.getTable(DB_NAME, tableName);
        Partition partition1 = this.buildPartition(DB_NAME, tableName, DEFAULT_YEAR_VALUE, null);
        Partition partition2 = this.buildPartition(DB_NAME, tableName, "2018", null);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2});
        this.client.add_partitions((List)partitions);
        List resultParts = this.client.getPartitionsByNames(DB_NAME, tableName, (List)Lists.newArrayList((Object[])new String[]{"year=2017", "year=2018"}));
        Assert.assertNotNull((Object)resultParts);
        Assert.assertEquals((long)2L, (long)resultParts.size());
        String defaultTableLocation = table.getSd().getLocation();
        String defaultPartLocation1 = defaultTableLocation + "/year=2017";
        String defaultPartLocation2 = defaultTableLocation + "/year=2018";
        if (((String)((Partition)resultParts.get(0)).getValues().get(0)).equals(DEFAULT_YEAR_VALUE)) {
            Assert.assertEquals((Object)defaultPartLocation1, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)defaultPartLocation2, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        } else {
            Assert.assertEquals((Object)defaultPartLocation2, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)defaultPartLocation1, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        }
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNoValueInPartition() throws Exception {
        this.createTable();
        Partition partition = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol(YEAR_COL_NAME, DEFAULT_COL_TYPE)).setLocation(this.metaStore.getWarehouseRoot() + "/addparttest")).build(this.metaStore.getConf());
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsMorePartColInTable() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getYearAndMonthPartCols(), null);
        Partition partition = this.buildPartition(table, DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullPartition() throws Exception {
        ArrayList<Object> partitions = new ArrayList<Object>();
        partitions.add(null);
        this.client.add_partitions(partitions);
    }

    @Test(expected=MetaException.class)
    public void testAddPartitionsNullValues() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(table, null);
        partition.setValues(null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition);
        this.client.add_partitions(partitions);
    }

    @Test
    public void testAddPartitionsEmptyValue() throws Exception {
        Table table = this.createTable();
        Partition partition = this.buildPartition(table, "");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition);
        this.client.add_partitions(partitions);
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)partitionNames);
        Assert.assertTrue((partitionNames.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"year=__HIVE_DEFAULT_PARTITION__", partitionNames.get(0));
    }

    @Test
    public void testAddPartitionsInvalidLocation() throws Exception {
        Table table = this.createTable();
        String tableLocation = table.getSd().getLocation();
        HashMap<String, String> valuesAndLocations = new HashMap<String, String>();
        valuesAndLocations.put("2014", tableLocation + "/year=2014");
        valuesAndLocations.put("2015", tableLocation + "/year=2015");
        valuesAndLocations.put("2016", "invalidhost:80000/wrongfolder");
        valuesAndLocations.put(DEFAULT_YEAR_VALUE, tableLocation + "/year=2017");
        valuesAndLocations.put("2018", tableLocation + "/year=2018");
        List<Partition> partitions = this.buildPartitions(table, valuesAndLocations);
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"MetaException should have happened.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertTrue((boolean)parts.isEmpty());
        for (Partition partition : partitions) {
            if ("invalidhost:80000/wrongfolder".equals(partition.getSd().getLocation())) continue;
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partition.getSd().getLocation())));
        }
    }

    @Test
    public void testAddPartitionsMoreThanThreadCountsOneFails() throws Exception {
        Table table = this.createTable();
        String tableLocation = table.getSd().getLocation();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (int i = 0; i < 50; ++i) {
            String value = String.valueOf(2000 + i);
            Object location = tableLocation + "/year=" + value;
            if (i == 30) {
                location = "invalidhost:80000/wrongfolder";
            }
            Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, value, (String)location);
            partitions.add(partition);
        }
        try {
            this.client.add_partitions(partitions);
            Assert.fail((String)"MetaException should have happened.");
        }
        catch (MetaException i) {
            // empty catch block
        }
        List parts = this.client.listPartitions(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertNotNull((Object)parts);
        Assert.assertTrue((boolean)parts.isEmpty());
        for (Partition partition : partitions) {
            if ("invalidhost:80000/wrongfolder".equals(partition.getSd().getLocation())) continue;
            Assert.assertFalse((boolean)this.metaStore.isPathExists(new Path(partition.getSd().getLocation())));
        }
    }

    @Test
    public void testAddParts() throws Exception {
        Table table = this.createTable();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), TestAddPartitions.getYearPartCol(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2016"}), TestAddPartitions.getYearPartCol(), 2);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2015"}), TestAddPartitions.getYearPartCol(), 3);
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        List addedPartitions = this.client.add_partitions(partitions, false, false);
        Assert.assertNull((Object)addedPartitions);
        this.verifyPartition(table, "year=2017", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE}), 1);
        this.verifyPartition(table, "year=2016", Lists.newArrayList((Object[])new String[]{"2016"}), 2);
        this.verifyPartition(table, "year=2015", Lists.newArrayList((Object[])new String[]{"2015"}), 3);
    }

    @Test
    public void testAddPartsMultipleValues() throws Exception {
        Table table = this.createTable(DB_NAME, TABLE_NAME, TestAddPartitions.getYearAndMonthPartCols(), this.metaStore.getWarehouseRoot() + "/test_partition_table");
        Partition partition1 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), TestAddPartitions.getYearAndMonthPartCols(), 1);
        Partition partition2 = this.buildPartition(Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "june"}), TestAddPartitions.getYearAndMonthPartCols(), 2);
        Partition partition3 = this.buildPartition(Lists.newArrayList((Object[])new String[]{"2016", "march"}), TestAddPartitions.getYearAndMonthPartCols(), 3);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        List addedPartitions = this.client.add_partitions(partitions, false, true);
        Assert.assertNotNull((Object)addedPartitions);
        Assert.assertEquals((long)3L, (long)addedPartitions.size());
        this.verifyPartition(table, "year=2017/month=march", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "march"}), 1);
        this.verifyPartition(table, "year=2017/month=june", Lists.newArrayList((Object[])new String[]{DEFAULT_YEAR_VALUE, "june"}), 2);
        this.verifyPartition(table, "year=2016/month=march", Lists.newArrayList((Object[])new String[]{"2016", "march"}), 3);
    }

    @Test(expected=MetaException.class)
    public void testAddPartsNullList() throws Exception {
        this.client.add_partitions(null, false, false);
    }

    @Test
    public void testAddPartsEmptyList() throws Exception {
        List addedPartitions = this.client.add_partitions(new ArrayList(), false, true);
        Assert.assertNotNull((Object)addedPartitions);
        Assert.assertTrue((boolean)addedPartitions.isEmpty());
    }

    @Test(expected=MetaException.class)
    public void testAddPartsDifferentTable() throws Exception {
        String tableName1 = "test_partition_table1";
        String tableName2 = "test_partition_table2";
        this.createTable(DB_NAME, tableName1, null);
        this.createTable(DB_NAME, tableName2, null);
        Partition partition1 = this.buildPartition(DB_NAME, tableName1, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, tableName2, "2016");
        Partition partition3 = this.buildPartition(DB_NAME, tableName1, "2018");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions, false, false);
    }

    @Test
    public void testAddPartsDifferentDBs() throws Exception {
        this.createDB("parttestdb2");
        this.createTable();
        this.createTable("parttestdb2", TABLE_NAME, null);
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition("parttestdb2", TABLE_NAME, "2016");
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, "2018");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        try {
            this.client.add_partitions(partitions, false, false);
            Assert.fail((String)"MetaException should have been thrown.");
        }
        catch (MetaException metaException) {
            // empty catch block
        }
        this.client.dropDatabase("parttestdb2", true, true, true);
    }

    @Test(expected=MetaException.class)
    public void testAddPartsDuplicateInTheList() throws Exception {
        this.createTable();
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions, true, false);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testAddPartsAlreadyExists() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2015");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        this.client.add_partitions(partitions, false, false);
    }

    @Test
    public void testAddPartsAlreadyExistsIfExistsTrue() throws Exception {
        this.createTable();
        Partition partition = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        this.client.add_partition(partition);
        Partition partition1 = this.buildPartition(DB_NAME, TABLE_NAME, "2015");
        Partition partition2 = this.buildPartition(DB_NAME, TABLE_NAME, DEFAULT_YEAR_VALUE);
        Partition partition3 = this.buildPartition(DB_NAME, TABLE_NAME, "2016");
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        List addedPartitions = this.client.add_partitions(partitions, true, true);
        Assert.assertEquals((long)2L, (long)addedPartitions.size());
        List partitionNames = this.client.listPartitionNames(DB_NAME, TABLE_NAME, (short)-1);
        Assert.assertEquals((long)3L, (long)partitionNames.size());
        Assert.assertTrue((boolean)partitionNames.contains("year=2015"));
        Assert.assertTrue((boolean)partitionNames.contains("year=2016"));
        Assert.assertTrue((boolean)partitionNames.contains("year=2017"));
    }

    @Test(expected=MetaException.class)
    public void testAddPartsNullPartition() throws Exception {
        ArrayList<Object> partitions = new ArrayList<Object>();
        partitions.add(null);
        this.client.add_partitions(partitions, false, false);
    }

    private void createDB(String dbName) throws TException {
        new DatabaseBuilder().setName(dbName).create(this.client, this.metaStore.getConf());
    }

    private Table createTable() throws Exception {
        return this.createTable(DB_NAME, TABLE_NAME, this.metaStore.getWarehouseRoot() + "/test_partition_table");
    }

    protected Table createTable(String dbName, String tableName, String location) throws Exception {
        return this.createTable(dbName, tableName, TestAddPartitions.getYearPartCol(), location);
    }

    protected Table createTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addTableParam("partTestTableParamKey", "partTestTableParamValue").setPartCols(partCols).addStorageDescriptorParam("partTestSDParamKey", "partTestSDParamValue")).setSerdeName(tableName)).setStoredAsSubDirectories(false)).addSerdeParam("partTestSerdeParamKey", "partTestSerdeParamValue")).setLocation(location)).create(this.client, this.metaStore.getConf());
        return this.client.getTable(dbName, tableName);
    }

    protected void createExternalTable(String tableName, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addPartCol(YEAR_COL_NAME, DEFAULT_COL_TYPE).addTableParam("EXTERNAL", "TRUE").setLocation(location)).create(this.client, this.metaStore.getConf());
    }

    protected Partition buildPartition(String dbName, String tableName, String value) throws MetaException {
        return this.buildPartition(dbName, tableName, value, this.metaStore.getWarehouseRoot() + "/" + tableName + "/addparttest");
    }

    protected Partition buildPartition(Table table, String value) throws MetaException {
        return this.buildPartition(table.getDbName(), table.getTableName(), value, table.getSd().getLocation() + "/addparttest");
    }

    protected Partition buildPartition(String dbName, String tableName, String value, String location) throws MetaException {
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(dbName).setTableName(tableName).addValue(value).addCol(YEAR_COL_NAME, DEFAULT_COL_TYPE)).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addPartParam(DEFAULT_PARAM_KEY, DEFAULT_PARAM_VALUE).setLocation(location)).build(this.metaStore.getConf());
        return partition;
    }

    private Partition buildPartition(List<String> values, List<FieldSchema> partCols, int index) throws MetaException {
        Partition partition = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).setValues(values).addPartParam(DEFAULT_PARAM_KEY + index, DEFAULT_PARAM_VALUE + index).setInputFormat("TestInputFormat" + index)).setOutputFormat("TestOutputFormat" + index)).setSerdeName("partserde" + index)).addStorageDescriptorParam("partsdkey" + index, "partsdvalue" + index)).setCols(partCols)).setCreateTime(123456).setLastAccessTime(123456).addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).build(this.metaStore.getConf());
        return partition;
    }

    private static List<FieldSchema> getYearAndMonthPartCols() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        cols.add(new FieldSchema(MONTH_COL_NAME, DEFAULT_COL_TYPE, "month part col"));
        return cols;
    }

    private static List<FieldSchema> getYearPartCol() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(YEAR_COL_NAME, DEFAULT_COL_TYPE, "year part col"));
        return cols;
    }

    private static List<FieldSchema> getMonthPartCol() {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(MONTH_COL_NAME, DEFAULT_COL_TYPE, "month part col"));
        return cols;
    }

    protected void verifyPartition(Table table, String name, List<String> values, int index) throws Exception {
        Partition part = this.client.getPartition(table.getDbName(), table.getTableName(), name);
        Assert.assertNotNull((String)"The partition should not be null.", (Object)part);
        Assert.assertEquals((String)"The table name in the partition is not correct.", (Object)table.getTableName(), (Object)part.getTableName());
        List partValues = part.getValues();
        Assert.assertEquals((long)values.size(), (long)partValues.size());
        Assert.assertTrue((String)"The partition has wrong values.", (boolean)partValues.containsAll(values));
        Assert.assertEquals((String)"The DB name in the partition is not correct.", (Object)table.getDbName(), (Object)part.getDbName());
        Assert.assertEquals((String)"The last access time is not correct.", (long)123456L, (long)part.getLastAccessTime());
        Assert.assertNotEquals((long)123456L, (long)part.getCreateTime());
        Assert.assertEquals((String)"The partition's parameter map should contain the partparamkey - partparamvalue pair.", (Object)(DEFAULT_PARAM_VALUE + index), part.getParameters().get(DEFAULT_PARAM_KEY + index));
        StorageDescriptor sd = part.getSd();
        Assert.assertNotNull((String)"The partition's storage descriptor must not be null.", (Object)sd);
        Assert.assertEquals((String)"The input format is not correct.", (Object)("TestInputFormat" + index), (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format is not correct.", (Object)("TestOutputFormat" + index), (Object)sd.getOutputFormat());
        Assert.assertEquals((String)"The serdeInfo name is not correct.", (Object)("partserde" + index), (Object)sd.getSerdeInfo().getName());
        Assert.assertEquals((String)"The parameter map of the partition's storage descriptor should contain the partsdkey - partsdvalue pair.", (Object)("partsdvalue" + index), sd.getParameters().get("partsdkey" + index));
        Assert.assertEquals((String)"The parameter's location is not correct.", (Object)(this.metaStore.getWarehouseRoot() + "/test_partition_table/" + name), (Object)sd.getLocation());
        Assert.assertTrue((String)"The parameter's location should exist on the file system.", (boolean)this.metaStore.isPathExists(new Path(sd.getLocation())));
        Assert.assertFalse((String)"The partition should not inherit the table parameters.", (boolean)part.getParameters().keySet().contains(table.getParameters().keySet()));
    }

    protected void verifyPartitionAttributesDefaultValues(Partition partition, String tableLocation) {
        Assert.assertNotEquals((String)"The partition's last access time should be set.", (long)0L, (long)partition.getLastAccessTime());
        Assert.assertNotEquals((String)"The partition's create time should be set.", (long)0L, (long)partition.getCreateTime());
        Assert.assertEquals((String)"The partition has to have the 'transient_lastDdlTime' parameter per default.", (long)1L, (long)partition.getParameters().size());
        Assert.assertNotNull((String)"The partition has to have the 'transient_lastDdlTime' parameter per default.", partition.getParameters().get("transient_lastDdlTime"));
        StorageDescriptor sd = partition.getSd();
        Assert.assertNotNull((String)"The storage descriptor of the partition must not be null.", (Object)sd);
        Assert.assertEquals((String)"The partition location is not correct.", (Object)(tableLocation + "/year=2017"), (Object)sd.getLocation());
        Assert.assertEquals((String)"The input format doesn't have the default value.", (Object)"org.apache.hadoop.hive.ql.io.HiveInputFormat", (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format doesn't have the default value.", (Object)"org.apache.hadoop.hive.ql.io.HiveOutputFormat", (Object)sd.getOutputFormat());
        Assert.assertFalse((String)"The compressed attribute doesn't have the default value.", (boolean)sd.isCompressed());
        Assert.assertFalse((String)"The storedAsSubDirectories attribute doesn't have the default value.", (boolean)sd.isStoredAsSubDirectories());
        Assert.assertEquals((String)"The numBuckets attribute doesn't have the default value.", (long)0L, (long)sd.getNumBuckets());
        Assert.assertTrue((String)"The default value of the attribute 'bucketCols' should be an empty list.", (boolean)sd.getBucketCols().isEmpty());
        Assert.assertTrue((String)"The default value of the attribute 'sortCols' should be an empty list.", (boolean)sd.getSortCols().isEmpty());
        Assert.assertTrue((String)"Per default the storage descriptor parameters should be empty.", (boolean)sd.getParameters().isEmpty());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        Assert.assertNotNull((String)"The serdeInfo attribute should not be null.", (Object)serdeInfo);
        Assert.assertNull((String)"The default value of the serde's name attribute should be null.", (Object)serdeInfo.getName());
        Assert.assertEquals((String)"The serde's 'serializationLib' attribute doesn't have the default value.", (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (Object)serdeInfo.getSerializationLib());
        Assert.assertTrue((String)"Per default the serde info parameters should be empty.", (boolean)serdeInfo.getParameters().isEmpty());
        SkewedInfo skewedInfo = sd.getSkewedInfo();
        Assert.assertTrue((String)"Per default the skewedInfo column names list should be empty.", (boolean)skewedInfo.getSkewedColNames().isEmpty());
        Assert.assertTrue((String)"Per default the skewedInfo column value list should be empty.", (boolean)skewedInfo.getSkewedColValues().isEmpty());
        Assert.assertTrue((String)"Per default the skewedInfo column value location map should be empty.", (boolean)skewedInfo.getSkewedColValueLocationMaps().isEmpty());
    }

    private List<Partition> buildPartitions(Table table, List<String> values) throws MetaException {
        String tableLocation = table.getSd().getLocation();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String value : values) {
            Partition partition = this.buildPartition(table.getDbName(), table.getTableName(), value, tableLocation + "/year=" + value);
            partitions.add(partition);
        }
        return partitions;
    }

    private List<Partition> buildPartitions(Table table, Map<String, String> valuesAndLocations) throws MetaException {
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (Map.Entry<String, String> valueAndLocation : valuesAndLocations.entrySet()) {
            Partition partition = this.buildPartition(table.getDbName(), table.getTableName(), valueAndLocation.getKey(), valueAndLocation.getValue());
            partitions.add(partition);
        }
        return partitions;
    }

    private void createView(String tableName) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(tableName).setType("VIRTUAL_VIEW").addCol("test_id", "int", "test col id")).addCol("test_value", DEFAULT_COL_TYPE, "test col value")).addPartCol(YEAR_COL_NAME, DEFAULT_COL_TYPE).setLocation(null)).create(this.client, this.metaStore.getConf());
    }
}

