/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreCheckinTest.class})
public class TestRawStoreProxy {
    @Test
    public void testExceptionDispatch() throws Throwable {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLIENT_SOCKET_TIMEOUT, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        RawStoreProxy rsp = new RawStoreProxy(conf, conf, TestStore.class);
        try {
            rsp.invoke(null, TestStore.class.getMethod("exceptions", new Class[0]), new Object[0]);
            Assert.fail((String)"an exception is expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Thread.sleep(20L);
        rsp.invoke(null, TestStore.class.getMethod("noopMethod", new Class[0]), new Object[0]);
    }

    static class TestStore
    extends ObjectStore {
        TestStore() {
        }

        public void setConf(Configuration conf) {
        }

        public void noopMethod() throws MetaException {
            Deadline.checkTimeout();
        }

        public void exceptions() throws IllegalStateException, MetaException {
            Deadline.checkTimeout();
            throw new IllegalStateException("throwing an exception");
        }
    }
}

