/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.jdo.PersistenceManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPackageJdo {
    private static final String TMPDIR = System.getProperty("java.io.tmpdir", "target/tmp");
    private final Configuration conf = MetastoreConf.newMetastoreConf();
    private final String url1 = "jdbc:derby:;databaseName=" + TMPDIR + "/test_meta_mapping_db1;create=true";
    private final String url2 = "jdbc:derby:;databaseName=" + TMPDIR + "/test_meta_mapping_db2;create=true";
    private final String password = "mine";

    @Before
    public void setup() throws Exception {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)this.url1);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD, (String)"mine");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME, (String)"APP");
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER, (String)"org.apache.derby.jdbc.EmbeddedDriver");
        TestTxnDbUtil.prepDb(this.conf);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)this.url2);
        PersistenceManagerProvider.updatePmfProperties((Configuration)this.conf);
        PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();
        HashSet classes = new HashSet();
        String packageName = "org/apache/hadoop/hive/metastore/model/";
        for (File mfile : new File(".", "src/main/java/" + packageName).listFiles()) {
            Object fileName = mfile.getName();
            if (!((String)fileName).endsWith(".java") || ((String)fileName).contains("FetchGroups")) continue;
            fileName = packageName.replace("/", ".") + ((String)fileName).substring(0, ((String)fileName).length() - 5);
            classes.add(this.getClass().getClassLoader().loadClass((String)fileName));
        }
        for (Class clazz : classes) {
            try {
                pm.makePersistent(JavaUtils.newInstance((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]));
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void verifySchema() throws Exception {
        Connection connection1;
        Connection connection2 = TestTxnDbUtil.getConnection(this.conf);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)this.url1);
        try (Connection conn1 = connection1 = TestTxnDbUtil.getConnection(this.conf);
             Connection conn2 = connection2;){
            Set<String> tables1 = this.getTableNames(conn1);
            Set<String> tables2 = this.getTableNames(conn2);
            Assert.assertFalse((tables1.isEmpty() || tables2.isEmpty() ? 1 : 0) != 0);
            for (String table : tables2) {
                ResultSet colRS1 = connection1.getMetaData().getColumns(null, "APP", table, null);
                ResultSet colRS2 = connection2.getMetaData().getColumns(null, "APP", table, null);
                HashSet<ColumnInfo> columnInfos1 = new HashSet<ColumnInfo>();
                HashSet<ColumnInfo> columnInfos2 = new HashSet<ColumnInfo>();
                while (colRS1.next() && colRS2.next()) {
                    columnInfos1.add(new ColumnInfo(colRS1.getString("COLUMN_NAME"), colRS1.getObject("DATA_TYPE"), colRS1.getObject("COLUMN_SIZE"), colRS1.getString("IS_NULLABLE")));
                    columnInfos2.add(new ColumnInfo(colRS2.getString("COLUMN_NAME"), colRS2.getObject("DATA_TYPE"), colRS2.getObject("COLUMN_SIZE"), colRS2.getString("IS_NULLABLE")));
                }
                Assert.assertEquals((String)("Different columns found in the table: " + table), columnInfos1, columnInfos2);
                Assert.assertFalse((colRS1.next() || colRS2.next() ? 1 : 0) != 0);
            }
        }
    }

    private Set<String> getTableNames(Connection connection) throws Exception {
        HashSet<String> tables = new HashSet<String>();
        try (ResultSet rs2 = connection.getMetaData().getTables(null, "APP", null, new String[]{"TABLE"});){
            while (rs2.next()) {
                tables.add(rs2.getString("TABLE_NAME"));
            }
        }
        return tables;
    }

    private static class ColumnInfo {
        final String columnName;
        final Object dataType;
        final Object columnSize;
        final Object nullable;

        public ColumnInfo(String columnName, Object dataType, Object columnSize, Object nullable) {
            this.columnName = columnName;
            this.dataType = dataType;
            this.columnSize = columnSize;
            this.nullable = nullable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnInfo that = (ColumnInfo)o;
            return Objects.equals(this.columnName, that.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.columnName);
        }

        public String toString() {
            return "columnName=" + this.columnName + ", dataType=" + this.dataType + ", columnSize=" + this.columnSize + ", nullable: " + this.nullable;
        }
    }
}

