/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.metastore.HiveMetaStoreChecker;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MetastoreUnitTest.class})
public class TestMsckCheckPartitions {
    @Test
    public void testNumberOfListStatusCalls() throws IOException, MetastoreException {
        LocalFileSystem mockFs = (LocalFileSystem)Mockito.mock(LocalFileSystem.class);
        Path tableLocation = new Path("mock:///tmp/testTable");
        Path countryUS = new Path(tableLocation, "country=US");
        Path countryIND = new Path(tableLocation, "country=IND");
        Path cityPA = new Path(countryUS, "city=PA");
        Path citySF = new Path(countryUS, "city=SF");
        Path cityBOM = new Path(countryIND, "city=BOM");
        Path cityDEL = new Path(countryIND, "city=DEL");
        Path paData = new Path(cityPA, "datafile");
        Path sfData = new Path(citySF, "datafile");
        Path bomData = new Path(cityBOM, "datafile");
        Path delData = new Path(cityDEL, "datafile");
        FileStatus[] allCountries = this.getMockFileStatus(countryUS, countryIND);
        this.mockListStatusIterator(mockFs, tableLocation, allCountries);
        FileStatus[] filesInUS = this.getMockFileStatus(cityPA, citySF);
        this.mockListStatusIterator(mockFs, countryUS, filesInUS);
        FileStatus[] filesInInd = this.getMockFileStatus(cityBOM, cityDEL);
        this.mockListStatusIterator(mockFs, countryIND, filesInInd);
        FileStatus[] paFiles = this.getMockFileStatus(paData);
        this.mockListStatusIterator(mockFs, cityPA, paFiles);
        FileStatus[] sfFiles = this.getMockFileStatus(sfData);
        this.mockListStatusIterator(mockFs, citySF, sfFiles);
        FileStatus[] bomFiles = this.getMockFileStatus(bomData);
        this.mockListStatusIterator(mockFs, cityBOM, bomFiles);
        FileStatus[] delFiles = this.getMockFileStatus(delData);
        this.mockListStatusIterator(mockFs, cityDEL, delFiles);
        HiveMetaStoreChecker checker = new HiveMetaStoreChecker((IMetaStoreClient)Mockito.mock(IMetaStoreClient.class), MetastoreConf.newMetastoreConf());
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        HashSet result = new HashSet();
        checker.checkPartitionDirs(executorService, tableLocation, result, (FileSystem)mockFs, Arrays.asList("country", "city"));
        ((LocalFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.times((int)3))).listStatusIterator((Path)ArgumentMatchers.any(Path.class));
        Assert.assertEquals((String)"msck should have found 4 unknown partitions", (long)4L, (long)result.size());
    }

    private void mockListStatusIterator(LocalFileSystem mockFs, Path location, final FileStatus[] fileStatuses) throws IOException {
        Mockito.when((Object)mockFs.listStatusIterator(location)).thenReturn((Object)new RemoteIterator<FileStatus>(){
            private int i = 0;

            public boolean hasNext() throws IOException {
                return this.i < fileStatuses.length;
            }

            public FileStatus next() throws IOException {
                return fileStatuses[this.i++];
            }
        });
    }

    private FileStatus[] getMockFileStatus(Path ... paths) throws IOException {
        FileStatus[] result = new FileStatus[paths.length];
        int i = 0;
        for (Path p : paths) {
            result[i++] = this.createMockFileStatus(p);
        }
        return result;
    }

    private FileStatus createMockFileStatus(Path p) {
        FileStatus mock = (FileStatus)Mockito.mock(FileStatus.class);
        Mockito.when((Object)mock.getPath()).thenReturn((Object)p);
        if (p.toString().contains("datafile")) {
            Mockito.when((Object)mock.isDirectory()).thenReturn((Object)false);
        } else {
            Mockito.when((Object)mock.isDirectory()).thenReturn((Object)true);
        }
        return mock;
    }
}

