/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreInitContext;
import org.apache.hadoop.hive.metastore.MetaStoreInitListener;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreListenersError {
    @Test
    public void testInitListenerException() throws Throwable {
        System.setProperty("hive.metastore.init.hooks", ErrorInitListener.class.getName());
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        int port = MetaStoreTestUtils.findFreePort();
        try {
            HiveMetaStore.startMetaStore((int)port, (HadoopThriftAuthBridge)HadoopThriftAuthBridge.getBridge(), (Configuration)conf);
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertEquals(MetaException.class, throwable.getClass());
            Assert.assertEquals((Object)"Failed to instantiate listener named: org.apache.hadoop.hive.metastore.TestMetaStoreListenersError$ErrorInitListener, reason: java.lang.IllegalArgumentException: exception on constructor", (Object)throwable.getMessage());
        }
    }

    @Test
    public void testEventListenerException() throws Throwable {
        System.setProperty("hive.metastore.init.hooks", "");
        System.setProperty("hive.metastore.event.listeners", ErrorEventListener.class.getName());
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        int port = MetaStoreTestUtils.findFreePort();
        try {
            HiveMetaStore.startMetaStore((int)port, (HadoopThriftAuthBridge)HadoopThriftAuthBridge.getBridge(), (Configuration)conf);
            Assert.fail();
        }
        catch (Throwable throwable) {
            Assert.assertEquals(MetaException.class, throwable.getClass());
            Assert.assertEquals((Object)"Failed to instantiate listener named: org.apache.hadoop.hive.metastore.TestMetaStoreListenersError$ErrorEventListener, reason: java.lang.IllegalArgumentException: exception on constructor", (Object)throwable.getMessage());
        }
    }

    public static class ErrorInitListener
    extends MetaStoreInitListener {
        public ErrorInitListener(Configuration config) {
            super(config);
            throw new IllegalArgumentException("exception on constructor");
        }

        public void onInit(MetaStoreInitContext context) throws MetaException {
        }
    }

    public static class ErrorEventListener
    extends MetaStoreEventListener {
        public ErrorEventListener(Configuration config) {
            super(config);
            throw new IllegalArgumentException("exception on constructor");
        }
    }
}

