/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyListener;
import org.apache.hadoop.hive.metastore.DummyPreListener;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreEventListenerWithOldConf {
    private Configuration conf;
    private static final String metaConfKey = "hive.metastore.partition.name.whitelist.pattern";
    private static final String metaConfVal = "";

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.event.listeners", DummyListener.class.getName());
        System.setProperty("hive.metastore.pre.event.listeners", DummyPreListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN, (String)metaConfVal);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        DummyListener.notifyList.clear();
        DummyPreListener.notifyList.clear();
    }

    @Test
    public void testMetaConfNotifyListenersClosingClient() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)metaConfVal);
        Assert.assertEquals((Object)event.getNewValue(), (Object)"[test pattern modified]");
        closingClient.close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)"[test pattern modified]");
        Assert.assertEquals((Object)event.getNewValue(), (Object)metaConfVal);
    }

    @Test
    public void testMetaConfNotifyListenersNonClosingClient() throws Exception {
        HiveMetaStoreClient nonClosingClient = new HiveMetaStoreClient(this.conf, null);
        nonClosingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)metaConfVal);
        Assert.assertEquals((Object)event.getNewValue(), (Object)"[test pattern modified]");
        nonClosingClient.getTTransport().close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)"[test pattern modified]");
        Assert.assertEquals((Object)event.getNewValue(), (Object)metaConfVal);
    }

    @Test
    public void testMetaConfDuplicateNotification() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, metaConfVal);
        int beforeCloseNotificationEventCounts = DummyListener.notifyList.size();
        closingClient.close();
        Thread.sleep(2000L);
        int afterCloseNotificationEventCounts = DummyListener.notifyList.size();
        Assert.assertEquals((long)beforeCloseNotificationEventCounts, (long)afterCloseNotificationEventCounts);
    }

    @Test
    public void testMetaConfSameHandler() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        int beforeCloseNotificationEventCounts = DummyListener.notifyList.size();
        IHMSHandler beforeHandler = event.getIHMSHandler();
        closingClient.close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        int afterCloseNotificationEventCounts = DummyListener.notifyList.size();
        IHMSHandler afterHandler = event.getIHMSHandler();
        Assert.assertNotSame((Object)beforeCloseNotificationEventCounts, (Object)afterCloseNotificationEventCounts);
        Assert.assertEquals((Object)beforeHandler, (Object)afterHandler);
    }
}

