/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyListener;
import org.apache.hadoop.hive.metastore.DummyPreListener;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.events.PreLoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreEventListener {
    private Configuration conf;
    private HiveMetaStoreClient msc;
    private static final String dbName = "hive2038";
    private static final String tblName = "tmptbl";
    private static final String renamed = "tmptbl2";
    private static final String metaConfKey = "metastore.partition.name.whitelist.pattern";
    private static final String metaConfVal = "";

    @Before
    public void setUp() throws Exception {
        System.setProperty("hive.metastore.event.listeners", DummyListener.class.getName());
        System.setProperty("hive.metastore.pre.event.listeners", DummyPreListener.class.getName());
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN, (String)metaConfVal);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), this.conf);
        HiveMetaStoreClient.setProcessorIdentifier((String)"test@TestMetaStoreEventListener");
        HiveMetaStoreClient.setProcessorCapabilities((String[])new String[]{"HIVEFULLACIDREAD", "EXTWRITE", "EXTREAD", "HIVEBUCKET2"});
        this.msc = new HiveMetaStoreClient(this.conf);
        this.msc.dropDatabase(dbName, true, true, true);
        DummyListener.notifyList.clear();
        DummyPreListener.notifyList.clear();
    }

    private void validateCreateDb(Database expectedDb, Database actualDb) {
        Assert.assertEquals((Object)expectedDb.getName(), (Object)actualDb.getName());
        Assert.assertEquals((Object)expectedDb.getLocationUri(), (Object)actualDb.getLocationUri());
    }

    private void validateTable(Table expectedTable, Table actualTable) {
        Assert.assertEquals((Object)expectedTable.getTableName(), (Object)actualTable.getTableName());
        Assert.assertEquals((Object)expectedTable.getDbName(), (Object)actualTable.getDbName());
        Assert.assertEquals((Object)expectedTable.getSd().getLocation(), (Object)actualTable.getSd().getLocation());
    }

    private void validateCreateTable(Table expectedTable, Table actualTable) {
        this.validateTable(expectedTable, actualTable);
    }

    private void validateAddPartition(Partition expectedPartition, Partition actualPartition) {
        Assert.assertEquals((Object)expectedPartition, (Object)actualPartition);
    }

    private void validateTableInAddPartition(Table expectedTable, Table actualTable) {
        actualTable.setAccessType(expectedTable.getAccessType());
        Assert.assertEquals((Object)expectedTable, (Object)actualTable);
    }

    private void validatePartition(Partition expectedPartition, Partition actualPartition) {
        Assert.assertEquals((Object)expectedPartition.getValues(), (Object)actualPartition.getValues());
        Assert.assertEquals((Object)expectedPartition.getDbName(), (Object)actualPartition.getDbName());
        Assert.assertEquals((Object)expectedPartition.getTableName(), (Object)actualPartition.getTableName());
    }

    private void validateAlterPartition(Partition expectedOldPartition, Partition expectedNewPartition, String actualOldPartitionDbName, String actualOldPartitionTblName, List<String> actualOldPartitionValues, Partition actualNewPartition) {
        Assert.assertEquals((Object)expectedOldPartition.getValues(), actualOldPartitionValues);
        Assert.assertEquals((Object)expectedOldPartition.getDbName(), (Object)actualOldPartitionDbName);
        Assert.assertEquals((Object)expectedOldPartition.getTableName(), (Object)actualOldPartitionTblName);
        this.validatePartition(expectedNewPartition, actualNewPartition);
    }

    private void validateAlterTable(Table expectedOldTable, Table expectedNewTable, Table actualOldTable, Table actualNewTable) {
        this.validateTable(expectedOldTable, actualOldTable);
        this.validateTable(expectedNewTable, actualNewTable);
    }

    private void validateAlterTableColumns(Table expectedOldTable, Table expectedNewTable, Table actualOldTable, Table actualNewTable) {
        this.validateAlterTable(expectedOldTable, expectedNewTable, actualOldTable, actualNewTable);
        Assert.assertEquals((Object)expectedOldTable.getSd().getCols(), (Object)actualOldTable.getSd().getCols());
        Assert.assertEquals((Object)expectedNewTable.getSd().getCols(), (Object)actualNewTable.getSd().getCols());
    }

    private void validateLoadPartitionDone(String expectedTableName, Map<String, String> expectedPartitionName, String actualTableName, Map<String, String> actualPartitionName) {
        Assert.assertEquals(expectedPartitionName, actualPartitionName);
        Assert.assertEquals((Object)expectedTableName, (Object)actualTableName);
    }

    private void validateDropPartition(Iterator<Partition> expectedPartitions, Iterator<Partition> actualPartitions) {
        while (expectedPartitions.hasNext()) {
            Assert.assertTrue((boolean)actualPartitions.hasNext());
            this.validatePartition(expectedPartitions.next(), actualPartitions.next());
        }
        Assert.assertFalse((boolean)actualPartitions.hasNext());
    }

    private void validateTableInDropPartition(Table expectedTable, Table actualTable) {
        this.validateTable(expectedTable, actualTable);
    }

    private void validateDropTable(Table expectedTable, Table actualTable) {
        this.validateTable(expectedTable, actualTable);
    }

    private void validateDropDb(Database expectedDb, Database actualDb) {
        Assert.assertEquals((Object)expectedDb, (Object)actualDb);
    }

    @Test
    public void testListener() throws Exception {
        int listSize = 0;
        List<ListenerEvent> notifyList = DummyListener.notifyList;
        List<PreEventContext> preNotifyList = DummyPreListener.notifyList;
        Assert.assertEquals((long)notifyList.size(), (long)listSize);
        Assert.assertEquals((long)preNotifyList.size(), (long)listSize);
        new DatabaseBuilder().setName(dbName).create((IMetaStoreClient)this.msc, this.conf);
        PreCreateDatabaseEvent preDbEvent = (PreCreateDatabaseEvent)preNotifyList.get(preNotifyList.size() - 1);
        Database db = this.msc.getDatabase(dbName);
        Assert.assertEquals((long)(++listSize), (long)notifyList.size());
        Assert.assertEquals((long)(listSize + 1), (long)preNotifyList.size());
        this.validateCreateDb(db, preDbEvent.getDatabase());
        CreateDatabaseEvent dbEvent = (CreateDatabaseEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)dbEvent.getStatus());
        this.validateCreateDb(db, dbEvent.getDatabase());
        Table table = ((TableBuilder)new TableBuilder().inDb(db).setTableName(tblName).addCol("a", "string")).addPartCol("b", "string").create((IMetaStoreClient)this.msc, this.conf);
        PreCreateTableEvent preTblEvent = (PreCreateTableEvent)preNotifyList.get(preNotifyList.size() - 1);
        Table tbl = this.msc.getTable(dbName, tblName);
        this.validateCreateTable(tbl, preTblEvent.getTable());
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        CreateTableEvent tblEvent = (CreateTableEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)tblEvent.getStatus());
        this.validateCreateTable(tbl, tblEvent.getTable());
        new PartitionBuilder().inTable(table).addValue("2011").addToTable((IMetaStoreClient)this.msc, this.conf);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreAddPartitionEvent prePartEvent = (PreAddPartitionEvent)preNotifyList.get(preNotifyList.size() - 1);
        AddPartitionEvent partEvent = (AddPartitionEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)partEvent.getStatus());
        Partition part = this.msc.getPartition(dbName, tblName, "b=2011");
        Partition partAdded = (Partition)partEvent.getPartitionIterator().next();
        partAdded.setWriteId(part.getWriteId());
        this.validateAddPartition(part, partAdded);
        this.validateTableInAddPartition(tbl, partEvent.getTable());
        this.validateAddPartition(part, (Partition)prePartEvent.getPartitions().get(0));
        int currentTime = (int)System.currentTimeMillis();
        HiveMetaStoreClient hmsClient = new HiveMetaStoreClient(this.conf);
        table = hmsClient.getTable(dbName, tblName);
        Partition partition1 = new Partition(Arrays.asList("20110101"), dbName, tblName, currentTime, currentTime, table.getSd(), table.getParameters());
        Partition partition2 = new Partition(Arrays.asList("20110102"), dbName, tblName, currentTime, currentTime, table.getSd(), table.getParameters());
        Partition partition3 = new Partition(Arrays.asList("20110103"), dbName, tblName, currentTime, currentTime, table.getSd(), table.getParameters());
        hmsClient.add_partitions(Arrays.asList(partition1, partition2, partition3));
        AddPartitionEvent multiplePartitionEvent = (AddPartitionEvent)notifyList.get(++listSize - 1);
        this.validateTableInAddPartition(table, multiplePartitionEvent.getTable());
        ArrayList multiParts = Lists.newArrayList((Iterator)multiplePartitionEvent.getPartitionIterator());
        Assert.assertEquals((String)"Unexpected number of partitions in event!", (long)3L, (long)multiParts.size());
        Assert.assertEquals((String)"Unexpected partition value.", (Object)partition1.getValues(), (Object)((Partition)multiParts.get(0)).getValues());
        Assert.assertEquals((String)"Unexpected partition value.", (Object)partition2.getValues(), (Object)((Partition)multiParts.get(1)).getValues());
        Assert.assertEquals((String)"Unexpected partition value.", (Object)partition3.getValues(), (Object)((Partition)multiParts.get(2)).getValues());
        part.setLastAccessTime((int)(System.currentTimeMillis() / 1000L));
        this.msc.alter_partition(dbName, tblName, part);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreAlterPartitionEvent preAlterPartEvent = (PreAlterPartitionEvent)preNotifyList.get(preNotifyList.size() - 1);
        Partition origP = this.msc.getPartition(dbName, tblName, "b=2011");
        AlterPartitionEvent alterPartEvent = (AlterPartitionEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)alterPartEvent.getStatus());
        this.validateAlterPartition(origP, origP, alterPartEvent.getOldPartition().getDbName(), alterPartEvent.getOldPartition().getTableName(), alterPartEvent.getOldPartition().getValues(), alterPartEvent.getNewPartition());
        this.validateAlterPartition(origP, origP, preAlterPartEvent.getDbName(), preAlterPartEvent.getTableName(), preAlterPartEvent.getNewPartition().getValues(), preAlterPartEvent.getNewPartition());
        ArrayList<String> part_vals = new ArrayList<String>();
        part_vals.add("c=2012");
        int preEventListSize = preNotifyList.size() + 1;
        Partition newPart = this.msc.appendPartition(dbName, tblName, part_vals);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        Assert.assertEquals((long)preNotifyList.size(), (long)preEventListSize);
        AddPartitionEvent appendPartEvent = (AddPartitionEvent)notifyList.get(listSize - 1);
        Partition partAppended = (Partition)appendPartEvent.getPartitionIterator().next();
        this.validateAddPartition(newPart, partAppended);
        PreAddPartitionEvent preAppendPartEvent = (PreAddPartitionEvent)preNotifyList.get(preNotifyList.size() - 1);
        this.validateAddPartition(newPart, (Partition)preAppendPartEvent.getPartitions().get(0));
        Table renamedTable = new Table(table);
        renamedTable.setTableName(renamed);
        this.msc.alter_table(dbName, tblName, renamedTable);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreAlterTableEvent preAlterTableE = (PreAlterTableEvent)preNotifyList.get(preNotifyList.size() - 2);
        renamedTable = this.msc.getTable(dbName, renamed);
        AlterTableEvent alterTableE = (AlterTableEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)alterTableE.getStatus());
        this.validateAlterTable(tbl, renamedTable, alterTableE.getOldTable(), alterTableE.getNewTable());
        this.validateAlterTable(tbl, renamedTable, preAlterTableE.getOldTable(), preAlterTableE.getNewTable());
        table = new Table(renamedTable);
        table.setTableName(tblName);
        this.msc.alter_table(dbName, renamed, table);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        table = this.msc.getTable(dbName, tblName);
        table.getSd().addToCols(new FieldSchema("c", "int", metaConfVal));
        this.msc.alter_table(dbName, tblName, table);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        preAlterTableE = (PreAlterTableEvent)preNotifyList.get(preNotifyList.size() - 1);
        Table altTable = this.msc.getTable(dbName, tblName);
        alterTableE = (AlterTableEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)alterTableE.getStatus());
        this.validateAlterTableColumns(tbl, altTable, alterTableE.getOldTable(), alterTableE.getNewTable());
        this.validateAlterTableColumns(tbl, altTable, preAlterTableE.getOldTable(), preAlterTableE.getNewTable());
        HashMap<String, String> kvs = new HashMap<String, String>(1);
        kvs.put("b", "2011");
        this.msc.markPartitionForEvent(dbName, tblName, kvs, PartitionEventType.LOAD_DONE);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        LoadPartitionDoneEvent partMarkEvent = (LoadPartitionDoneEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)partMarkEvent.getStatus());
        this.validateLoadPartitionDone(tblName, kvs, partMarkEvent.getTable().getTableName(), partMarkEvent.getPartitionName());
        PreLoadPartitionDoneEvent prePartMarkEvent = (PreLoadPartitionDoneEvent)preNotifyList.get(preNotifyList.size() - 1);
        this.validateLoadPartitionDone(tblName, kvs, prePartMarkEvent.getTableName(), prePartMarkEvent.getPartitionName());
        this.msc.dropPartition(dbName, tblName, Collections.singletonList("2011"));
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreDropPartitionEvent preDropPart = (PreDropPartitionEvent)preNotifyList.get(preNotifyList.size() - 1);
        DropPartitionEvent dropPart = (DropPartitionEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)dropPart.getStatus());
        this.validateDropPartition(Collections.singletonList(part).iterator(), dropPart.getPartitionIterator());
        this.validateTableInDropPartition(tbl, dropPart.getTable());
        this.validateDropPartition(Collections.singletonList(part).iterator(), preDropPart.getPartitionIterator());
        this.validateTableInDropPartition(tbl, preDropPart.getTable());
        this.msc.dropTable(dbName, tblName);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreDropTableEvent preDropTbl = (PreDropTableEvent)preNotifyList.get(preNotifyList.size() - 1);
        DropTableEvent dropTbl = (DropTableEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)dropTbl.getStatus());
        this.validateDropTable(tbl, dropTbl.getTable());
        this.validateDropTable(tbl, preDropTbl.getTable());
        this.msc.dropDatabase(dbName);
        Assert.assertEquals((long)notifyList.size(), (long)(++listSize));
        PreDropDatabaseEvent preDropDB = (PreDropDatabaseEvent)preNotifyList.get(preNotifyList.size() - 1);
        DropDatabaseEvent dropDB = (DropDatabaseEvent)notifyList.get(listSize - 1);
        Assert.assertTrue((boolean)dropDB.getStatus());
        this.validateDropDb(db, dropDB.getDatabase());
        this.validateDropDb(db, preDropDB.getDatabase());
        this.msc.setMetaConf("metastore.try.direct.sql", "false");
        ConfigChangeEvent event = (ConfigChangeEvent)notifyList.get(notifyList.size() - 1);
        Assert.assertEquals((Object)"metastore.try.direct.sql", (Object)event.getKey());
        Assert.assertEquals((Object)"true", (Object)event.getOldValue());
        Assert.assertEquals((Object)"false", (Object)event.getNewValue());
    }

    @Test
    public void testMetaConfNotifyListenersClosingClient() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)metaConfVal);
        Assert.assertEquals((Object)event.getNewValue(), (Object)"[test pattern modified]");
        closingClient.close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)"[test pattern modified]");
        Assert.assertEquals((Object)event.getNewValue(), (Object)metaConfVal);
    }

    @Test
    public void testMetaConfNotifyListenersNonClosingClient() throws Exception {
        HiveMetaStoreClient nonClosingClient = new HiveMetaStoreClient(this.conf, null);
        nonClosingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)metaConfVal);
        Assert.assertEquals((Object)event.getNewValue(), (Object)"[test pattern modified]");
        nonClosingClient.getTTransport().close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        Assert.assertEquals((Object)event.getOldValue(), (Object)"[test pattern modified]");
        Assert.assertEquals((Object)event.getNewValue(), (Object)metaConfVal);
    }

    @Test
    public void testMetaConfDuplicateNotification() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, metaConfVal);
        int beforeCloseNotificationEventCounts = DummyListener.notifyList.size();
        closingClient.close();
        Thread.sleep(2000L);
        int afterCloseNotificationEventCounts = DummyListener.notifyList.size();
        Assert.assertEquals((long)beforeCloseNotificationEventCounts, (long)afterCloseNotificationEventCounts);
    }

    @Test
    public void testMetaConfSameHandler() throws Exception {
        HiveMetaStoreClient closingClient = new HiveMetaStoreClient(this.conf, null);
        closingClient.setMetaConf(metaConfKey, "[test pattern modified]");
        ConfigChangeEvent event = (ConfigChangeEvent)DummyListener.getLastEvent();
        int beforeCloseNotificationEventCounts = DummyListener.notifyList.size();
        IHMSHandler beforeHandler = event.getIHMSHandler();
        closingClient.close();
        Thread.sleep(2000L);
        event = (ConfigChangeEvent)DummyListener.getLastEvent();
        int afterCloseNotificationEventCounts = DummyListener.notifyList.size();
        IHMSHandler afterHandler = event.getIHMSHandler();
        Assert.assertNotSame((Object)beforeCloseNotificationEventCounts, (Object)afterCloseNotificationEventCounts);
        Assert.assertEquals((Object)beforeHandler, (Object)afterHandler);
    }
}

