/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DummyJdoConnectionUrlHook;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreConnectionUrlHook {
    @Test
    public void testUrlHook() throws Exception {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_HOOK, (String)DummyJdoConnectionUrlHook.class.getName());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)"BAD_URL");
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RAW_STORE_IMPL, (String)DummyRawStoreForJdoConnection.class.getName());
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        HMSHandler hms = new HMSHandler("test_metastore_connection_url_hook_hms_handler", conf);
        hms.init();
    }

    public static class DummyRawStoreForJdoConnection
    extends ObjectStore {
        public Configuration getConf() {
            return null;
        }

        public void setConf(Configuration arg0) {
            String expected = "CORRECT_URL";
            String actual = MetastoreConf.getVar((Configuration)arg0, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
            Assert.assertEquals((String)("The expected URL used by JDO to connect to the metastore: " + expected + " did not match the actual value when the Raw Store was initialized: " + actual), (Object)expected, (Object)actual);
        }

        public void verifySchema() throws MetaException {
        }

        public void createCatalog(Catalog cat) throws MetaException {
        }

        public Catalog getCatalog(String catalogName) throws NoSuchObjectException, MetaException {
            return null;
        }

        public void createDatabase(Database db) throws InvalidObjectException, MetaException {
        }

        public Database getDatabase(String catName, String name) throws NoSuchObjectException {
            return null;
        }

        public Role getRole(String roleName) throws NoSuchObjectException {
            return null;
        }

        public boolean addRole(String roleName, String ownerName) throws InvalidObjectException, MetaException, NoSuchObjectException {
            return false;
        }

        public boolean grantPrivileges(PrivilegeBag privileges) throws InvalidObjectException, MetaException, NoSuchObjectException {
            return false;
        }
    }
}

