/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetastoreCli;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetastoreCli {
    private static final String[] CLI_ARGUMENTS = new String[]{"9999"};

    @Test
    public void testDefaultCliPortValue() {
        Configuration configuration = MetastoreConf.newMetastoreConf();
        HiveMetastoreCli cli = new HiveMetastoreCli(configuration);
        assert (cli.getPort() == MetastoreConf.getIntVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_PORT));
    }

    @Test
    public void testOverriddenCliPortValue() {
        Configuration configuration = MetastoreConf.newMetastoreConf();
        HiveMetastoreCli cli = new HiveMetastoreCli(configuration);
        cli.parse(CLI_ARGUMENTS);
        assert (cli.getPort() == 9999);
    }

    @Test
    public void testOverriddenMetastoreServerPortValue() {
        Configuration configuration = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_PORT, (long)12345L);
        HiveMetastoreCli cli = new HiveMetastoreCli(configuration);
        assert (cli.getPort() == 12345);
    }

    @Test
    public void testCliOverridesConfiguration() {
        Configuration configuration = MetastoreConf.newMetastoreConf();
        MetastoreConf.setLongVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_PORT, (long)12345L);
        HiveMetastoreCli cli = new HiveMetastoreCli(configuration);
        cli.parse(CLI_ARGUMENTS);
        assert (cli.getPort() == 9999);
    }
}

