/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestHMSFetchPartitionsWithoutCols {
    private Configuration conf;
    private HiveMetaStoreClient msc;
    private final Database db = new Database();
    private Table table;
    private static final String dbName = "hmsPartitionTestDb";
    private static final String tblName = "partitionTestTable";

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_CLIENT_FIELD_SCHEMA_FOR_PARTITIONS, (boolean)true);
        this.msc = new HiveMetaStoreClient(this.conf);
        this.msc.dropDatabase(dbName, true, true, true);
        this.db.setName(dbName);
        this.db.setCatalogName("hive");
        this.table = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tblName).addTableParam("a", "string").addPartCol("year", "string").addCol("a", "string")).addCol("b", "string")).build(this.conf);
        this.msc.createDatabase(this.db);
        this.msc.createTable(this.table);
        this.table = this.msc.getTable(dbName, tblName);
    }

    @Test
    public void testPartitionsWithoutCols() throws Exception {
        Partition[] addParts = new Partition[2];
        for (int i = 0; i < addParts.length; ++i) {
            addParts[i] = new PartitionBuilder().inTable(this.table).addValue("202" + i).build(this.conf);
        }
        List add_partitions_result = this.msc.add_partitions(Arrays.asList(addParts), true, true);
        this.checkColumnSchemaForPartitions(add_partitions_result, false);
        ArrayList<String> partVals = new ArrayList<String>();
        partVals.add("2022");
        this.msc.appendPartition(dbName, tblName, partVals);
        List parts = this.msc.listPartitions(dbName, tblName, (short)-1);
        this.checkColumnSchemaForPartitions(parts, true);
        List getParts = this.msc.listPartitions(dbName, tblName, partVals, (short)-1);
        this.checkColumnSchemaForPartitions(getParts, true);
    }

    private void checkColumnSchemaForPartitions(List<Partition> partitionList, boolean isEmpty) {
        Assert.assertTrue((!partitionList.isEmpty() ? 1 : 0) != 0);
        if (isEmpty) {
            for (Partition part : partitionList) {
                Assert.assertTrue((boolean)part.getSd().getCols().isEmpty());
            }
        } else {
            for (Partition part : partitionList) {
                Assert.assertTrue((!part.getSd().getCols().isEmpty() ? 1 : 0) != 0);
            }
        }
    }
}

