/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.NonCatCallsWithCatalog;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.thrift.TException;
import org.junit.After;

public class TestCatalogNonDefaultSvr
extends NonCatCallsWithCatalog {
    private final String catName = "non_default_svr_catalog";
    private String catLocation;
    private IMetaStoreClient catalogCapableClient;

    @After
    public void dropCatalog() throws TException {
        MetaStoreTestUtils.dropCatalogCascade(this.catalogCapableClient, "non_default_svr_catalog");
        this.catalogCapableClient.close();
    }

    @Override
    protected IMetaStoreClient getClient() throws Exception {
        this.catalogCapableClient = new HiveMetaStoreClient(this.conf);
        this.catLocation = MetaStoreTestUtils.getTestWarehouseDir("non_default_svr_catalog");
        Catalog cat = new CatalogBuilder().setName("non_default_svr_catalog").setLocation(this.catLocation).build();
        this.catalogCapableClient.createCatalog(cat);
        this.catalogCapableClient.close();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CATALOG_DEFAULT, (String)"non_default_svr_catalog");
        return new HiveMetaStoreClient(this.conf);
    }

    @Override
    protected String expectedCatalog() {
        return "non_default_svr_catalog";
    }

    @Override
    protected String expectedBaseDir() throws MetaException {
        return this.catLocation;
    }

    @Override
    protected String expectedExtBaseDir() throws MetaException {
        return this.catLocation;
    }
}

