/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestAdminUser {
    @Test
    public void testCreateAdminNAddUser() throws MetaException, NoSuchObjectException {
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.USERS_IN_ADMIN_ROLE, (String)"adminuser");
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        HMSHandler hms = new HMSHandler("testcreateroot", conf);
        hms.init();
        RawStore rawStore = hms.getMS();
        Role adminRole = rawStore.getRole("admin");
        Assert.assertTrue((boolean)adminRole.getOwnerName().equals("admin"));
        Assert.assertEquals((Object)((HiveObjectPrivilege)rawStore.listPrincipalGlobalGrants("admin", PrincipalType.ROLE).get(0)).getGrantInfo().getPrivilege(), (Object)"All");
        Assert.assertEquals((Object)((Role)rawStore.listRoles("adminuser", PrincipalType.USER).get(0)).getRoleName(), (Object)"admin");
    }
}

