/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.histogram.kll.KllUtils;
import org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.thrift.TFieldIdEnum;
import org.junit.Assert;

public class StatisticsTestUtils {
    public static final String HIVE_ENGINE = "hive";

    private StatisticsTestUtils() {
        throw new AssertionError((Object)"Suppress default constructor for non instantiation");
    }

    public static MetaStoreServerUtils.ColStatsObjWithSourceInfo createStatsWithInfo(ColumnStatisticsData data, Table tbl, FieldSchema column, String partName) {
        ColumnStatisticsObj statObj = new ColumnStatisticsObj(column.getName(), column.getType(), data);
        return new MetaStoreServerUtils.ColStatsObjWithSourceInfo(statObj, tbl.getCatName(), tbl.getDbName(), column.getName(), partName);
    }

    public static ColumnStatistics createColumnStatistics(ColumnStatisticsData data, Table tbl, FieldSchema column, String partName) {
        ColumnStatisticsObj statObj = new ColumnStatisticsObj(column.getName(), column.getType(), data);
        ColumnStatistics colStats = new ColumnStatistics();
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc(true, tbl.getDbName(), tbl.getTableName());
        statsDesc.setPartName(partName);
        colStats.setStatsDesc(statsDesc);
        colStats.setStatsObj(Collections.singletonList(statObj));
        colStats.setEngine(HIVE_ENGINE);
        return colStats;
    }

    public static FMSketch createFMSketch(long ... values) {
        FMSketch fm = new FMSketch(1);
        for (long value : values) {
            fm.addToEstimator(value);
        }
        return fm;
    }

    public static FMSketch createFMSketch(String ... values) {
        FMSketch fm = new FMSketch(1);
        for (String value : values) {
            fm.addToEstimator(value);
        }
        return fm;
    }

    public static HyperLogLog createHll(long ... values) {
        HyperLogLog hll = HyperLogLog.builder().build();
        for (long value : values) {
            hll.addLong(value);
        }
        return hll;
    }

    public static HyperLogLog createHll(String ... values) {
        HyperLogLog hll = HyperLogLog.builder().build();
        for (String value : values) {
            hll.addBytes(value.getBytes());
        }
        return hll;
    }

    public static HyperLogLog createHll(double ... values) {
        HyperLogLog hll = HyperLogLog.builder().build();
        Arrays.stream(values).forEach(arg_0 -> ((HyperLogLog)hll).addDouble(arg_0));
        return hll;
    }

    public static KllFloatsSketch createKll(float ... values) {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        for (float value : values) {
            kll.update(value);
        }
        return kll;
    }

    public static KllFloatsSketch createKll(double ... values) {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        for (double value : values) {
            kll.update(Double.valueOf(value).floatValue());
        }
        return kll;
    }

    public static KllFloatsSketch createKll(long ... values) {
        KllFloatsSketch kll = KllFloatsSketch.newHeapInstance();
        for (long value : values) {
            kll.update((float)value);
        }
        return kll;
    }

    public static void assertEqualStatistics(ColumnStatisticsData expected, ColumnStatisticsData computed) {
        Class<DateColumnStatsData> dataClass;
        if (expected.getSetField() != computed.getSetField()) {
            throw new IllegalArgumentException("Expected data is of type " + expected.getSetField() + " while computed data is of type " + computed.getSetField());
        }
        switch ((ColumnStatisticsData._Fields)expected.getSetField()) {
            case DATE_STATS: {
                dataClass = DateColumnStatsData.class;
                break;
            }
            case LONG_STATS: {
                dataClass = LongColumnStatsData.class;
                break;
            }
            case DOUBLE_STATS: {
                dataClass = DoubleColumnStatsData.class;
                break;
            }
            case DECIMAL_STATS: {
                dataClass = DecimalColumnStatsData.class;
                break;
            }
            case TIMESTAMP_STATS: {
                dataClass = TimestampColumnStatsData.class;
                break;
            }
            default: {
                Assert.assertEquals((Object)expected, (Object)computed);
                return;
            }
        }
        StatisticsTestUtils.assertEqualStatistics(expected, computed, dataClass);
    }

    private static <X> void assertEqualStatistics(ColumnStatisticsData expected, ColumnStatisticsData computed, Class<X> clazz) {
        try {
            Object computedStats = computed.getFieldValue((TFieldIdEnum)((ColumnStatisticsData._Fields)computed.getSetField()));
            Object expectedStats = expected.getFieldValue((TFieldIdEnum)((ColumnStatisticsData._Fields)computed.getSetField()));
            boolean computedHasHistograms = (Boolean)clazz.getMethod("isSetHistogram", new Class[0]).invoke(computedStats, new Object[0]);
            boolean expectedHasHistograms = (Boolean)clazz.getMethod("isSetHistogram", new Class[0]).invoke(expectedStats, new Object[0]);
            if (computedHasHistograms && expectedHasHistograms) {
                byte[] expectedHistogram = (byte[])clazz.getMethod("getHistogram", new Class[0]).invoke(expectedStats, new Object[0]);
                byte[] computedHistogram = (byte[])clazz.getMethod("getHistogram", new Class[0]).invoke(computedStats, new Object[0]);
                Assert.assertEquals((Object)KllUtils.deserializeKll((byte[])expectedHistogram).toString(), (Object)KllUtils.deserializeKll((byte[])computedHistogram).toString());
                clazz.getMethod("setHistogram", byte[].class).invoke(expectedStats, new Object[]{computedHistogram});
                Assert.assertEquals((Object)expected, (Object)computed);
                clazz.getMethod("setHistogram", byte[].class).invoke(expectedStats, new Object[]{expectedHistogram});
            } else {
                Assert.assertEquals((Object)expected, (Object)computed);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Reflection error", e);
        }
    }
}

