/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Functions;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.junit.Assert;

public class InjectableBehaviourObjectStore
extends ObjectStore {
    private static com.google.common.base.Function<Table, Table> getTableModifier = Functions.identity();
    private static com.google.common.base.Function<Partition, Partition> getPartitionModifier = Functions.identity();
    private static com.google.common.base.Function<List<String>, List<String>> listPartitionNamesModifier = Functions.identity();
    private static com.google.common.base.Function<NotificationEventResponse, NotificationEventResponse> getNextNotificationModifier = Functions.identity();
    private static com.google.common.base.Function<CallerArguments, Boolean> callerVerifier = null;
    private static com.google.common.base.Function<NotificationEvent, Boolean> addNotificationEventModifier = null;
    private static com.google.common.base.Function<CallerArguments, Boolean> alterTableModifier = null;
    private static com.google.common.base.Function<CurrentNotificationEventId, CurrentNotificationEventId> getCurrNotiEventIdModifier = null;
    private static com.google.common.base.Function<List<Partition>, Boolean> alterPartitionsModifier = null;
    private static com.google.common.base.Function<List<Partition>, Boolean> addPartitionsModifier = null;
    private static com.google.common.base.Function<Table, Boolean> updatePartColStatsModifier = null;

    public static void setGetTableBehaviour(com.google.common.base.Function<Table, Table> modifier) {
        getTableModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetTableBehaviour() {
        InjectableBehaviourObjectStore.setGetTableBehaviour(null);
    }

    public static void setGetPartitionBehaviour(com.google.common.base.Function<Partition, Partition> modifier) {
        getPartitionModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetGetPartitionBehaviour() {
        InjectableBehaviourObjectStore.setGetPartitionBehaviour(null);
    }

    public static void setListPartitionNamesBehaviour(com.google.common.base.Function<List<String>, List<String>> modifier) {
        listPartitionNamesModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void resetListPartitionNamesBehaviour() {
        InjectableBehaviourObjectStore.setListPartitionNamesBehaviour(null);
    }

    public static void setGetNextNotificationBehaviour(com.google.common.base.Function<NotificationEventResponse, NotificationEventResponse> modifier) {
        getNextNotificationModifier = modifier == null ? Functions.identity() : modifier;
    }

    public static void setAddNotificationModifier(com.google.common.base.Function<NotificationEvent, Boolean> modifier) {
        addNotificationEventModifier = modifier;
    }

    public static void resetAddNotificationModifier() {
        InjectableBehaviourObjectStore.setAddNotificationModifier(null);
    }

    public static void resetGetNextNotificationBehaviour() {
        InjectableBehaviourObjectStore.setGetNextNotificationBehaviour(null);
    }

    public static void setCallerVerifier(com.google.common.base.Function<CallerArguments, Boolean> verifier) {
        callerVerifier = verifier;
    }

    public static void resetCallerVerifier() {
        InjectableBehaviourObjectStore.setCallerVerifier(null);
    }

    public static void setAlterTableModifier(com.google.common.base.Function<CallerArguments, Boolean> modifier) {
        alterTableModifier = modifier;
    }

    public static void resetAlterTableModifier() {
        InjectableBehaviourObjectStore.setAlterTableModifier(null);
    }

    public static void resetAddPartitionModifier() {
        InjectableBehaviourObjectStore.setAddPartitionsBehaviour(null);
    }

    public static void setAlterPartitionsBehaviour(com.google.common.base.Function<List<Partition>, Boolean> modifier) {
        alterPartitionsModifier = modifier;
    }

    public static void setAddPartitionsBehaviour(com.google.common.base.Function<List<Partition>, Boolean> modifier) {
        addPartitionsModifier = modifier;
    }

    public static void setUpdatePartColStatsBehaviour(com.google.common.base.Function<Table, Boolean> modifier) {
        updatePartColStatsModifier = modifier;
    }

    public Table getTable(String catName, String dbName, String tableName) throws MetaException {
        return (Table)getTableModifier.apply((Object)super.getTable(catName, dbName, tableName));
    }

    public Table getTable(String catName, String dbName, String tableName, String writeIdList) throws MetaException {
        return (Table)getTableModifier.apply((Object)super.getTable(catName, dbName, tableName, writeIdList));
    }

    public Partition getPartition(String catName, String dbName, String tableName, List<String> partVals) throws NoSuchObjectException, MetaException {
        return (Partition)getPartitionModifier.apply((Object)super.getPartition(catName, dbName, tableName, partVals));
    }

    public List<String> listPartitionNames(String catName, String dbName, String tableName, short max) throws MetaException {
        return (List)listPartitionNamesModifier.apply((Object)super.listPartitionNames(catName, dbName, tableName, max));
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest rqst) {
        return (NotificationEventResponse)getNextNotificationModifier.apply((Object)super.getNextNotification(rqst));
    }

    public Table alterTable(String catName, String dbname, String name, Table newTable, String queryValidWriteIds) throws InvalidObjectException, MetaException {
        if (alterTableModifier != null) {
            CallerArguments args = new CallerArguments(dbname);
            args.tblName = name;
            Boolean success = (Boolean)alterTableModifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid alterTable operation on Catalog : " + catName + " DB: " + dbname + " table: " + name);
            }
        }
        return super.alterTable(catName, dbname, name, newTable, queryValidWriteIds);
    }

    public void addNotificationEvent(NotificationEvent entry) throws MetaException {
        Boolean success;
        if (addNotificationEventModifier != null && (success = (Boolean)addNotificationEventModifier.apply((Object)entry)) != null && !success.booleanValue()) {
            throw new MetaException("InjectableBehaviourObjectStore: Invalid addNotificationEvent operation on DB: " + entry.getDbName() + " table: " + entry.getTableName() + " event : " + entry.getEventType());
        }
        super.addNotificationEvent(entry);
    }

    public void createTable(Table tbl) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(tbl.getDbName());
            args.tblName = tbl.getTableName();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Create Table operation on DB: " + args.dbName + " table: " + args.tblName);
            }
        }
        super.createTable(tbl);
    }

    public void createFunction(Function func) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(func.getDbName());
            args.funcName = func.getFunctionName();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Create Function operation on DB: " + args.dbName + " function: " + args.funcName);
            }
        }
        super.createFunction(func);
    }

    public List<SQLPrimaryKey> addPrimaryKeys(List<SQLPrimaryKey> pks) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(pks.get(0).getTable_db());
            args.constraintTblName = pks.get(0).getTable_name();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Add Primary Key operation on DB: " + args.dbName + " table: " + args.constraintTblName);
            }
        }
        return super.addPrimaryKeys(pks);
    }

    public List<SQLForeignKey> addForeignKeys(List<SQLForeignKey> fks) throws InvalidObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(fks.get(0).getFktable_db());
            args.constraintTblName = fks.get(0).getFktable_name();
            Boolean success = (Boolean)callerVerifier.apply((Object)args);
            if (success != null && !success.booleanValue()) {
                throw new MetaException("InjectableBehaviourObjectStore: Invalid Add Foreign Key operation on DB: " + args.dbName + " table: " + args.constraintTblName);
            }
        }
        return super.addForeignKeys(fks);
    }

    public boolean alterDatabase(String catalogName, String dbname, Database db) throws NoSuchObjectException, MetaException {
        if (callerVerifier != null) {
            CallerArguments args = new CallerArguments(dbname);
            callerVerifier.apply((Object)args);
        }
        return super.alterDatabase(catalogName, dbname, db);
    }

    public static void setGetCurrentNotificationEventIdBehaviour(com.google.common.base.Function<CurrentNotificationEventId, CurrentNotificationEventId> modifier) {
        getCurrNotiEventIdModifier = modifier;
    }

    public static void resetGetCurrentNotificationEventIdBehaviour() {
        InjectableBehaviourObjectStore.setGetCurrentNotificationEventIdBehaviour(null);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() {
        CurrentNotificationEventId id = super.getCurrentNotificationEventId();
        if (getCurrNotiEventIdModifier != null && (id = (CurrentNotificationEventId)getCurrNotiEventIdModifier.apply((Object)id)) == null) {
            throw new RuntimeException("InjectableBehaviourObjectStore: Invalid getCurrentNotificationEventId");
        }
        return id;
    }

    public List<Partition> alterPartitions(String catName, String dbname, String name, List<List<String>> part_vals, List<Partition> newParts, long writeId, String queryWriteIdList) throws InvalidObjectException, MetaException {
        Boolean success;
        if (alterPartitionsModifier != null && (success = (Boolean)alterPartitionsModifier.apply(newParts)) != null && !success.booleanValue()) {
            throw new MetaException("InjectableBehaviourObjectStore: Invalid alterPartitions operation on Catalog : " + catName + " DB: " + dbname + " table: " + name);
        }
        return super.alterPartitions(catName, dbname, name, part_vals, newParts, writeId, queryWriteIdList);
    }

    public boolean addPartitions(String catName, String dbName, String tblName, List<Partition> parts) throws InvalidObjectException, MetaException {
        Boolean success;
        if (addPartitionsModifier != null && (success = (Boolean)addPartitionsModifier.apply(parts)) != null && !success.booleanValue()) {
            throw new MetaException("InjectableBehaviourObjectStore: Invalid addPartitions operation on Catalog : " + catName + " DB: " + dbName + " table: " + tblName);
        }
        return super.addPartitions(catName, dbName, tblName, parts);
    }

    public Map<String, Map<String, String>> updatePartitionColumnStatisticsInBatch(Map<String, ColumnStatistics> partColStatsMap, Table tbl, List<TransactionalMetaStoreEventListener> listeners, String validWriteIds, long writeId) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        Boolean success;
        if (updatePartColStatsModifier != null && (success = (Boolean)updatePartColStatsModifier.apply((Object)tbl)) != null && !success.booleanValue()) {
            throw new MetaException("InjectableBehaviourObjectStore: Invalid updatePartitionColumnStatisticsInBatch  : operation on Catalog : " + tbl.getCatName() + " DB: " + tbl.getDbName() + " table: " + tbl.getTableName());
        }
        return super.updatePartitionColumnStatisticsInBatch(partColStatsMap, tbl, listeners, validWriteIds, writeId);
    }

    public class CallerArguments {
        public String dbName;
        public String tblName;
        public String funcName;
        public String constraintTblName;

        public CallerArguments(String dbName) {
            this.dbName = dbName;
        }
    }

    public static abstract class BehaviourInjection<T, F>
    implements com.google.common.base.Function<T, F> {
        protected boolean injectionPathCalled = false;
        protected boolean nonInjectedPathCalled = false;

        public void assertInjectionsPerformed(boolean expectedInjectionCalled, boolean expectedNonInjectedPathCalled) {
            Assert.assertEquals((Object)expectedInjectionCalled, (Object)this.injectionPathCalled);
            Assert.assertEquals((Object)expectedNonInjectedPathCalled, (Object)this.nonInjectedPathCalled);
        }
    }
}

