/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestStatsSetupConst {
    @Test
    public void testSetBasicStatsState_missesUpgrade() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("COLUMN_STATS_ACCURATE", "FALSE");
        StatsSetupConst.setBasicStatsState(params, (String)String.valueOf(true));
        Assert.assertEquals((Object)"{\"BASIC_STATS\":\"true\"}", params.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void setColumnStatsState_camelcase() {
        HashMap params = new HashMap();
        StatsSetupConst.setColumnStatsState(params, (List)Lists.newArrayList((Object[])new String[]{"Foo"}));
        String val1 = (String)params.get("COLUMN_STATS_ACCURATE");
        StatsSetupConst.setColumnStatsState(params, (List)Lists.newArrayList((Object[])new String[]{"Foo"}));
        String val2 = (String)params.get("COLUMN_STATS_ACCURATE");
        Assert.assertEquals((Object)val1, (Object)val2);
    }

    @Test
    public void testSetBasicStatsState_none() {
        HashMap params = new HashMap();
        StatsSetupConst.setBasicStatsState(params, (String)String.valueOf(true));
        Assert.assertEquals((Object)"{\"BASIC_STATS\":\"true\"}", params.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void testSetBasicStatsState_falseIsAbsent() {
        HashMap params = new HashMap();
        StatsSetupConst.setBasicStatsState(params, (String)String.valueOf(true));
        StatsSetupConst.setBasicStatsState(params, (String)String.valueOf(false));
        Assert.assertNull(params.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void testStatColumnEntriesCompat() {
        HashMap params0 = new HashMap();
        StatsSetupConst.setBasicStatsState(params0, (String)String.valueOf(true));
        StatsSetupConst.setColumnStatsState(params0, (List)Lists.newArrayList((Object[])new String[]{"Foo"}));
        Assert.assertEquals((Object)"{\"BASIC_STATS\":\"true\",\"COLUMN_STATS\":{\"foo\":\"true\"}}", params0.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void testColumnEntries_orderIndependence() {
        HashMap params0 = new HashMap();
        StatsSetupConst.setBasicStatsState(params0, (String)String.valueOf(true));
        StatsSetupConst.setColumnStatsState(params0, (List)Lists.newArrayList((Object[])new String[]{"Foo", "Bar"}));
        HashMap params1 = new HashMap();
        StatsSetupConst.setColumnStatsState(params1, (List)Lists.newArrayList((Object[])new String[]{"Bar", "Foo"}));
        StatsSetupConst.setBasicStatsState(params1, (String)String.valueOf(true));
        Assert.assertEquals(params0.get("COLUMN_STATS_ACCURATE"), params1.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void testColumnEntries_orderIndependence2() {
        HashMap params0 = new HashMap();
        StatsSetupConst.setBasicStatsState(params0, (String)String.valueOf(true));
        StatsSetupConst.setColumnStatsState(params0, (List)Lists.newArrayList((Object[])new String[]{"year"}));
        StatsSetupConst.setColumnStatsState(params0, (List)Lists.newArrayList((Object[])new String[]{"year", "month"}));
        HashMap params1 = new HashMap();
        StatsSetupConst.setColumnStatsState(params1, (List)Lists.newArrayList((Object[])new String[]{"month", "year"}));
        StatsSetupConst.setBasicStatsState(params1, (String)String.valueOf(true));
        System.out.println((String)params0.get("COLUMN_STATS_ACCURATE"));
        Assert.assertEquals(params0.get("COLUMN_STATS_ACCURATE"), params1.get("COLUMN_STATS_ACCURATE"));
    }

    @Test
    public void testColumnEntries_areKept_whenBasicIsAbsent() {
        HashMap params = new HashMap();
        StatsSetupConst.setBasicStatsState(params, (String)String.valueOf(false));
        StatsSetupConst.setColumnStatsState(params, (List)Lists.newArrayList((Object[])new String[]{"Foo"}));
        Assert.assertEquals((Object)"{\"COLUMN_STATS\":{\"foo\":\"true\"}}", params.get("COLUMN_STATS_ACCURATE"));
    }
}

