/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.retry;

import org.apache.hadoop.hive.metastore.txn.retry.RetryPropagation;

public class SqlRetryCallProperties {
    private String caller = null;
    private boolean retryOnDuplicateKey = false;
    private boolean lockInternally = false;
    private RetryPropagation retryPropagation = RetryPropagation.CREATE_OR_JOIN;
    private int retryCount;
    private int deadlockCount;

    public SqlRetryCallProperties withCallerId(String caller) {
        this.caller = caller;
        return this;
    }

    public SqlRetryCallProperties withRetryOnDuplicateKey(boolean retryOnDuplicateKey) {
        this.retryOnDuplicateKey = retryOnDuplicateKey;
        return this;
    }

    public SqlRetryCallProperties withLockInternally(boolean lockInternally) {
        this.lockInternally = lockInternally;
        return this;
    }

    public SqlRetryCallProperties withRetryPropagation(RetryPropagation retryPropagation) {
        this.retryPropagation = retryPropagation;
        return this;
    }

    SqlRetryCallProperties setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    SqlRetryCallProperties setDeadlockCount(int deadlockCount) {
        this.deadlockCount = deadlockCount;
        return this;
    }

    String getCaller() {
        return this.caller;
    }

    boolean isRetryOnDuplicateKey() {
        return this.retryOnDuplicateKey;
    }

    boolean isLockInternally() {
        return this.lockInternally;
    }

    public RetryPropagation getRetryPropagation() {
        return this.retryPropagation;
    }

    int getRetryCount() {
        return this.retryCount;
    }

    int getDeadlockCount() {
        return this.deadlockCount;
    }

    public String toString() {
        return "[Id:" + this.caller + ", retryOnDuplicateKey:" + this.retryOnDuplicateKey + ", retryPropagation:" + this.retryPropagation + ", lockInternally:" + this.lockInternally + ", retryLimit:" + this.retryCount + ", deadlockLimit:" + this.deadlockCount + "]";
    }
}

