/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.txn.MetaWrapperException;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.LockInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetLocksByLockId;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.LockTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CheckLockFunction
implements TransactionalFunction<LockResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckLockFunction.class);
    private static final String EXCL_CTAS_ERR_MSG = "Failed to initiate a concurrent CTAS operation with the same table name, lockInfo : %s";
    private static final String ZERO_WAIT_READ_ERR_MSG = "Unable to acquire read lock due to an existing exclusive lock {%s}";
    private final long extLockId;
    private final long txnId;
    private final boolean zeroWaitReadEnabled;
    private final boolean isExclusiveCTAS;

    public CheckLockFunction(long extLockId, long txnId, boolean zeroWaitReadEnabled, boolean isExclusiveCTAS) {
        this.extLockId = extLockId;
        this.txnId = txnId;
        this.zeroWaitReadEnabled = zeroWaitReadEnabled;
        this.isExclusiveCTAS = isExclusiveCTAS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LockResponse execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException, NoSuchLockException {
        LockResponse response = new LockResponse();
        boolean isPartOfDynamicPartitionInsert = true;
        List<LockInfo> locksBeingChecked = this.getLocksFromLockId(jdbcResource, this.extLockId);
        response.setLockid(this.extLockId);
        ArrayList<LockInfo> writeSet = new ArrayList<LockInfo>();
        for (LockInfo info : locksBeingChecked) {
            if (isPartOfDynamicPartitionInsert || info.getType() != LockType.SHARED_WRITE) continue;
            writeSet.add(info);
        }
        if (!writeSet.isEmpty()) {
            void var9_12;
            if (((LockInfo)writeSet.get(0)).getTxnId() == 0L) {
                throw new IllegalStateException("Found Write lock for " + JavaUtils.lockIdToString((long)this.extLockId) + " but no txnid");
            }
            Object[] args = new Object[writeSet.size() * 4 + 1];
            int index = 0;
            args[index++] = ((LockInfo)writeSet.get(0)).getTxnId();
            StringBuilder sb = new StringBuilder(" \"WS_DATABASE\", \"WS_TABLE\", \"WS_PARTITION\", \"WS_TXNID\", \"WS_COMMIT_ID\" FROM \"WRITE_SET\" WHERE WS_COMMIT_ID >= ? AND (");
            boolean bl = false;
            while (var9_12 < writeSet.size()) {
                sb.append("(\"WS_DATABASE\" = ? AND \"WS_TABLE\" = ? AND (\"WS_PARTITION\" = ? OR ? IS NULL)");
                if (var9_12 < writeSet.size() - 1) {
                    sb.append(" OR ");
                }
                sb.append(")");
                LockInfo info = (LockInfo)writeSet.get((int)var9_12);
                args[index++] = info.getDb();
                args[index++] = info.getTable();
                args[index++] = info.getPartition();
                args[index++] = info.getPartition();
                ++var9_12;
            }
            WriteSetInfo writeSetInfo = (WriteSetInfo)jdbcResource.getJdbcTemplate().getJdbcTemplate().query(sb.toString(), args, rs -> {
                WriteSetInfo info = null;
                if (rs.next()) {
                    info = new WriteSetInfo();
                    info.database = rs.getString("WS_DATABASE");
                    info.table = rs.getString("WS_TABLE");
                    info.partition = rs.getString("WS_PARTITION");
                    info.txnId = rs.getLong("WS_TXNID");
                    info.commitId = rs.getLong("WS_COMMIT_ID");
                }
                return info;
            });
            if (writeSetInfo != null) {
                String resourceName = writeSetInfo.database + "/" + writeSetInfo.table;
                if (writeSetInfo.partition != null) {
                    resourceName = resourceName + "/" + writeSetInfo.partition;
                }
                String msg = "Aborting " + JavaUtils.txnIdToString((long)((LockInfo)writeSet.get(0)).getTxnId()) + " since a concurrent committed transaction [" + JavaUtils.txnIdToString((long)writeSetInfo.txnId) + "," + writeSetInfo.commitId + "] has already updated resource '" + resourceName + "'";
                LOG.info(msg);
                int count = new AbortTxnsFunction(Collections.singletonList(((LockInfo)writeSet.get(0)).getTxnId()), false, false, false, TxnErrorMsg.ABORT_CONCURRENT).execute(jdbcResource);
                if (count != 1) {
                    throw new IllegalStateException(msg + " FAILED!");
                }
                throw new TxnAbortedException(msg);
            }
        }
        String queryStr = " \"EX\".*, \"REQ\".\"HL_LOCK_INT_ID\" \"LOCK_INT_ID\", \"REQ\".\"HL_LOCK_TYPE\" \"LOCK_TYPE\" FROM ( SELECT \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" < " + this.extLockId + ") \"EX\" INNER JOIN ( SELECT \"HL_LOCK_INT_ID\", \"HL_TXNID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_TYPE\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = " + this.extLockId + ") \"REQ\" ON \"EX\".\"HL_DB\" = \"REQ\".\"HL_DB\" AND (\"EX\".\"HL_TABLE\" IS NULL OR \"REQ\".\"HL_TABLE\" IS NULL OR \"EX\".\"HL_TABLE\" = \"REQ\".\"HL_TABLE\" AND (\"EX\".\"HL_PARTITION\" IS NULL OR \"REQ\".\"HL_PARTITION\" IS NULL OR \"EX\".\"HL_PARTITION\" = \"REQ\".\"HL_PARTITION\")) WHERE (\"REQ\".\"HL_TXNID\" = 0 OR \"EX\".\"HL_TXNID\" != \"REQ\".\"HL_TXNID\") AND ";
        String[] whereStr = new String[]{" \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NOT NULL AND \"REQ\".\"HL_TABLE\" IS NULL)", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclusive() + " AND NOT (\"EX\".\"HL_TABLE\" IS NULL AND \"EX\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedRead() + " AND \"REQ\".\"HL_TABLE\" IS NOT NULL)", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.sharedWrite() + " AND \"EX\".\"HL_LOCK_TYPE\" IN (" + LockTypeUtil.exclWrite() + "," + LockTypeUtil.exclusive() + ")", " \"REQ\".\"HL_LOCK_TYPE\"=" + LockTypeUtil.exclWrite() + " AND \"EX\".\"HL_LOCK_TYPE\"!=" + LockTypeUtil.sharedRead()};
        ArrayList<CallSite> subQuery = new ArrayList<CallSite>();
        for (String subCond : whereStr) {
            subQuery.add((CallSite)((Object)("(" + jdbcResource.getSqlGenerator().addLimitClause(1, queryStr + subCond) + ")")));
        }
        String string = String.join((CharSequence)" UNION ALL ", subQuery);
        Boolean success = Objects.requireNonNull((Boolean)jdbcResource.getJdbcTemplate().query(string, (SqlParameterSource)new MapSqlParameterSource(), rs -> {
            if (rs.next()) {
                try {
                    LockInfo blockedBy = new LockInfo(rs);
                    long intLockId = rs.getLong("LOCK_INT_ID");
                    char lockChar = rs.getString("LOCK_TYPE").charAt(0);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failure to acquire lock({} intLockId:{} {}), blocked by ({})", new Object[]{JavaUtils.lockIdToString((long)this.extLockId), intLockId, JavaUtils.txnIdToString((long)this.txnId), blockedBy});
                    }
                    LockType lockType = LockTypeUtil.getLockTypeFromEncoding(lockChar).orElseThrow(() -> new MetaException("Unknown lock type: " + lockChar));
                    if ((this.zeroWaitReadEnabled && LockType.SHARED_READ == lockType || this.isExclusiveCTAS) && TxnUtils.isValidTxn(this.txnId)) {
                        jdbcResource.getJdbcTemplate().update("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = :extLockId", (SqlParameterSource)new MapSqlParameterSource().addValue("extLockId", (Object)this.extLockId));
                        response.setErrorMessage(String.format(this.isExclusiveCTAS ? EXCL_CTAS_ERR_MSG : ZERO_WAIT_READ_ERR_MSG, blockedBy));
                        response.setState(LockState.NOT_ACQUIRED);
                        return false;
                    }
                    int updCnt = jdbcResource.getJdbcTemplate().update("UPDATE \"HIVE_LOCKS\" SET \"HL_BLOCKEDBY_EXT_ID\" = :blockedByExtLockId, \"HL_BLOCKEDBY_INT_ID\" = :blockedByIntLockId  WHERE \"HL_LOCK_EXT_ID\" = :extLockId AND \"HL_LOCK_INT_ID\" = :intLockId", (SqlParameterSource)new MapSqlParameterSource().addValue("blockedByExtLockId", (Object)blockedBy.getExtLockId()).addValue("blockedByIntLockId", (Object)blockedBy.getIntLockId()).addValue("extLockId", (Object)this.extLockId).addValue("intLockId", (Object)intLockId));
                    if (updCnt != 1) {
                        LOG.error("Failure to update lock (extLockId={}, intLockId={}) with the blocking lock's IDs (extLockId={}, intLockId={})", new Object[]{this.extLockId, intLockId, blockedBy.getExtLockId(), blockedBy.getIntLockId()});
                        throw new RuntimeException("This should never happen: " + JavaUtils.txnIdToString((long)this.txnId) + " " + JavaUtils.lockIdToString((long)this.extLockId) + " " + intLockId);
                    }
                    response.setState(LockState.WAITING);
                    return false;
                }
                catch (MetaException e) {
                    throw new MetaWrapperException(e);
                }
            }
            return true;
        }), "This never should be null, it's just to suppress warnings");
        if (!success.booleanValue()) {
            return response;
        }
        this.acquire(jdbcResource, locksBeingChecked);
        LOG.debug("Successfully acquired locks: {}", locksBeingChecked);
        response.setState(LockState.ACQUIRED);
        return response;
    }

    private List<LockInfo> getLocksFromLockId(MultiDataSourceJdbcResource jdbcResource, long extLockId) throws MetaException {
        List<LockInfo> locks = jdbcResource.execute(new GetLocksByLockId(extLockId, -1, jdbcResource.getSqlGenerator()));
        if (locks.isEmpty()) {
            throw new MetaException("This should never happen!  We already checked the lock(" + JavaUtils.lockIdToString((long)extLockId) + ") existed but now we can't find it!");
        }
        LOG.debug("Found {} locks for extLockId={}. Locks: {}", new Object[]{locks.size(), extLockId, locks});
        return locks;
    }

    private void acquire(MultiDataSourceJdbcResource jdbcResource, List<LockInfo> locksBeingChecked) throws NoSuchLockException, MetaException {
        if (CollectionUtils.isEmpty(locksBeingChecked)) {
            return;
        }
        long txnId = locksBeingChecked.get(0).getTxnId();
        long extLockId = locksBeingChecked.get(0).getExtLockId();
        int rc = jdbcResource.getJdbcTemplate().update("UPDATE \"HIVE_LOCKS\" SET \"HL_LOCK_STATE\" = :state, \"HL_LAST_HEARTBEAT\" = " + (Serializable)(TxnUtils.isValidTxn(txnId) ? Integer.valueOf(0) : TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct())) + ",\"HL_ACQUIRED_AT\" = " + TxnUtils.getEpochFn(jdbcResource.getDatabaseProduct()) + ",\"HL_BLOCKEDBY_EXT_ID\"=NULL,\"HL_BLOCKEDBY_INT_ID\"=NULL WHERE \"HL_LOCK_EXT_ID\" = :extLockId", (SqlParameterSource)new MapSqlParameterSource().addValue("state", (Object)Character.toString('a'), 1).addValue("extLockId", (Object)extLockId));
        if (rc < locksBeingChecked.size()) {
            LOG.error("Failure to acquire all locks (acquired: {}, total needed: {}).", (Object)rc, (Object)locksBeingChecked.size());
            Set notFoundIds = locksBeingChecked.stream().map(lockInfo -> Long.toString(lockInfo.getIntLockId())).collect(Collectors.toSet());
            List foundIds = Objects.requireNonNull((List)jdbcResource.getJdbcTemplate().query("SELECT \"HL_LOCK_INT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = :extLockId", (SqlParameterSource)new MapSqlParameterSource().addValue("extLockId", (Object)extLockId), rs -> {
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString("HL_LOCK_INT_ID"));
                }
                return ids;
            }), "This never should be null, it's just to suppress warnings");
            foundIds.forEach(notFoundIds::remove);
            String errorMsg = String.format("No such lock(s): (%s: %s) %s", JavaUtils.lockIdToString((long)extLockId), String.join((CharSequence)", ", notFoundIds), JavaUtils.txnIdToString((long)txnId));
            throw new NoSuchLockException(errorMsg);
        }
    }

    static class WriteSetInfo {
        String database;
        String table;
        String partition;
        Long txnId;
        Long commitId;

        WriteSetInfo() {
        }
    }
}

