/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreUtils {
    private static final TimeZone DEFAULT = TimeZone.getDefault();
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    private final TimeZone timezone;
    private final Timestamp timestamp;
    private final String date;
    private final String timestampString;

    public TestMetaStoreUtils(String zoneId, LocalDateTime localDateTime) {
        this.timezone = TimeZone.getTimeZone(zoneId);
        this.timestamp = Timestamp.from(localDateTime.toInstant(ZoneOffset.UTC));
        this.timestampString = localDateTime.format(FORMATTER);
        this.date = this.timestamp.toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    @Parameterized.Parameters(name="zoneId={0}, localDateTime={1}")
    public static Collection<Object[]> generateZoneTimestampPairs() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        long minDate = LocalDate.of(0, 1, 1).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        long maxDate = LocalDate.of(9999, 12, 31).atStartOfDay().toEpochSecond(ZoneOffset.UTC);
        new Random(23L).longs(500L, minDate, maxDate).forEach(i -> {
            LocalDateTime datetime = LocalDateTime.ofEpochSecond(i, 0, ZoneOffset.UTC);
            for (String zone : ZoneId.SHORT_IDS.values()) {
                params.add(new Object[]{zone, datetime});
            }
        });
        params.add(new Object[]{"Asia/Kolkata", LocalDateTime.of(0, 1, 7, 22, 44, 36)});
        TestMetaStoreUtils.generateDaylightSavingTimestampPairs(params);
        return params;
    }

    public static void generateDaylightSavingTimestampPairs(List<Object[]> params) {
        params.add(new Object[]{"America/Anchorage", LocalDateTime.of(2024, 3, 10, 2, 1, 0)});
        params.add(new Object[]{"America/St_Johns", LocalDateTime.of(2024, 3, 10, 2, 1, 0)});
        params.add(new Object[]{"America/Chicago", LocalDateTime.of(2024, 3, 10, 2, 1, 0)});
        params.add(new Object[]{"America/Indiana/Indianapolis", LocalDateTime.of(2024, 3, 10, 2, 1, 0)});
        params.add(new Object[]{"America/Los_Angeles", LocalDateTime.of(2024, 3, 10, 2, 1, 0)});
        params.add(new Object[]{"Europe/Paris", LocalDateTime.of(2024, 3, 31, 2, 2, 2)});
        params.add(new Object[]{"Pacific/Auckland", LocalDateTime.of(2024, 9, 29, 2, 3, 4)});
        params.add(new Object[]{"Australia/Sydney", LocalDateTime.of(2024, 10, 6, 2, 4, 6)});
    }

    @Before
    public void setup() {
        TimeZone.setDefault(this.timezone);
    }

    @Test
    public void testDateToString() {
        Assert.assertEquals((Object)this.date, (Object)MetaStoreUtils.convertDateToString((Date)Date.valueOf(this.date)));
    }

    @Test
    public void testTimestampToString() {
        Assert.assertEquals((Object)this.timestampString, (Object)MetaStoreUtils.convertTimestampToString((Timestamp)this.timestamp));
    }

    @Test
    public void testStringToDate() {
        Assert.assertEquals((Object)Date.valueOf(this.date), (Object)MetaStoreUtils.convertStringToDate((String)this.date));
    }

    @Test
    public void testStringToTimestamp() {
        Assert.assertEquals((Object)this.timestamp, (Object)MetaStoreUtils.convertStringToTimestamp((String)this.timestampString));
    }

    @AfterClass
    public static void tearDown() {
        TimeZone.setDefault(DEFAULT);
    }
}

