/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.service.AcidTxnCleanerService;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAcidTxnCleanerService {
    private AcidTxnCleanerService underTest;
    private TxnStore txnHandler;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        this.underTest = new AcidTxnCleanerService();
        this.underTest.setConf(this.conf);
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        this.txnHandler.setOpenTxnTimeOutMillis(100L);
        TestTxnDbUtil.prepDb(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        TestTxnDbUtil.cleanDb(this.conf);
    }

    @Test
    public void cleansEmptyAbortedTxns() throws Exception {
        for (int i = 0; i < 5; ++i) {
            long txnid = this.openTxn();
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
        }
        Assert.assertEquals((long)6L, (long)this.getTxnCount());
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis() * 2L);
        this.underTest.run();
        Assert.assertEquals((long)1L, (long)this.getTxnCount());
        Assert.assertTrue((String)"The max txnId should be at least 5", (this.getMaxTxnId() >= 5L ? 1 : 0) != 0);
    }

    @Test
    public void doesNotCleanAbortedTxnsThatAreNonEmpty() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.openNonEmptyThenAbort();
        }
        Assert.assertEquals((long)6L, (long)this.getTxnCount());
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis() * 2L);
        this.underTest.run();
        Assert.assertEquals((long)5L, (long)this.getTxnCount());
        Assert.assertTrue((String)"The max txnId should be at least 5", (this.getMaxTxnId() >= 5L ? 1 : 0) != 0);
    }

    @Test
    public void cleansAllCommittedTxns() throws Exception {
        for (int i = 0; i < 5; ++i) {
            long txnid = this.openTxn();
            this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
        }
        Assert.assertEquals((long)6L, (long)this.getTxnCount());
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis() * 2L);
        this.underTest.run();
        Assert.assertEquals((long)1L, (long)this.getTxnCount());
        Assert.assertTrue((String)"The max txnId should be at least 5", (this.getMaxTxnId() >= 5L ? 1 : 0) != 0);
    }

    @Test
    public void cleansCommittedAndEmptyAbortedOnly() throws Exception {
        for (int i = 0; i < 5; ++i) {
            long txnid = this.openTxn();
            this.txnHandler.commitTxn(new CommitTxnRequest(txnid));
            txnid = this.openTxn();
            this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
            this.openNonEmptyThenAbort();
        }
        Assert.assertEquals((long)16L, (long)this.getTxnCount());
        Thread.sleep(this.txnHandler.getOpenTxnTimeOutMillis() * 2L);
        this.underTest.run();
        Assert.assertEquals((long)5L, (long)this.getTxnCount());
        Assert.assertTrue((String)"The max txnId should be at least 15", (this.getMaxTxnId() >= 15L ? 1 : 0) != 0);
    }

    @Test
    public void cleansEmptyAbortedBatchTxns() throws Exception {
        this.openNonEmptyThenAbort();
        this.txnHandler.setOpenTxnTimeOutMillis(30000L);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_MAX_OPEN_BATCH, (long)50050L);
        OpenTxnsResponse resp = this.txnHandler.openTxns(new OpenTxnRequest(50050, "user", "hostname"));
        this.txnHandler.setOpenTxnTimeOutMillis(1L);
        this.txnHandler.abortTxns(new AbortTxnsRequest(resp.getTxn_ids()));
        GetOpenTxnsResponse openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)50051L, (long)openTxns.getOpen_txnsSize());
        this.underTest.run();
        openTxns = this.txnHandler.getOpenTxns();
        Assert.assertEquals((long)2L, (long)openTxns.getOpen_txnsSize());
        Assert.assertTrue((String)"The max txnId should be at least", (this.getMaxTxnId() >= 50051L ? 1 : 0) != 0);
    }

    private void openNonEmptyThenAbort() throws MetaException, NoSuchTxnException, TxnAbortedException {
        long txnid = this.openTxn();
        LockRequest req = this.getLockRequest();
        req.setTxnid(txnid);
        this.txnHandler.lock(req);
        this.txnHandler.abortTxn(new AbortTxnRequest(txnid));
    }

    private long openTxn() throws MetaException {
        return (Long)this.txnHandler.openTxns(new OpenTxnRequest(1, "me", "localhost")).getTxn_ids().get(0);
    }

    private LockRequest getLockRequest() {
        LockComponent comp = new LockComponentBuilder().setDbName("default").setTableName("ceat").setOperationType(DataOperationType.UPDATE).setSharedWrite().build();
        return new LockRequest(Collections.singletonList(comp), "me", "localhost");
    }

    private long getTxnCount() throws Exception {
        return TestTxnDbUtil.countQueryAgent(this.conf, "SELECT COUNT(*) FROM \"TXNS\"");
    }

    private long getMaxTxnId() throws Exception {
        return TestTxnDbUtil.countQueryAgent(this.conf, "SELECT MAX(\"TXN_ID\") FROM \"TXNS\"");
    }
}

