/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mock;

@Category(value={MetastoreUnitTest.class})
public class TestMetastoreSchemaTool {
    private String scriptFile = System.getProperty("java.io.tmpdir") + File.separator + "someScript.sql";
    @Mock
    private Configuration conf;
    private MetastoreSchemaTool.CommandBuilder builder;
    private String password = "reallySimplePassword";

    @Before
    public void setup() throws IOException {
        this.conf = MetastoreConf.newMetastoreConf();
        File file = new File(this.scriptFile);
        if (!file.exists()) {
            file.createNewFile();
        }
        this.builder = new MetastoreSchemaTool.CommandBuilder(this.conf, null, null, "testUser", this.password, this.scriptFile).setVerbose(false);
    }

    @After
    public void globalAssert() throws IOException {
        new File(this.scriptFile).delete();
    }

    @Test
    public void shouldReturnStrippedPassword() throws IOException {
        Assert.assertFalse((boolean)this.builder.buildToLog().contains(this.password));
    }

    @Test
    public void shouldReturnActualPassword() throws IOException {
        String[] strings = this.builder.buildToRun();
        Assert.assertTrue((boolean)Arrays.asList(strings).contains(this.password));
    }
}

