/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskUpdateLocation;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={MetastoreUnitTest.class})
public class TestMetaToolTaskUpdateLocation {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private OutputStream os;

    @Before
    public void setup() {
        this.os = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.os));
        System.setErr(new PrintStream(this.os));
    }

    @Test
    public void testNoHost() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("HiveMetaTool:A valid host is required in both old-loc and new-loc");
        MetaToolTaskUpdateLocation t = new MetaToolTaskUpdateLocation();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-updateLocation", "hdfs://", "hdfs://"}));
        t.execute();
    }

    @Test
    public void testNoScheme() throws Exception {
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("HiveMetaTool:A valid scheme is required in both old-loc and new-loc");
        MetaToolTaskUpdateLocation t = new MetaToolTaskUpdateLocation();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-updateLocation", "//old.host", "//new.host"}));
        t.execute();
    }

    @Test
    public void testUpdateLocationNoUpdate() throws Exception {
        String oldUriString = "hdfs://old.host";
        String newUriString = "hdfs://new.host";
        String tablePropKey = "abc";
        String serdePropKey = "def";
        URI oldUri = new Path(oldUriString).toUri();
        URI newUri = new Path(newUriString).toUri();
        MetaToolObjectStore mockObjectStore = (MetaToolObjectStore)Mockito.mock(MetaToolObjectStore.class);
        Mockito.when((Object)mockObjectStore.updateMDatabaseURI((URI)ArgumentMatchers.eq((Object)oldUri), (URI)ArgumentMatchers.eq((Object)newUri), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        Mockito.when((Object)mockObjectStore.updateMStorageDescriptorTblURI((URI)ArgumentMatchers.eq((Object)oldUri), (URI)ArgumentMatchers.eq((Object)newUri), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        Mockito.when((Object)mockObjectStore.updateTblPropURI((URI)ArgumentMatchers.eq((Object)oldUri), (URI)ArgumentMatchers.eq((Object)newUri), (String)ArgumentMatchers.eq((Object)tablePropKey), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        Mockito.when((Object)mockObjectStore.updateMStorageDescriptorTblPropURI((URI)ArgumentMatchers.eq((Object)oldUri), (URI)ArgumentMatchers.eq((Object)newUri), (String)ArgumentMatchers.eq((Object)tablePropKey), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        Mockito.when((Object)mockObjectStore.updateSerdeURI((URI)ArgumentMatchers.eq((Object)oldUri), (URI)ArgumentMatchers.eq((Object)newUri), (String)ArgumentMatchers.eq((Object)serdePropKey), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        MetaToolTaskUpdateLocation t = new MetaToolTaskUpdateLocation();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-updateLocation", newUriString, oldUriString, "-dryRun", "-tablePropKey", tablePropKey, "-serdePropKey", serdePropKey}));
        t.setObjectStore(mockObjectStore);
        t.execute();
    }
}

