/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskExecuteJDOQLQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

@Category(value={MetastoreUnitTest.class})
public class TestMetaToolTaskExecuteJDOQLQuery {
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private OutputStream os;

    @Before
    public void setup() {
        this.os = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.os));
        System.setErr(new PrintStream(this.os));
    }

    @Test
    public void testSelectQuery() throws Exception {
        String selectQuery = "select a from b";
        String entry1 = "abc";
        String entry2 = "def";
        MetaToolObjectStore mockObjectStore = (MetaToolObjectStore)Mockito.mock(MetaToolObjectStore.class);
        ((MetaToolObjectStore)Mockito.doReturn(Arrays.asList(entry1, entry2)).when((Object)mockObjectStore)).executeJDOQLSelect((String)Mockito.eq((Object)selectQuery));
        MetaToolTaskExecuteJDOQLQuery t = new MetaToolTaskExecuteJDOQLQuery();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-executeJDOQL", selectQuery}));
        t.setObjectStore(mockObjectStore);
        t.execute();
        Assert.assertTrue((String)(this.os.toString() + " doesn't contain " + entry1), (boolean)this.os.toString().contains(entry1));
        Assert.assertTrue((String)(this.os.toString() + " doesn't contain " + entry2), (boolean)this.os.toString().contains(entry2));
    }

    @Test
    public void testUpdateQuerySuccessful() throws Exception {
        this.testUpdateQuery(1L, "Number of records updated: 1");
    }

    @Test
    public void testUpdateQueryNotSuccessful() throws Exception {
        this.testUpdateQuery(-1L, "Encountered error during executeJDOQL - commit of JDO transaction failed.");
    }

    private void testUpdateQuery(long ret, String expected) throws Exception {
        String updateQuery = "update a set b = 'c'";
        MetaToolObjectStore mockObjectStore = (MetaToolObjectStore)Mockito.mock(MetaToolObjectStore.class);
        Mockito.when((Object)mockObjectStore.executeJDOQLUpdate(updateQuery)).thenReturn((Object)ret);
        MetaToolTaskExecuteJDOQLQuery t = new MetaToolTaskExecuteJDOQLQuery();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-executeJDOQL", updateQuery}));
        t.setObjectStore(mockObjectStore);
        t.execute();
        Assert.assertTrue((String)(this.os.toString() + "doesn't contain " + expected), (boolean)this.os.toString().contains(expected));
    }

    @Test
    public void testIllegalQuery() throws Exception {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("HiveMetaTool:Unsupported statement type, only select and update supported");
        String illegalQuery = "abcde";
        MetaToolTaskExecuteJDOQLQuery t = new MetaToolTaskExecuteJDOQLQuery();
        t.setCommandLine(new HiveMetaToolCommandLine(new String[]{"-executeJDOQL", illegalQuery}));
        t.execute();
    }
}

