/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Derby;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummaryHandler;
import org.apache.hadoop.hive.metastore.metasummary.MetaSummarySchema;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.metasummary.SummaryMapBuilder;
import org.apache.hadoop.hive.metastore.tools.MetaToolObjectStore;
import org.apache.hadoop.hive.metastore.tools.metatool.MetaToolTaskMetadataSummary;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestMetaTookTaskMetadataSummary {
    private static final MetaToolTaskMetadataSummary TASK = new MetaToolTaskMetadataSummary();
    private static final String STORAGE_HANDLER = "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
    private static final String TABLE_TYPE_PARAM = "table_type";
    private static final String CURRENT_SNAPSHOT_TIMESTAMP_MS = "current-snapshot-timestamp-ms";
    private static Configuration conf;
    private static final String DB = "test_metasore_summary_1";
    private static final String TBL_PREFIX = "tbl";
    private static final DatabaseRule RULE;
    private final String[] inputParams;

    @BeforeClass
    public static void setup() throws Exception {
        RULE.before();
        RULE.install();
        MetaToolTaskMetadataSummary.addSummaryHandler((String)"iceberg", (String)FakeIcebergSummaryHandler.class.getName());
        conf = MetastoreConf.newMetastoreConf();
        conf.set("hive.metastore.client.capabilities", "HIVEFULLACIDWRITE,HIVEFULLACIDREAD,HIVEMANAGEDINSERTWRITE");
        TestMetaTookTaskMetadataSummary.setMetaStoreConfiguration(conf);
        int metastorePort = MetaStoreTestUtils.startMetaStoreWithRetry(conf, true, false);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("thrift://localhost:" + metastorePort));
        try (HiveMetaStoreClient msc = new HiveMetaStoreClient(conf);){
            String tableName1 = "tbl1";
            new DatabaseBuilder().setName(DB).create((IMetaStoreClient)msc, conf);
            ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB).setTableName("tbl1").addCol("a", "string")).addPartCol("dt", "string").addTableParam("EXTERNAL", "true").setType("EXTERNAL_TABLE").setSerdeLib("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe")).setInputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat")).setOutputFormat("org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat")).create((IMetaStoreClient)msc, conf);
            HashMap properties = new HashMap();
            EnvironmentContext context = new EnvironmentContext(properties);
            GetTableRequest request = new GetTableRequest(DB, tableName1);
            Table table1 = msc.getTable(request);
            for (String part : new String[]{"2024-09-29", "2024-10-29", "2024-11-29"}) {
                Partition partition = new PartitionBuilder().inTable(table1).addValue(part).addPartParam("totalSize", "1000").addPartParam("numFiles", "1").addPartParam("numRows", "10").addPartParam("rawDataSize", "1000").build(conf);
                msc.add_partition(partition, context);
            }
            ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB).setTableName("tbl2").addCol("a", "string")).addTableParam("totalSize", "2000").addTableParam("numFiles", "2").addTableParam("numRows", "20").addTableParam("rawDataSize", "2000").addTableParam("transactional_properties", "insert_only").addTableParam("transactional", "true").setType("MANAGED_TABLE").setSerdeLib("org.apache.hadoop.hive.ql.io.orc.OrcSerde")).setInputFormat("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat")).setOutputFormat("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat")).create((IMetaStoreClient)msc, conf);
            for (int i = 3; i < 6; ++i) {
                ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB).setTableName(TBL_PREFIX + i).addCol("a", "string")).addTableParam("EXTERNAL", "true").setType("EXTERNAL_TABLE").addTableParam("totalSize", i + "000").addTableParam("numFiles", "" + i).addTableParam("numRows", i + "0").addTableParam("rawDataSize", i + "000").addTableParam(TABLE_TYPE_PARAM, "ICEBERG").addTableParam(CURRENT_SNAPSHOT_TIMESTAMP_MS, "" + (System.currentTimeMillis() - (long)((i - 3) * 24) * 3600000L)).setSerdeLib(STORAGE_HANDLER)).setInputFormat("org.apache.iceberg.mr.hive.HiveIcebergInputFormat")).setOutputFormat("org.apache.iceberg.mr.hive.HiveIcebergOutputFormat")).create((IMetaStoreClient)msc, conf);
                FakeIcebergSummaryHandler.addTableSummary(new TableName(MetaStoreUtils.getDefaultCatalog((Configuration)conf), DB, TBL_PREFIX + i), i, i + 1, i + 2, i + 3);
            }
        }
        MetaToolObjectStore objectStore = new MetaToolObjectStore();
        objectStore.setConf(conf);
        TASK.setObjectStore(objectStore);
    }

    private static void setMetaStoreConfiguration(Configuration conf) {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)RULE.getJdbcUrl());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER, (String)RULE.getJdbcDriver());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME, (String)RULE.getHiveUser());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD, (String)RULE.getHivePassword());
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AUTO_CREATE_ALL, (boolean)false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getIteratorToTest() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{"-json", "output.json", null, null});
        params.add(new Object[]{"-json", "output.json", 2, null});
        params.add(new Object[]{"-json", "output.json", 3, null});
        params.add(new Object[]{"-json", "output.json", 3, 1});
        params.add(new Object[]{"-csv", "output.csv", null, null});
        params.add(new Object[]{"-console", null, null, null});
        return params;
    }

    public TestMetaTookTaskMetadataSummary(String format, String outputFile, Integer lastUpdated, Integer limit) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(format);
        if (outputFile != null) {
            params.add(outputFile);
        }
        if (lastUpdated != null) {
            params.add("" + lastUpdated);
        }
        if (limit != null) {
            params.add("" + limit);
        }
        this.inputParams = params.toArray(new String[0]);
    }

    @Test
    public void testObtainAndFilterSummary() throws Exception {
        TASK.validateInput(this.inputParams);
        Assert.assertEquals((Object)TestMetaTookTaskMetadataSummary.TASK.formatJson, (Object)"-json".equals(this.inputParams[0]));
        Pair result = TASK.obtainAndFilterSummary();
        MetaSummarySchema schema = (MetaSummarySchema)result.getLeft();
        if (TestMetaTookTaskMetadataSummary.TASK.formatJson) {
            Assert.assertEquals(Arrays.asList("metadata", "format-version"), (Object)schema.getFields());
        } else {
            Assert.assertEquals(Arrays.asList("numBranches", "numTags", "numDataFiles", "numSnapshots", "format-version"), (Object)schema.getFields());
        }
        List summaries = (List)result.getRight();
        int size = this.inputParams.length > 2 ? 2 + Integer.parseInt(this.inputParams[2]) : 5;
        int limit = this.inputParams.length > 3 ? 2 + Integer.parseInt(this.inputParams[3]) : 5;
        Assert.assertEquals((long)Math.min(size, limit), (long)summaries.size());
        HashMap summaryMap = new HashMap();
        String catalog = MetaStoreUtils.getDefaultCatalog((Configuration)conf);
        summaries.forEach(summary -> summaryMap.put(new TableName(catalog, summary.getDbName(), summary.getTblName()), summary));
        MetadataTableSummary summary2 = (MetadataTableSummary)summaryMap.get(new TableName(catalog, DB, "tbl1"));
        Assert.assertEquals((long)3L, (long)summary2.getPartitionCount());
        Assert.assertEquals((long)3L, (long)summary2.getNumFiles());
        Assert.assertEquals((long)30L, (long)summary2.getNumRows());
        Assert.assertEquals((long)3000L, (long)summary2.getTotalSize());
        Assert.assertEquals((Object)"parquet", (Object)summary2.getFileFormat());
        Assert.assertEquals((Object)"HIVE_EXTERNAL", (Object)summary2.getTableType());
        summary2 = (MetadataTableSummary)summaryMap.get(new TableName(catalog, DB, "tbl2"));
        Assert.assertEquals((long)0L, (long)summary2.getPartitionCount());
        Assert.assertEquals((long)2L, (long)summary2.getNumFiles());
        Assert.assertEquals((long)20L, (long)summary2.getNumRows());
        Assert.assertEquals((long)2000L, (long)summary2.getTotalSize());
        Assert.assertEquals((Object)"orc", (Object)summary2.getFileFormat());
        Assert.assertEquals((Object)"HIVE_ACID_INSERT_ONLY", (Object)summary2.getTableType());
        int i = 3;
        for (int j = 0; j < summaries.size() - 2; ++j) {
            TableName tableName = new TableName(catalog, DB, TBL_PREFIX + i);
            summary2 = (MetadataTableSummary)summaryMap.get(tableName);
            Assert.assertEquals((long)0L, (long)summary2.getPartitionCount());
            Assert.assertEquals((long)i, (long)summary2.getNumFiles());
            Assert.assertEquals((long)(i * 10), (long)summary2.getNumRows());
            Assert.assertEquals((long)(i * 1000), (long)summary2.getTotalSize());
            Assert.assertEquals((Object)"ICEBERG", (Object)summary2.getTableType());
            Assert.assertEquals((Object)"v2", summary2.getExtraSummary().remove("format-version"));
            Map<String, Object> icebergSummary = FakeIcebergSummaryHandler.TABLE_TO_SUMMARY.get(tableName);
            Assert.assertFalse((boolean)icebergSummary.isEmpty());
            if (TestMetaTookTaskMetadataSummary.TASK.formatJson) {
                Assert.assertEquals(icebergSummary, summary2.getExtraSummary().get("metadata"));
            } else {
                Assert.assertEquals(icebergSummary, (Object)summary2.getExtraSummary());
            }
            ++i;
        }
    }

    @AfterClass
    public static void destroy() throws Exception {
        try (HiveMetaStoreClient msc = new HiveMetaStoreClient(conf);){
            Database database = msc.getDatabase(DB);
            if (database != null) {
                TestMetaTookTaskMetadataSummary.cleanDirectory(database.getLocationUri(), database.getManagedLocationUri());
            }
            msc.dropDatabase(DB, true, true, true);
        }
        finally {
            RULE.after();
        }
    }

    private static void cleanDirectory(String ... location) {
        try {
            if (location != null) {
                for (String loc : location) {
                    if (loc == null) continue;
                    Path path = new Path(loc);
                    path.getFileSystem(conf).delete(path, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RULE = new Derby();
    }

    public static class FakeIcebergSummaryHandler
    implements MetaSummaryHandler {
        private static final String NUM_BRANCHES = "numBranches";
        private static final String NUM_TAGS = "numTags";
        private static final String NUM_DATA_FILES = "numDataFiles";
        private static final String NUM_SNAPSHOTS = "numSnapshots";
        private static final String METADATA = "metadata";
        private static final String VERSION = "format-version";
        private static final Map<TableName, Map<String, Object>> TABLE_TO_SUMMARY = new HashMap<TableName, Map<String, Object>>();
        private Configuration configuration;
        private boolean formatJson;

        public void initialize(String catalog, boolean formatJson, MetaSummarySchema schema) {
            this.formatJson = formatJson;
            if (formatJson) {
                schema.addFields(new String[]{METADATA, VERSION});
            } else {
                schema.addFields(new String[]{NUM_BRANCHES, NUM_TAGS, NUM_DATA_FILES, NUM_SNAPSHOTS, VERSION});
            }
        }

        public void appendSummary(TableName tableName, MetadataTableSummary tableSummary) {
            SummaryMapBuilder builder = new SummaryMapBuilder();
            Map summary = TABLE_TO_SUMMARY.getOrDefault(tableName, new HashMap());
            builder.add(VERSION, (Object)"v2");
            HashMap<String, Object> metadata = new HashMap<String, Object>();
            metadata.put(NUM_DATA_FILES, summary.getOrDefault(NUM_DATA_FILES, 0));
            metadata.put(NUM_SNAPSHOTS, summary.getOrDefault(NUM_SNAPSHOTS, 0));
            metadata.put(NUM_BRANCHES, summary.getOrDefault(NUM_BRANCHES, 0));
            metadata.put(NUM_TAGS, summary.getOrDefault(NUM_TAGS, 0));
            if (this.formatJson) {
                builder.add(METADATA, metadata);
                tableSummary.addExtra(builder);
            } else {
                metadata.forEach((arg_0, arg_1) -> ((SummaryMapBuilder)builder).add(arg_0, arg_1));
                tableSummary.addExtra(builder);
            }
        }

        public static void addTableSummary(TableName tableName, int numBranches, int numTags, int numSnapshots, int numDataFiles) {
            SummaryMapBuilder builder = new SummaryMapBuilder().add(NUM_BRANCHES, (Object)numBranches).add(NUM_TAGS, (Object)numTags).add(NUM_SNAPSHOTS, (Object)numSnapshots).add(NUM_DATA_FILES, (Object)numDataFiles);
            TABLE_TO_SUMMARY.put(tableName, builder.build());
        }

        public void close() throws Exception {
        }

        public void setConf(Configuration conf) {
            this.configuration = conf;
        }

        public Configuration getConf() {
            return this.configuration;
        }
    }
}

