/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.testutils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.message.Message;

@Plugin(name="CapturingLogAppender", category="Core", elementType="appender", printObject=true)
public class CapturingLogAppender
extends AbstractAppender {
    private static List<LogEvent> EVENTS = new ArrayList<LogEvent>();

    private CapturingLogAppender(String name, Filter filter, Layout<? extends Serializable> layout) {
        super(name, filter, layout);
    }

    public void append(LogEvent logEvent) {
        EVENTS.add(logEvent);
    }

    public static List<String> findLogMessagesContaining(Level level, String substring) {
        return EVENTS.stream().filter(event -> event.getLevel() == level).map(LogEvent::getMessage).map(Message::getFormattedMessage).filter(msg -> msg.contains(substring)).collect(Collectors.toList());
    }

    @PluginFactory
    public static CapturingLogAppender createAppender(@PluginAttribute(value="name") String name) {
        return new CapturingLogAppender(name, null, null);
    }
}

