/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.HMSServletTest;
import org.apache.hadoop.hive.metastore.properties.HMSTestBase;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class HMSServletTest1
extends HMSServletTest {
    @Override
    public void tearDown() throws Exception {
        if (this.client instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.client)).close();
            this.client = null;
        }
        super.tearDown();
    }

    @Override
    protected HMSTestBase.PropertyClient createClient(Configuration conf, int sport) throws Exception {
        String path = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_PATH);
        URL url = new URL("http://hive@localhost:" + sport + "/" + path + "/" + this.NS);
        String jwt = this.generateJWT();
        return new JSonHttpClient(jwt, url.toString());
    }

    public static class JSonHttpClient
    implements HMSTestBase.HttpPropertyClient,
    AutoCloseable {
        private final String uri;
        private final HttpClient client;
        private final String jwt;

        JSonHttpClient(String token, String uri) {
            this.jwt = token;
            this.uri = uri;
            this.client = HttpClients.createDefault();
        }

        @Override
        public void close() throws Exception {
            if (this.client instanceof AutoCloseable) {
                ((AutoCloseable)this.client).close();
            }
        }

        private <M extends HttpEntityEnclosingRequestBase> M prepareMethod(M method, String msgBody) throws IOException {
            method.addHeader("Authorization", "Bearer " + this.jwt);
            method.addHeader("Content-Type", "application/json");
            method.addHeader("Accept", "application/json");
            method.addHeader("x-actor-username", "hive");
            StringEntity sre = new StringEntity(msgBody, ContentType.APPLICATION_JSON);
            method.setEntity((HttpEntity)sre);
            return method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean clientPut(Object args) throws IOException {
            HttpPut put = this.prepareMethod(new HttpPut(this.uri), new Gson().toJson(args));
            HttpResponse response = this.client.execute((HttpUriRequest)put);
            try {
                boolean bl = 200 == response.getStatusLine().getStatusCode();
                return bl;
            }
            finally {
                if (response instanceof Closeable) {
                    ((Closeable)response).close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object clientPost(Object args) throws IOException {
            HttpPost post = this.prepareMethod(new HttpPost(this.uri), new Gson().toJson(args));
            HttpResponse response = this.client.execute((HttpUriRequest)post);
            try {
                HttpEntity entity;
                if (200 == response.getStatusLine().getStatusCode() && (entity = response.getEntity()) != null) {
                    Gson gson = new GsonBuilder().create();
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    Charset charset = contentType.getCharset();
                    InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                    Object object = gson.fromJson((Reader)reader, Object.class);
                    return object;
                }
            }
            finally {
                if (response instanceof Closeable) {
                    ((Closeable)response).close();
                }
            }
            return null;
        }

        @Override
        public boolean setProperties(Map<String, String> properties) {
            try {
                return this.clientPut(properties);
            }
            catch (IOException xio) {
                return false;
            }
        }

        @Override
        public Map<String, Map<String, String>> getProperties(String mapPrefix, String mapPredicate, String ... selection) {
            TreeMap<String, Object> args = new TreeMap<String, Object>();
            args.put("prefix", mapPrefix);
            if (mapPredicate != null) {
                args.put("predicate", mapPredicate);
            }
            if (selection != null && selection.length > 0) {
                args.put("selection", selection);
            }
            try {
                Object result = this.clientPost(args);
                return result instanceof Map ? (Map)result : null;
            }
            catch (IOException xio) {
                return null;
            }
        }

        @Override
        public Map<String, String> getProperties(List<String> selection) throws IOException {
            try {
                TreeMap<String, Object> args = new TreeMap<String, Object>();
                args.put("method", "fetchProperties");
                args.put("keys", selection);
                Object result = this.clientPost(args);
                return result instanceof Map ? (Map)result : null;
            }
            catch (IOException xio) {
                return null;
            }
        }
    }
}

