/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.properties.CachingPropertyStore;
import org.apache.hadoop.hive.metastore.properties.HMSPropertyManager;
import org.apache.hadoop.hive.metastore.properties.HMSTestBase;
import org.apache.hadoop.hive.metastore.properties.PropertyException;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class HMSDirectTest
extends HMSTestBase {
    protected ObjectStore objectStore = null;
    static Random RND = new Random(20230424L);
    protected String DB;

    @Override
    protected int createServer(Configuration conf) {
        if (this.objectStore == null) {
            try {
                this.DB = "dbtest" + RND.nextInt(100);
                this.objectStore = new ObjectStore();
                this.objectStore.setConf(conf);
                Warehouse warehouse = new Warehouse(conf);
                HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)warehouse);
                this.objectStore.createDatabase(new DatabaseBuilder().setCatalogName("hive").setName(this.DB).setDescription("description").setLocation("locationurl").build(conf));
            }
            catch (InvalidObjectException | InvalidOperationException | MetaException xmeta) {
                throw new PropertyException("unable to initialize store", xmeta);
            }
        }
        return 0;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.objectStore != null) {
            this.objectStore.flushCache();
            this.objectStore.dropDatabase("hive", this.DB);
        }
    }

    @Override
    protected HMSTestBase.PropertyClient createClient(Configuration conf, int port) throws Exception {
        HMSPropertyManager mgr = new HMSPropertyManager(this.objectStore.getPropertyStore());
        return new DirectPropertyClient(mgr);
    }

    @Test
    public void testDirectProperties() {
        HMSPropertyManager.declareClusterProperty((String)"clstrp0", (PropertyType)PropertyType.STRING, (Object)"Spark");
        HMSPropertyManager.declareDatabaseProperty((String)"store", (PropertyType)PropertyType.STRING, (Object)"ORC");
        HMSPropertyManager.declareTableProperty((String)"id", (PropertyType)PropertyType.INTEGER, null);
        HMSPropertyManager.declareTableProperty((String)"name", (PropertyType)PropertyType.STRING, null);
        HMSPropertyManager.declareTableProperty((String)"uuid", (PropertyType)PropertyType.STRING, null);
        HMSPropertyManager.declareTableProperty((String)"fillfactor", (PropertyType)PropertyType.DOUBLE, (Object)0.75);
        HMSPropertyManager.declareTableProperty((String)"creation date", (PropertyType)PropertyType.DATETIME, (Object)"2023-01-06T12:16:00");
        HMSPropertyManager.declareTableProperty((String)"project", (PropertyType)PropertyType.STRING, (Object)"Hive");
        HMSPropertyManager hms = new HMSPropertyManager(this.objectStore.getPropertyStore());
        hms.setProperty("ser.der.id", (Object)42);
        hms.setProperty("ser.der.name", (Object)"serder");
        hms.setProperty("ser.der.project", (Object)"Metastore");
        hms.commit();
        PropertyStore store = this.objectStore.getPropertyStore();
        if (store instanceof CachingPropertyStore) {
            ((CachingPropertyStore)store).clearCache();
        }
        Assert.assertEquals((Object)42, (Object)hms.getPropertyValue("ser.der.id"));
        Assert.assertEquals((Object)"serder", (Object)hms.getPropertyValue("ser.der.name"));
        Assert.assertEquals((Object)"Metastore", (Object)hms.getPropertyValue("ser.der.project"));
    }

    @Test
    public void testDirectProperties0() throws Exception {
        this.runOtherProperties0(this.client);
    }

    @Test
    public void testDirectProperties1() throws Exception {
        this.runOtherProperties1(this.client);
    }

    static class DirectPropertyClient
    implements HMSTestBase.HttpPropertyClient {
        private final HMSPropertyManager hms;

        DirectPropertyClient(HMSPropertyManager hms) {
            this.hms = hms;
        }

        @Override
        public boolean setProperties(Map<String, String> properties) {
            try {
                this.hms.setProperties(properties);
                this.hms.commit();
                return true;
            }
            catch (Exception tex) {
                this.hms.rollback();
                return false;
            }
        }

        @Override
        public Map<String, Map<String, String>> getProperties(String mapPrefix, String mapPredicate, String ... selection) throws IOException {
            try {
                List<String> project = selection == null || selection.length == 0 ? null : Arrays.asList(selection);
                Map selected = this.hms.selectProperties(mapPrefix, mapPredicate, project);
                TreeMap<String, Map<String, String>> returned = new TreeMap<String, Map<String, String>>();
                selected.forEach((k, v) -> returned.put((String)k, v.export(project == null)));
                this.hms.commit();
                return returned;
            }
            catch (Exception tex) {
                this.hms.rollback();
                return null;
            }
        }

        @Override
        public Map<String, String> getProperties(List<String> keys) throws IOException {
            TreeMap<String, String> returned = new TreeMap<String, String>();
            try {
                for (String key : keys) {
                    String value = this.hms.exportPropertyValue(key);
                    if (value == null) continue;
                    returned.put(key, value);
                }
                this.hms.commit();
                return returned;
            }
            catch (Exception tex) {
                this.hms.rollback();
                return null;
            }
        }
    }
}

