/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.AuditLeaderListener;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.StaticLeaderElection;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaderListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditLeaderListener() throws Exception {
        Path location = new Path(".", "test_audit_leader_listener_" + System.currentTimeMillis());
        Configuration conf = MetastoreConf.newMetastoreConf();
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        try {
            MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_NEW_AUDIT_FILE, (boolean)true);
            MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_AUDIT_FILE_LIMIT, (long)3L);
            AuditLeaderListener listener = new AuditLeaderListener(location, conf);
            StaticLeaderElection election = new StaticLeaderElection();
            election.setName("testAuditLeaderListener");
            listener.takeLeadership((LeaderElection)election);
            List fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Pattern pattern = Pattern.compile("leader_testAuditLeaderListener_[0-9]+\\.json");
            fileStatuses.forEach(fileStatus -> Assert.assertTrue((boolean)pattern.matcher(fileStatus.getPath().getName()).matches()));
            FileStatus oldestFile = (FileStatus)fileStatuses.get(0);
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((boolean)fileStatuses.remove(oldestFile));
            Assert.assertTrue((fileStatuses.size() == 1 ? 1 : 0) != 0);
            FileStatus tmpFileStatus = (FileStatus)fileStatuses.get(0);
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((fileStatuses.size() == 3 ? 1 : 0) != 0);
            ArrayList tempFileStatuses = new ArrayList(fileStatuses);
            fileStatuses.forEach(fileStatus -> Assert.assertTrue((boolean)pattern.matcher(fileStatus.getPath().getName()).matches()));
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((fileStatuses.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)tempFileStatuses.remove(oldestFile));
            Assert.assertTrue((boolean)tempFileStatuses.contains(tmpFileStatus));
            Assert.assertFalse((boolean)fileStatuses.contains(oldestFile));
            tempFileStatuses.removeAll(fileStatuses);
            Assert.assertTrue((boolean)tempFileStatuses.isEmpty());
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((fileStatuses.size() == 3 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)fileStatuses.contains(tmpFileStatus));
            fileSystem.delete(location, true);
            Assert.assertTrue((boolean)FileUtils.isDirEmpty((FileSystem)fileSystem, (Path)location));
            MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_NEW_AUDIT_FILE, (boolean)false);
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((fileStatuses.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((FileStatus)fileStatuses.get(0)).getPath().getName().equals("leader_testAuditLeaderListener.json"));
            listener.takeLeadership((LeaderElection)election);
            listener.takeLeadership((LeaderElection)election);
            fileStatuses = FileUtils.getFileStatusRecurse((Path)location, (FileSystem)fileSystem);
            Assert.assertTrue((fileStatuses.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((FileStatus)fileStatuses.get(0)).getPath().getName().equals("leader_testAuditLeaderListener.json"));
        }
        finally {
            FileUtils.moveToTrash((FileSystem)fileSystem, (Path)location, (Configuration)conf, (boolean)true);
        }
    }
}

