/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;
import org.apache.hadoop.hive.metastore.leader.LeaseLeaderElection;
import org.apache.hadoop.hive.metastore.leader.StaticLeaderElection;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaderElection {
    @Test
    public void testConfigLeaderElection() throws Exception {
        StaticLeaderElection election = new StaticLeaderElection();
        String leaderHost = "host1.work";
        Configuration configuration = MetastoreConf.newMetastoreConf();
        election.tryBeLeader(configuration, (Object)leaderHost);
        Assert.assertTrue((boolean)election.isLeader());
        MetastoreConf.setVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_HOUSEKEEPING_LEADER_HOSTNAME, (String)leaderHost);
        election.tryBeLeader(configuration, (Object)leaderHost);
        Assert.assertTrue((boolean)election.isLeader());
        election.tryBeLeader(configuration, (Object)"host2.work");
        Assert.assertFalse((boolean)election.isLeader());
    }

    @Test
    public void testLeaseLeaderElection() throws Exception {
        Configuration configuration = MetastoreConf.newMetastoreConf();
        MetastoreConf.setTimeVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (long)3L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setTimeVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LOCK_SLEEP_BETWEEN_RETRIES, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        MetastoreConf.setBoolVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        TestTxnDbUtil.setConfValues(configuration);
        TestTxnDbUtil.prepDb(configuration);
        TxnStore txnStore = TxnUtils.getTxnStore((Configuration)configuration);
        configuration.setBoolean("metastore.renew.leader.lease", false);
        TableName mutex = new TableName("hive", "default", "leader_lease_ms");
        LeaseLeaderElection instance1 = new LeaseLeaderElection();
        AtomicBoolean flag1 = new AtomicBoolean(false);
        instance1.addStateListener((LeaderElection.LeadershipStateListener)new TestLeaderListener(flag1));
        instance1.tryBeLeader(configuration, mutex);
        Assert.assertTrue((flag1.get() && instance1.isLeader() ? 1 : 0) != 0);
        configuration.setBoolean("metastore.renew.leader.lease", true);
        LeaseLeaderElection instance2 = new LeaseLeaderElection();
        AtomicBoolean flag2 = new AtomicBoolean(false);
        instance2.addStateListener((LeaderElection.LeadershipStateListener)new TestLeaderListener(flag2));
        instance2.tryBeLeader(configuration, mutex);
        Assert.assertFalse((flag2.get() || instance2.isLeader() ? 1 : 0) != 0);
        ExecutorService service = Executors.newFixedThreadPool(4);
        this.wait(service, flag1, flag2);
        Assert.assertTrue((instance2.isLeader() && flag2.get() ? 1 : 0) != 0);
        Assert.assertFalse((flag1.get() || instance1.isLeader() ? 1 : 0) != 0);
        Assert.assertTrue((flag2.get() && instance2.isLeader() ? 1 : 0) != 0);
        long lockId2 = instance2.getLockId();
        txnStore.unlock(new UnlockRequest(lockId2));
        this.wait(service, flag1, flag2);
        Assert.assertFalse((flag2.get() || instance2.isLeader() ? 1 : 0) != 0);
        Assert.assertTrue((lockId2 > 0L ? 1 : 0) != 0);
        Assert.assertFalse((instance2.getLockId() == lockId2 ? 1 : 0) != 0);
        long lockId1 = instance1.getLockId();
        txnStore.unlock(new UnlockRequest(lockId1));
        this.wait(service, flag1, flag2);
        Assert.assertFalse((lockId1 == instance1.getLockId() ? 1 : 0) != 0);
        Assert.assertTrue((lockId1 > 0L ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertFalse((flag1.get() || instance1.isLeader() ? 1 : 0) != 0);
            Assert.assertTrue((flag2.get() && instance2.isLeader() ? 1 : 0) != 0);
            Thread.sleep(1000L);
        }
    }

    private void wait(ExecutorService service, Object ... obj) throws Exception {
        Future[] fs = new Future[obj.length];
        for (int i = 0; i < obj.length; ++i) {
            Object monitor = obj[i];
            fs[i] = service.submit(() -> {
                try {
                    Object object = monitor;
                    synchronized (object) {
                        monitor.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        for (Future f : fs) {
            f.get();
        }
    }

    static class TestLeaderListener
    implements LeaderElection.LeadershipStateListener {
        AtomicBoolean flag;

        TestLeaderListener(AtomicBoolean flag) {
            this.flag = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void takeLeadership(LeaderElection election) throws Exception {
            AtomicBoolean atomicBoolean = this.flag;
            synchronized (atomicBoolean) {
                this.flag.set(true);
                this.flag.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lossLeadership(LeaderElection election) throws Exception {
            AtomicBoolean atomicBoolean = this.flag;
            synchronized (atomicBoolean) {
                this.flag.set(false);
                this.flag.notifyAll();
            }
        }
    }
}

