/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.ldap;

import java.io.IOException;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.ldap.DirSearch;
import org.apache.hadoop.hive.metastore.ldap.Filter;
import org.apache.hadoop.hive.metastore.ldap.FilterFactory;
import org.apache.hadoop.hive.metastore.ldap.UserFilterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestUserFilter {
    private FilterFactory factory;
    private Configuration conf;
    @Mock
    private DirSearch search;

    @Before
    public void setup() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.factory = new UserFilterFactory();
    }

    @Test
    public void testFactory() {
        this.conf.unset(MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER.getVarname());
        Assert.assertNull((Object)this.factory.getInstance(this.conf));
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1");
        Assert.assertNotNull((Object)this.factory.getInstance(this.conf));
    }

    @Test
    public void testApplyPositive() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1,User2,uSeR3");
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User1");
        filter.apply(this.search, "uid=user2,ou=People,dc=example,dc=com");
        filter.apply(this.search, "User3@mydomain.com");
    }

    @Test(expected=AuthenticationException.class)
    public void testApplyNegative() throws AuthenticationException, NamingException, IOException {
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_PLAIN_LDAP_USERFILTER, (String)"User1,User2");
        Filter filter = this.factory.getInstance(this.conf);
        filter.apply(this.search, "User3");
    }
}

