/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AlterPartitionsEvent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestAlterPartitionsEvent {
    private AlterPartitionsEvent event;
    private List<Partition> expectedParts;
    private Map<Long, List<Partition>> writeIdToParts;
    private int batchSize;
    private int expectedBatch;

    @Parameterized.Parameters
    public static Collection<Object[]> getIteratorToTest() {
        ArrayList<Partition> parts = new ArrayList<Partition>();
        IntStream.range(0, 10).forEach(i -> {
            Partition partition = new Partition();
            partition.setValues(Arrays.asList("" + i, "part" + i));
            partition.setWriteId(i < 5 ? 1L : 2L);
            parts.add(partition);
        });
        Partition partition = new Partition();
        partition.setValues(Arrays.asList("10", "part10"));
        partition.setWriteId(3L);
        parts.add(partition);
        AlterPartitionsEvent event = new AlterPartitionsEvent(parts, parts, new Table(), false, true, null);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{event, 1000, parts, 3});
        params.add(new Object[]{event, 5, parts, 3});
        params.add(new Object[]{event, 3, parts, 5});
        params.add(new Object[]{event, 2, parts, 7});
        params.add(new Object[]{event, 1, parts, 11});
        params.add(new Object[]{event, -1, parts, 3});
        return params;
    }

    public TestAlterPartitionsEvent(AlterPartitionsEvent event, int batchSize, List<Partition> expectedParts, int expectedBatch) {
        this.event = event;
        this.batchSize = batchSize;
        this.expectedParts = expectedParts;
        this.expectedBatch = expectedBatch;
        this.writeIdToParts = new HashMap<Long, List<Partition>>();
        expectedParts.stream().forEach(partition -> this.writeIdToParts.computeIfAbsent(partition.getWriteId(), k -> new ArrayList()).add(partition));
    }

    @Test
    public void testGetNewPartitionsIterator() {
        int batch = 0;
        ArrayList actual = new ArrayList();
        HashMap idToParts = new HashMap();
        Iterator iterator = this.event.getNewPartsIterator(this.batchSize);
        while (iterator.hasNext()) {
            List partitions = (List)iterator.next();
            Assert.assertTrue((this.batchSize <= 0 || partitions.size() <= this.batchSize ? 1 : 0) != 0);
            Long writeId = null;
            for (Partition part : partitions) {
                if (writeId == null) {
                    writeId = part.getWriteId();
                    continue;
                }
                Assert.assertEquals((long)writeId, (long)part.getWriteId());
            }
            idToParts.putIfAbsent(writeId, new ArrayList());
            ((List)idToParts.get(writeId)).addAll(partitions);
            ++batch;
            actual.addAll(partitions);
        }
        Assert.assertEquals((long)5L, (long)((List)idToParts.get(1L)).size());
        Assert.assertEquals((long)5L, (long)((List)idToParts.get(2L)).size());
        Assert.assertEquals(this.writeIdToParts, idToParts);
        Assert.assertEquals((long)this.expectedBatch, (long)batch);
        Assert.assertEquals(this.expectedParts, actual);
    }
}

