/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dbinstall.rules;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;

public class Mssql
extends DatabaseRule {
    @Override
    public String getDockerImageName() {
        return "mcr.microsoft.com/mssql/server:2019-latest";
    }

    @Override
    public String[] getDockerAdditionalArgs() {
        return this.buildArray("-p", "1433:1433", "-e", "ACCEPT_EULA=Y", "-e", "SA_PASSWORD=" + this.getDbRootPassword(), "-d");
    }

    @Override
    public String getDbType() {
        return "mssql";
    }

    @Override
    public String getDbRootUser() {
        return "SA";
    }

    @Override
    public String getDbRootPassword() {
        return "Its-a-s3cret";
    }

    @Override
    public String getJdbcDriver() {
        return SQLServerDriver.class.getName();
    }

    @Override
    public String getJdbcUrl(String hostAddress) {
        return "jdbc:sqlserver://" + hostAddress + ":1433;DatabaseName=hivedb;";
    }

    @Override
    public String getInitialJdbcUrl(String hostAddress) {
        return "jdbc:sqlserver://" + hostAddress + ":1433";
    }

    @Override
    public boolean isContainerReady(DatabaseRule.ProcessResults pr) {
        return pr.stdout.contains("Recovery is complete. This is an informational message only. No user action is required.");
    }

    @Override
    public String getHivePassword() {
        return "h1vePassword!";
    }
}

