/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DefaultStorageSchemaReader;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.MaterializationsRebuildLockCleanerTask;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.RuntimeStatsCleanerTask;
import org.apache.hadoop.hive.metastore.SerDeStorageSchemaReader;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.EventCleanerTask;
import org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager;
import org.apache.hadoop.hive.metastore.txn.service.AcidHouseKeeperService;
import org.apache.hadoop.hive.metastore.txn.service.AcidOpenTxnsCounterService;
import org.apache.hadoop.hive.metastore.txn.service.AcidTxnCleanerService;
import org.apache.hadoop.hive.metastore.txn.service.CompactionHouseKeeperService;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MetastoreUnitTest.class})
public class TestMetastoreConf {
    private static final Logger LOG = LoggerFactory.getLogger(TestMetastoreConf.class);
    private Configuration conf;
    private Random rand = new Random();

    @After
    public void unsetProperties() {
        MetastoreConf.setHiveSiteLocation(null);
        for (MetastoreConf.ConfVars var : MetastoreConf.dataNucleusAndJdoConfs) {
            System.getProperties().remove(var.getVarname());
        }
    }

    private void createConfFile(String fileName, boolean inConf, String envVar, Map<String, String> properties) throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, this.randomFileName());
        Assume.assumeTrue((boolean)dir.mkdir());
        dir.deleteOnExit();
        System.setProperty("metastore.testing.env.workaround.dont.ever.set.this." + envVar, dir.getAbsolutePath());
        if (inConf) {
            dir = new File(dir, "conf");
            Assume.assumeTrue((boolean)dir.mkdir());
            dir.deleteOnExit();
        }
        File confFile = new File(dir, fileName);
        confFile.deleteOnExit();
        FileWriter writer = new FileWriter(confFile);
        writer.write("<configuration>\n");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            writer.write("  <property>\n");
            writer.write("    <name>");
            writer.write(entry.getKey());
            writer.write("</name>\n");
            writer.write("    <value>");
            writer.write(entry.getValue());
            writer.write("</value>\n");
            writer.write("  </property>\n");
        }
        writer.write("</configuration>\n");
        writer.close();
    }

    private String randomFileName() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            buf.append((char)(this.rand.nextInt(26) + 97));
        }
        return buf.toString();
    }

    private Map<String, String> instaMap(String ... vals) {
        HashMap<String, String> properties = new HashMap<String, String>(vals.length / 2);
        for (int i = 0; i < vals.length; i += 2) {
            properties.put(vals[i], vals[i + 1]);
        }
        return properties;
    }

    @Test
    public void defaults() {
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((Object)"defaultval", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((long)42L, (long)MetastoreConf.getLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((double)Math.PI, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)1.0E-7);
        Assert.assertTrue((boolean)MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
        Assert.assertEquals((long)1L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((long)1000L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
        Collection list = MetastoreConf.getStringCollection((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_LIST_ENTRY);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("a"));
        Assert.assertTrue((boolean)list.contains("b"));
        Assert.assertTrue((boolean)list.contains("c"));
        Assert.assertSame(TestClass1.class, (Object)MetastoreConf.getClass((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLASS_TEST_ENTRY, TestClass1.class, Runnable.class));
        Assert.assertEquals((Object)"defaultval", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.STR_TEST_ENTRY.getVarname()));
        Assert.assertEquals((Object)"defaultval", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.STR_TEST_ENTRY.getHiveName()));
        Assert.assertEquals((Object)"defaultval", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((Object)"42", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((Object)"3.141592653589793", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY));
        Assert.assertEquals((Object)"true", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
    }

    @Test
    public void readMetastoreSiteWithMetastoreConfDir() throws IOException {
        this.createConfFile("metastore-site.xml", false, "METASTORE_CONF_DIR", this.instaMap("test.str", "notthedefault", "test.long", "37", "test.double", "1.8", "test.bool", "false", "test.time", "30s", "test.str.list", "d", "test.class", TestClass2.class.getName()));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((Object)"notthedefault", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((long)37L, (long)MetastoreConf.getLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((long)37L, (long)MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((double)1.8, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)0.01);
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((long)30000L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
        Collection list = MetastoreConf.getStringCollection((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_LIST_ENTRY);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("d"));
        Assert.assertSame(TestClass2.class, (Object)MetastoreConf.getClass((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLASS_TEST_ENTRY, TestClass1.class, Runnable.class));
        Assert.assertEquals((Object)"1.8", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY.getVarname()));
        Assert.assertEquals((Object)"1.8", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY.getHiveName()));
        Assert.assertEquals((Object)"notthedefault", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((Object)"37", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((Object)"1.8", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY));
        Assert.assertEquals((Object)"false", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
    }

    @Test
    public void readMetastoreSiteWithMetastoreHomeDir() throws IOException {
        this.createConfFile("metastore-site.xml", true, "METASTORE_HOME", this.instaMap("test.long", "24"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((long)24L, (long)MetastoreConf.getLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
    }

    @Test
    public void readHiveSiteWithHiveConfDir() throws IOException {
        this.createConfFile("hive-site.xml", false, "HIVE_CONF_DIR", this.instaMap("test.double", "1.8"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((double)1.8, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)0.01);
    }

    @Test
    public void readHiveSiteWithHiveHomeDir() throws IOException {
        this.createConfFile("hive-site.xml", true, "HIVE_HOME", this.instaMap("test.bool", "false"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertFalse((boolean)MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
    }

    @Test
    public void readHiveMetastoreSiteWithHiveConfDir() throws IOException {
        this.createConfFile("metastore-site.xml", false, "HIVE_CONF_DIR", this.instaMap("test.double", "1.8"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((double)1.8, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)0.01);
    }

    @Test
    public void readHiveMetastoreSiteWithHiveHomeDir() throws IOException {
        this.createConfFile("metastore-site.xml", true, "HIVE_HOME", this.instaMap("test.bool", "false"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertFalse((boolean)MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
    }

    @Test
    public void setAndRead() throws IOException {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY, (String)"notthedefault");
        Assert.assertEquals((Object)"notthedefault", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        MetastoreConf.setDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY, (double)1.8);
        Assert.assertEquals((double)1.8, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)0.01);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY, (long)24L);
        Assert.assertEquals((long)24L, (long)MetastoreConf.getLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (long)5L, (TimeUnit)TimeUnit.MINUTES);
        Assert.assertEquals((long)300L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((long)300000L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Test
    public void valuesSetFromProperties() {
        try {
            System.setProperty(MetastoreConf.ConfVars.STR_TEST_ENTRY.getVarname(), "from-properties");
            this.conf = MetastoreConf.newMetastoreConf();
            Assert.assertEquals((Object)"from-properties", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        }
        finally {
            System.getProperties().remove(MetastoreConf.ConfVars.STR_TEST_ENTRY.getVarname());
        }
    }

    @After
    public void unsetEnvWorkAround() {
        System.getProperties().remove("metastore.testing.env.workaround.dont.ever.set.this.METASTORE_CONF_DIR");
        System.getProperties().remove("metastore.testing.env.workaround.dont.ever.set.this.METASTORE_HOME");
        System.getProperties().remove("metastore.testing.env.workaround.dont.ever.set.this.HIVE_CONF_DIR");
        System.getProperties().remove("metastore.testing.env.workaround.dont.ever.set.this.HIVE_HOME");
    }

    @Test
    public void hiveNames() throws IOException {
        this.createConfFile("metastore-site.xml", false, "METASTORE_CONF_DIR", this.instaMap("hive.test.str", "hivedefault", "hive.test.double", "1.9", "hive.test.long", "89", "hive.test.bool", "false", "hive.test.time", "3s", "hive.test.str.list", "g,h,i,j", "hive.test.class", TestClass2.class.getName()));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((Object)"hivedefault", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((double)1.9, (double)MetastoreConf.getDoubleVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY), (double)0.01);
        Assert.assertEquals((long)89L, (long)MetastoreConf.getLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((long)89L, (long)MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((long)3L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertEquals((long)3000L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
        Collection list = MetastoreConf.getStringCollection((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_LIST_ENTRY);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("g"));
        Assert.assertTrue((boolean)list.contains("h"));
        Assert.assertTrue((boolean)list.contains("i"));
        Assert.assertTrue((boolean)list.contains("j"));
        Assert.assertSame(TestClass2.class, (Object)MetastoreConf.getClass((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CLASS_TEST_ENTRY, TestClass1.class, Runnable.class));
        Assert.assertEquals((Object)"3s", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname()));
        Assert.assertEquals((Object)"3s", (Object)MetastoreConf.get((Configuration)this.conf, (String)MetastoreConf.ConfVars.TIME_TEST_ENTRY.getHiveName()));
        Assert.assertEquals((Object)"hivedefault", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY));
        Assert.assertEquals((Object)"89", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LONG_TEST_ENTRY));
        Assert.assertEquals((Object)"1.9", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DOUBLE_TEST_ENTRY));
        Assert.assertEquals((Object)"false", (Object)MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BOOLEAN_TEST_ENTRY));
    }

    @Test
    public void testDeprecatedConfigs() throws IOException {
        this.createConfFile("metastore-site.xml", false, "METASTORE_CONF_DIR", this.instaMap("hive.test.str", "hivedefault", "this.is.the.metastore.deprecated.name", "1"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((long)1L, (long)MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEPRECATED_TEST_ENTRY));
        this.createConfFile("metastore-site.xml", false, "METASTORE_CONF_DIR", this.instaMap("hive.test.str", "hivedefault", "this.is.the.hive.deprecated.name", "2"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((long)2L, (long)MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEPRECATED_TEST_ENTRY));
        this.createConfFile("metastore-site.xml", false, "METASTORE_CONF_DIR", this.instaMap("hive.test.str", "hivedefault", "test.deprecated", "3"));
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((long)3L, (long)MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEPRECATED_TEST_ENTRY));
    }

    @Test
    public void timeUnits() throws IOException {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30s");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30seconds");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.SECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30ms");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30msec");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MILLISECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30us");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MICROSECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30usec");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MICROSECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30m");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MINUTES));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30minutes");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.MINUTES));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30ns");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.NANOSECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30nsec");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.NANOSECONDS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30h");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.HOURS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30hours");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.HOURS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30d");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.DAYS));
        this.conf.set(MetastoreConf.ConfVars.TIME_TEST_ENTRY.getVarname(), "30days");
        Assert.assertEquals((long)30L, (long)MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TIME_TEST_ENTRY, (TimeUnit)TimeUnit.DAYS));
    }

    @Test
    public void passedInDefaults() {
        this.conf = MetastoreConf.newMetastoreConf();
        Assert.assertEquals((Object)"passed-in-defaultval", (Object)MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STR_TEST_ENTRY, (String)"passed-in-defaultval"));
    }

    @Test
    public void validValidations() {
        MetastoreConf.ConfVars.STR_SET_ENTRY.validate("a");
        MetastoreConf.ConfVars.TIME_TEST_ENTRY.validate("1");
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_INCLUSIVE.validate("500ms");
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_INCLUSIVE.validate("1500ms");
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_INCLUSIVE.validate("1000ms");
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_EXCLUSIVE.validate("1000ms");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badSetEntry() {
        MetastoreConf.ConfVars.STR_SET_ENTRY.validate("d");
    }

    @Test(expected=IllegalArgumentException.class)
    public void badTimeEntry() {
        MetastoreConf.ConfVars.TIME_TEST_ENTRY.validate("1x");
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeOutsideInclusive() {
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_INCLUSIVE.validate("1day");
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeMinExclusive() {
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_EXCLUSIVE.validate("500ms");
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeMaxExclusive() {
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_EXCLUSIVE.validate("1500ms");
    }

    @Test(expected=IllegalArgumentException.class)
    public void timeOutsideExclusive() {
        MetastoreConf.ConfVars.TIME_VALIDATOR_ENTRY_EXCLUSIVE.validate("1min");
    }

    @Test
    public void unprintable() {
        Assert.assertTrue((boolean)MetastoreConf.isPrintable((String)MetastoreConf.ConfVars.STR_TEST_ENTRY.getVarname()));
        Assert.assertFalse((boolean)MetastoreConf.isPrintable((String)MetastoreConf.ConfVars.PWD.getVarname()));
        Assert.assertFalse((boolean)MetastoreConf.isPrintable((String)MetastoreConf.ConfVars.PWD.getHiveName()));
    }

    @Test
    public void unsetValues() {
        this.conf = MetastoreConf.newMetastoreConf();
        this.conf.set("a.random.key", "abc");
        Assert.assertNull((Object)MetastoreConf.get((Configuration)this.conf, (String)"no.such.key.ever"));
        Assert.assertEquals((Object)"abc", (Object)MetastoreConf.get((Configuration)this.conf, (String)"a.random.key"));
    }

    @Test
    public void dumpConfig() throws IOException {
        this.createConfFile("metastore-site.xml", true, "METASTORE_HOME", this.instaMap("test.long", "23"));
        this.conf = MetastoreConf.newMetastoreConf();
        String dump = MetastoreConf.dumpConfig((Configuration)this.conf);
        Assert.assertThat((Object)dump, (Matcher)new StringContains("Used metastore-site file: file:/"));
        Assert.assertThat((Object)dump, (Matcher)new StringContains("Key: <test.long> old hive key: <hive.test.long>  value: <23>"));
        Assert.assertThat((Object)dump, (Matcher)new StringContains("Key: <test.str> old hive key: <hive.test.str>  value: <defaultval>"));
        Assert.assertThat((Object)dump, (Matcher)new StringEndsWith("Finished MetastoreConf object.\n"));
        Assert.assertThat((Object)dump, (Matcher)CoreMatchers.not((Matcher)new StringContains(MetastoreConf.ConfVars.PWD.getVarname())));
    }

    @Test
    public void testClassNames() {
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.DefaultStorageSchemaReader", (Object)DefaultStorageSchemaReader.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.SerDeStorageSchemaReader", (Object)SerDeStorageSchemaReader.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.HiveAlterHandler", (Object)HiveAlterHandler.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.MaterializationsRebuildLockCleanerTask", (Object)MaterializationsRebuildLockCleanerTask.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.MetastoreTaskThread", (Object)MetastoreTaskThread.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.RetryingHMSHandler", (Object)RetryingHMSHandler.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.RuntimeStatsCleanerTask", (Object)RuntimeStatsCleanerTask.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.events.EventCleanerTask", (Object)EventCleanerTask.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager", (Object)MetastoreDelegationTokenManager.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.txn.service.AcidHouseKeeperService", (Object)AcidHouseKeeperService.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.txn.service.CompactionHouseKeeperService", (Object)CompactionHouseKeeperService.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.txn.service.AcidTxnCleanerService", (Object)AcidTxnCleanerService.class.getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hive.metastore.txn.service.AcidOpenTxnsCounterService", (Object)AcidOpenTxnsCounterService.class.getName());
    }

    static class TestClass1
    implements Runnable {
        TestClass1() {
        }

        @Override
        public void run() {
        }
    }

    static class TestClass2
    implements Runnable {
        TestClass2() {
        }

        @Override
        public void run() {
        }
    }
}

