/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.apache.hadoop.hive.metastore.columnstats.merge.TimestampColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TimestampColumnStatsMergerTest {
    private static final Timestamp TS_1 = new Timestamp(1L);
    private static final Timestamp TS_2 = new Timestamp(2L);
    private static final Timestamp TS_3 = new Timestamp(3L);
    private static final TimestampColumnStatsDataInspector DATA_1 = new TimestampColumnStatsDataInspector();
    private static final TimestampColumnStatsDataInspector DATA_2 = new TimestampColumnStatsDataInspector();
    private static final TimestampColumnStatsDataInspector DATA_3 = new TimestampColumnStatsDataInspector();
    private final TimestampColumnStatsMerger merger = new TimestampColumnStatsMerger();

    @Test
    public void testMergeNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(null).high(null).numNulls(1L).numDVs(0L).build());
        this.merger.merge(aggrObj, aggrObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Timestamp>(Timestamp.class).low(null).high(null).numNulls(2L).numDVs(0L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNullWithNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(null).high(null).numNulls(0L).numDVs(0L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_1).high(TS_3).numNulls(4L).numDVs(2L).hll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).kll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        Assert.assertEquals((Object)newObj.getStatsData(), (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullWithNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_1).high(TS_3).numNulls(4L).numDVs(2L).hll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).kll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(null).high(null).numNulls(2L).numDVs(0L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_1).high(TS_3).numNulls(6L).numDVs(2L).hll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).kll(TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_2).high(TS_2).numNulls(2L).numDVs(1L).hll(TS_2.getSecondsSinceEpoch()).kll(TS_2.getSecondsSinceEpoch()).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_3).high(TS_3).numNulls(3L).numDVs(1L).hll(TS_3.getSecondsSinceEpoch()).kll(TS_3.getSecondsSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_1).high(TS_1).numNulls(1L).numDVs(1L).hll(TS_1.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch()).kll(TS_1.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch()).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Timestamp>(Timestamp.class).low(TS_1).high(TS_3).numNulls(6L).numDVs(3L).hll(TS_2.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch()).kll(TS_2.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch(), TS_1.getSecondsSinceEpoch()).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testCompareSimple() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_1);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((Object)TS_2, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleFlipped() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_2);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)TS_2, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleReversed() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_1);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_2);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMin() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector();
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMax() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector();
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareFirstNullMin() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector();
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSecondNullMin() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_1);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector();
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareFirstNullMax() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector(DATA_1);
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector();
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSecondNullMax() {
        TimestampColumnStatsDataInspector data1 = new TimestampColumnStatsDataInspector();
        TimestampColumnStatsDataInspector data2 = new TimestampColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((Object)TS_1, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    static {
        DATA_1.setLowValue(TS_1);
        DATA_1.setHighValue(TS_1);
        DATA_2.setLowValue(TS_2);
        DATA_2.setHighValue(TS_2);
        DATA_3.setLowValue(TS_3);
        DATA_3.setHighValue(TS_3);
    }
}

