/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.apache.hadoop.hive.metastore.columnstats.merge.DoubleColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class DoubleColumnStatsMergerTest {
    private final DoubleColumnStatsMerger merger = new DoubleColumnStatsMerger();
    private static final DoubleColumnStatsDataInspector DATA_1 = new DoubleColumnStatsDataInspector();
    private static final DoubleColumnStatsDataInspector DATA_2 = new DoubleColumnStatsDataInspector();
    private static final DoubleColumnStatsDataInspector DATA_3 = new DoubleColumnStatsDataInspector();

    @Test
    public void testMergeNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(null).high(null).numNulls(1L).numDVs(0L).build());
        this.merger.merge(aggrObj, aggrObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Double>(Double.TYPE).low(null).high(null).numNulls(2L).numDVs(0L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNullWithNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(null).high(null).numNulls(0L).numDVs(0L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(3.0).numNulls(4L).numDVs(2L).hll(1.0, 3.0, 3.0).kll(1.0, 3.0, 3.0).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(3.0).numNulls(4L).numDVs(2L).hll(1.0, 3.0, 3.0).kll(1.0, 3.0, 3.0).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullWithNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(3.0).numNulls(4L).numDVs(2L).hll(1.0, 3.0, 3.0).kll(1.0, 3.0, 3.0).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(null).high(null).numNulls(2L).numDVs(0L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(3.0).numNulls(6L).numDVs(2L).hll(1.0, 3.0, 3.0).kll(1.0, 3.0, 3.0).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(2.0).high(2.0).numNulls(2L).numDVs(1L).hll(2.0).kll(2.0).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(3.0).high(3.0).numNulls(3L).numDVs(1L).hll(3.0).kll(3.0).build());
        this.merger.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(1.0).numNulls(1L).numDVs(1L).hll(1.0, 1.0).kll(1.0, 1.0).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Double>(Double.TYPE).low(1.0).high(3.0).numNulls(6L).numDVs(3L).hll(2.0, 3.0, 1.0, 1.0).kll(2.0, 3.0, 1.0, 1.0).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testCompareSimple() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_1);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((double)2.0, (double)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareSimpleFlipped() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_2);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((double)2.0, (double)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareSimpleReversed() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_1);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_2);
        Assert.assertEquals((double)1.0, (double)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_2);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((double)1.0, (double)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareNullsMin() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector();
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMax() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector();
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareFirstNullMin() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector();
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((double)1.0, (double)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareSecondNullMin() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_1);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector();
        Assert.assertEquals((double)1.0, (double)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareFirstNullMax() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector(DATA_1);
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector();
        Assert.assertEquals((double)1.0, (double)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)), (double)Double.MIN_VALUE);
    }

    @Test
    public void testCompareSecondNullMax() {
        DoubleColumnStatsDataInspector data1 = new DoubleColumnStatsDataInspector();
        DoubleColumnStatsDataInspector data2 = new DoubleColumnStatsDataInspector(DATA_1);
        Assert.assertEquals((double)1.0, (double)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)), (double)Double.MIN_VALUE);
    }

    static {
        DATA_1.setLowValue(1.0);
        DATA_1.setHighValue(1.0);
        DATA_2.setLowValue(2.0);
        DATA_2.setHighValue(2.0);
        DATA_3.setLowValue(3.0);
        DATA_3.setHighValue(3.0);
    }
}

