/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.utils.DecimalUtils;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class DecimalColumnStatsMergerTest {
    private static final Decimal DECIMAL_1 = DecimalUtils.getDecimal((int)1, (int)0);
    private static final Decimal DECIMAL_3 = DecimalUtils.getDecimal((int)3, (int)0);
    private static final Decimal DECIMAL_5 = DecimalUtils.getDecimal((int)5, (int)0);
    private static final Decimal DECIMAL_20 = DecimalUtils.getDecimal((int)2, (int)1);
    private static final DecimalColumnStatsDataInspector DATA_3 = new DecimalColumnStatsDataInspector();
    private static final DecimalColumnStatsDataInspector DATA_5 = new DecimalColumnStatsDataInspector();
    private static final DecimalColumnStatsDataInspector DATA_20 = new DecimalColumnStatsDataInspector();
    private final DecimalColumnStatsMerger merger = new DecimalColumnStatsMerger();

    @Test
    public void testMergeNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(null).high(null).numNulls(1L).numDVs(0L).build());
        this.merger.merge(aggrObj, aggrObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Decimal>(Decimal.class).low(null).high(null).numNulls(2L).numDVs(0L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNullWithNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(null).high(null).numNulls(0L).numDVs(0L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_3).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_3).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullWithNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_3).numNulls(4L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(null).high(null).numNulls(2L).numDVs(0L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_3).numNulls(6L).numDVs(2L).hll(1L, 3L, 3L).kll(1L, 3L, 3L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_1).numNulls(2L).numDVs(1L).hll(2L).kll(2L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_3).high(DECIMAL_3).numNulls(3L).numDVs(1L).hll(3L).kll(3L).build());
        this.merger.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_1).numNulls(1L).numDVs(1L).hll(1L, 1L).kll(1L, 1L).build());
        this.merger.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<Decimal>(Decimal.class).low(DECIMAL_1).high(DECIMAL_3).numNulls(6L).numDVs(3L).hll(2L, 3L, 1L, 1L).kll(2L, 3L, 1L, 1L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }

    @Test
    public void testDecimalCompareEqual() {
        Assert.assertTrue((boolean)DECIMAL_3.equals(DECIMAL_3));
    }

    @Test
    public void testDecimalCompareDoesntEqual() {
        Assert.assertFalse((boolean)DECIMAL_3.equals(DECIMAL_5));
    }

    @Test
    public void testCompareSimple() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_5);
        Assert.assertEquals((Object)DECIMAL_5, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleFlipped() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_5);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        Assert.assertEquals((Object)DECIMAL_5, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSimpleReversed() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_5);
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSimpleFlippedReversed() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_5);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareUnscaledValue() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_20);
        Assert.assertEquals((Object)DECIMAL_20, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareNullsMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareNullsMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        Assert.assertNull((Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareFirstNullMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareSecondNullMin() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeLowValue(this.merger.getLowValue(data1), this.merger.getLowValue(data2)));
    }

    @Test
    public void testCompareFirstNullMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector(DATA_3);
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector();
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    @Test
    public void testCompareSecondNullMax() {
        DecimalColumnStatsDataInspector data1 = new DecimalColumnStatsDataInspector();
        DecimalColumnStatsDataInspector data2 = new DecimalColumnStatsDataInspector(DATA_3);
        Assert.assertEquals((Object)DECIMAL_3, (Object)this.merger.mergeHighValue(this.merger.getHighValue(data1), this.merger.getHighValue(data2)));
    }

    static {
        DATA_3.setLowValue(DECIMAL_3);
        DATA_3.setHighValue(DECIMAL_3);
        DATA_5.setLowValue(DECIMAL_5);
        DATA_5.setHighValue(DECIMAL_5);
        DATA_20.setLowValue(DECIMAL_20);
        DATA_20.setHighValue(DECIMAL_20);
    }
}

