/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimatorFactory;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.merge.BinaryColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.BooleanColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DateColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DoubleColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.LongColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.StringColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.TimestampColumnStatsMerger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class ColumnStatsMergerTest {
    private static final ColumnStatsMerger<?> MERGER = new DateColumnStatsMerger();
    private static final List<ColumnStatsMerger<?>> MERGERS = Arrays.asList(new BinaryColumnStatsMerger(), new BooleanColumnStatsMerger(), new DateColumnStatsMerger(), new DecimalColumnStatsMerger(), new DoubleColumnStatsMerger(), new LongColumnStatsMerger(), new StringColumnStatsMerger(), new TimestampColumnStatsMerger());
    private static final long[] VALUES_1 = new long[]{1L, 2L};
    private static final long[] VALUES_2 = new long[]{1L, 3L};
    private static final HyperLogLog HLL_1 = StatisticsTestUtils.createHll(VALUES_1);
    private static final HyperLogLog HLL_2 = StatisticsTestUtils.createHll(VALUES_2);
    private static final KllFloatsSketch KLL_1 = StatisticsTestUtils.createKll(VALUES_1);
    private static final KllFloatsSketch KLL_2 = StatisticsTestUtils.createKll(VALUES_2);

    @Test
    public void testMergeNumDVs() {
        Assert.assertEquals((long)3L, (long)MERGER.mergeNumDVs(1L, 3L));
        Assert.assertEquals((long)3L, (long)MERGER.mergeNumDVs(3L, 1L));
    }

    @Test
    public void testMergeNumNulls() {
        Assert.assertEquals((long)4L, (long)MERGER.mergeNumNulls(1L, 3L));
        Assert.assertEquals((long)4L, (long)MERGER.mergeNumNulls(3L, 1L));
    }

    @Test
    public void testMergeMaxColLen() {
        Assert.assertEquals((long)3L, (long)MERGER.mergeMaxColLen(1L, 3L));
        Assert.assertEquals((long)3L, (long)MERGER.mergeMaxColLen(3L, 1L));
    }

    @Test
    public void testMergeAvgColLen() {
        Assert.assertEquals((double)3.0, (double)MERGER.mergeAvgColLen(1.0, 3.0), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)3.0, (double)MERGER.mergeAvgColLen(3.0, 1.0), (double)Double.MIN_VALUE);
    }

    @Test
    public void testMergeNonNullHistogramEstimators() {
        KllHistogramEstimator estimator1 = KllHistogramEstimatorFactory.getKllHistogramEstimator((byte[])KLL_1.toByteArray());
        KllHistogramEstimator estimator2 = KllHistogramEstimatorFactory.getKllHistogramEstimator((byte[])KLL_2.toByteArray());
        KllHistogramEstimator computedEstimator = MERGER.mergeHistogramEstimator("", estimator1, estimator2);
        KllFloatsSketch expectedKll = StatisticsTestUtils.createKll(Longs.concat((long[][])new long[][]{VALUES_1, VALUES_2}));
        KllHistogramEstimator expectedEstimator = KllHistogramEstimatorFactory.getKllHistogramEstimator((byte[])expectedKll.toByteArray());
        Assert.assertEquals((Object)expectedEstimator.getSketch().toString(), (Object)computedEstimator.getSketch().toString());
    }

    @Test
    public void testMergeHistogramEstimatorsFirstNull() {
        KllHistogramEstimator estimator2 = KllHistogramEstimatorFactory.getKllHistogramEstimator((byte[])KLL_2.toByteArray());
        KllHistogramEstimator computedEstimator = MERGER.mergeHistogramEstimator("", null, estimator2);
        Assert.assertEquals((Object)estimator2.getSketch().toString(), (Object)computedEstimator.getSketch().toString());
    }

    @Test
    public void testMergeHistogramEstimatorsSecondNull() {
        KllHistogramEstimator estimator1 = KllHistogramEstimatorFactory.getKllHistogramEstimator((byte[])KLL_1.toByteArray());
        KllHistogramEstimator computedEstimator = MERGER.mergeHistogramEstimator("", estimator1, null);
        Assert.assertEquals((Object)estimator1.getSketch().toString(), (Object)computedEstimator.getSketch().toString());
    }

    @Test
    public void testMergeNullHistogramEstimators() {
        Assert.assertNull((Object)MERGER.mergeHistogramEstimator("", null, null));
    }

    @Test
    public void testMergeNonNullNDVEstimators() {
        NumDistinctValueEstimator estimator1 = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])HLL_1.serialize());
        NumDistinctValueEstimator estimator2 = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])HLL_2.serialize());
        for (ColumnStatsMerger<?> MERGER : MERGERS) {
            long computedNDV = MERGER.mergeNumDistinctValueEstimator("", Arrays.asList(estimator1, estimator2), 2L, 2L);
            Assert.assertEquals((long)3L, (long)computedNDV);
        }
    }

    @Test
    public void testMergeNDVEstimatorsFirstNull() {
        NumDistinctValueEstimator estimator2 = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])HLL_2.serialize());
        for (ColumnStatsMerger<?> MERGER : MERGERS) {
            List<NumDistinctValueEstimator> estimatorList = Arrays.asList(null, estimator2);
            long computedNDV = MERGER.mergeNumDistinctValueEstimator("", estimatorList, 1L, 2L);
            Assert.assertEquals((Object)estimator2, (Object)estimatorList.get(0));
            Assert.assertEquals((long)2L, (long)computedNDV);
        }
    }

    @Test
    public void testMergeNDVEstimatorsSecondNull() {
        NumDistinctValueEstimator estimator1 = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])HLL_1.serialize());
        for (ColumnStatsMerger<?> MERGER : MERGERS) {
            List<NumDistinctValueEstimator> estimatorList = Arrays.asList(estimator1, null);
            long computedNDV = MERGER.mergeNumDistinctValueEstimator("", estimatorList, 2L, 1L);
            Assert.assertEquals(Arrays.asList(estimator1, null), estimatorList);
            Assert.assertEquals((long)2L, (long)computedNDV);
        }
    }

    @Test
    public void testMergeNullNDVEstimators() {
        List<NumDistinctValueEstimator> estimatorList = Arrays.asList(null, null);
        for (ColumnStatsMerger<?> MERGER : MERGERS) {
            long computedNDV = MERGER.mergeNumDistinctValueEstimator("", estimatorList, 1L, 2L);
            Assert.assertEquals((long)2L, (long)computedNDV);
            Assert.assertEquals(Arrays.asList(null, null), estimatorList);
        }
    }

    protected static ColumnStatisticsObj createColumnStatisticsObj(ColumnStatisticsData columnStatisticsData) {
        ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj();
        columnStatisticsObj.setStatsData(columnStatisticsData);
        return columnStatisticsObj;
    }
}

