/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.merge.BinaryColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class BinaryColumnStatsMergerTest {
    private static final BinaryColumnStatsMerger MERGER = new BinaryColumnStatsMerger();

    @Test
    public void testMergeNonNullValues() {
        ColumnStatisticsObj aggrObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<byte[]>(byte[].class).avgColLen(3.0).maxColLen(2L).numNulls(2L).build());
        ColumnStatisticsObj newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<byte[]>(byte[].class).avgColLen(2.0).maxColLen(3L).numNulls(3L).build());
        MERGER.merge(aggrObj, newObj);
        newObj = ColumnStatsMergerTest.createColumnStatisticsObj(new ColStatsBuilder<byte[]>(byte[].class).avgColLen(3.0).maxColLen(3L).numNulls(1L).build());
        MERGER.merge(aggrObj, newObj);
        ColumnStatisticsData expectedColumnStatisticsData = new ColStatsBuilder<byte[]>(byte[].class).avgColLen(3.0).maxColLen(3L).numNulls(6L).build();
        Assert.assertEquals((Object)expectedColumnStatisticsData, (Object)aggrObj.getStatsData());
    }
}

