/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.aggr.TimestampColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TimestampColumnStatsAggregatorTest {
    private static final Table TABLE = new Table("dummy", "db", "hive", 0, 0, 0, null, null, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
    private static final FieldSchema COL = new FieldSchema("col", "timestamp", "");
    private static final Timestamp TS_1 = new Timestamp(1L);
    private static final Timestamp TS_2 = new Timestamp(2L);
    private static final Timestamp TS_3 = new Timestamp(3L);
    private static final Timestamp TS_4 = new Timestamp(4L);
    private static final Timestamp TS_5 = new Timestamp(5L);
    private static final Timestamp TS_6 = new Timestamp(6L);
    private static final Timestamp TS_7 = new Timestamp(7L);
    private static final Timestamp TS_8 = new Timestamp(8L);
    private static final Timestamp TS_9 = new Timestamp(9L);

    @Test
    public void testAggregateSingleStat() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        long[] values = new long[]{TS_1.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(2L).low(TS_1).high(TS_3).hll(values).kll(values).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateSingleStatWhenNullValues() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(2L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultipleStatsWhenSomeNullValues() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2");
        long[] values1 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(2L).low(TS_1).high(TS_2).hll(values1).kll(values1).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(2L).numDVs(3L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(3L).low(TS_1).high(TS_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(4L).low(TS_1).high(TS_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(5L).low(TS_1).high(TS_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenAllAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(2L).low(TS_1).high(TS_3).hll(values1).kll(values1).build();
        long[] values2 = new long[]{TS_3.getSecondsSinceEpoch(), TS_4.getSecondsSinceEpoch(), TS_5.getSecondsSinceEpoch()};
        ColumnStatisticsData data2 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(2L).numDVs(3L).low(TS_3).high(TS_5).hll(values2).kll(values1).build();
        long[] values3 = new long[]{TS_6.getSecondsSinceEpoch(), TS_7.getSecondsSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(2L).low(TS_6).high(TS_7).hll(values3).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(7L).low(TS_1).high(TS_7).hll(values1).kll(Longs.concat((long[][])new long[][]{values1, values2, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenUnmergeableBitVectors() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(3L).low(TS_1).high(TS_3).fmSketch(values1).kll(values1).build();
        long[] values2 = new long[]{TS_3.getSecondsSinceEpoch(), TS_4.getSecondsSinceEpoch(), TS_5.getSecondsSinceEpoch()};
        ColumnStatisticsData data2 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(2L).numDVs(3L).low(TS_3).high(TS_5).hll(values2).kll(values2).build();
        long[] values3 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch(), TS_6.getSecondsSinceEpoch(), TS_8.getSecondsSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(4L).low(TS_1).high(TS_8).hll(values3).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(4L).low(TS_1).high(TS_8).fmSketch(values1).kll(Longs.concat((long[][])new long[][]{values1, values2, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(6L).low(TS_1).high(TS_8).fmSketch(values1).kll(Longs.concat((long[][])new long[][]{values1, values2, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        double[] tunerValues = new double[]{0.0, 0.5, 0.75, 1.0};
        long[] expectedDVs = new long[]{4L, 7L, 8L, 10L};
        for (int i = 0; i < tunerValues.length; ++i) {
            aggregator.ndvTuner = tunerValues[i];
            computedStatsObj = aggregator.aggregate(statsList, partitions, true);
            expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(expectedDVs[i]).low(TS_1).high(TS_8).fmSketch(values1).kll(Longs.concat((long[][])new long[][]{values1, values2, values3})).build();
            StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        }
    }

    @Test
    public void testAggregateMultiStatsWhenOnlySomeAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3", "part4");
        long[] values1 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch(), TS_3.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(3L).low(TS_1).high(TS_3).hll(values1).kll(values1).build();
        long[] values3 = new long[]{TS_7.getSecondsSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(1L).low(TS_7).high(TS_7).hll(values3).kll(values3).build();
        long[] values4 = new long[]{TS_3.getSecondsSinceEpoch(), TS_4.getSecondsSinceEpoch(), TS_5.getSecondsSinceEpoch()};
        ColumnStatisticsData data4 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(2L).numDVs(3L).low(TS_3).high(TS_5).hll(values4).kll(values4).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)), StatisticsTestUtils.createStatsWithInfo(data4, TABLE, COL, partitions.get(3)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(8L).numDVs(4L).low(TS_1).high(TS_9).kll(Longs.concat((long[][])new long[][]{values1, values3, values4})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsOnlySomeAvailableButUnmergeableBitVector() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{TS_1.getSecondsSinceEpoch(), TS_2.getSecondsSinceEpoch(), TS_6.getSecondsSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(1L).numDVs(3L).low(TS_1).high(TS_6).hll(values1).kll(values1).build();
        long[] values3 = new long[]{TS_7.getSecondsSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(3L).numDVs(1L).low(TS_7).high(TS_7).hll(values3).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        TimestampColumnStatsAggregator aggregator = new TimestampColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(3L).low(TS_1).high(TS_7).kll(Longs.concat((long[][])new long[][]{values1, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Timestamp>(Timestamp.class).numNulls(6L).numDVs(4L).low(TS_1).high(TS_7).kll(Longs.concat((long[][])new long[][]{values1, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }
}

