/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.aggr;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.columnstats.ColStatsBuilder;
import org.apache.hadoop.hive.metastore.columnstats.aggr.DateColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class DateColumnStatsAggregatorTest {
    private static final Table TABLE = new Table("dummy", "db", "hive", 0, 0, 0, null, null, Collections.emptyMap(), null, null, TableType.MANAGED_TABLE.toString());
    private static final FieldSchema COL = new FieldSchema("col", "date", "");
    private static final Date DATE_1 = new Date(1L);
    private static final Date DATE_2 = new Date(2L);
    private static final Date DATE_3 = new Date(3L);
    private static final Date DATE_4 = new Date(4L);
    private static final Date DATE_5 = new Date(5L);
    private static final Date DATE_6 = new Date(6L);
    private static final Date DATE_7 = new Date(7L);
    private static final Date DATE_8 = new Date(8L);
    private static final Date DATE_9 = new Date(9L);

    @Test
    public void testAggregateSingleStat() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        long[] values = new long[]{DATE_1.getDaysSinceEpoch(), DATE_4.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(2L).low(DATE_1).high(DATE_4).hll(values).kll(values).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateSingleStatWhenNullValues() throws MetaException {
        List<String> partitions = Collections.singletonList("part1");
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(2L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Collections.singletonList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        StatisticsTestUtils.assertEqualStatistics(data1, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultipleStatsWhenSomeNullValues() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2");
        long[] values1 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(2L).low(DATE_1).high(DATE_2).hll(values1).kll(values1).build();
        ColumnStatisticsData data2 = new ColStatsBuilder<Date>(Date.class).numNulls(2L).numDVs(3L).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(3L).low(DATE_1).high(DATE_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(4L).low(DATE_1).high(DATE_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        aggregator.ndvTuner = 1.0;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(5L).low(DATE_1).high(DATE_2).hll(values1).kll(values1).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenAllAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(3L).low(DATE_1).high(DATE_3).hll(values1).kll(values1).build();
        long[] values2 = new long[]{DATE_3.getDaysSinceEpoch(), DATE_4.getDaysSinceEpoch(), DATE_5.getDaysSinceEpoch()};
        ColumnStatisticsData data2 = new ColStatsBuilder<Date>(Date.class).numNulls(2L).numDVs(3L).low(DATE_3).high(DATE_5).hll(values2).kll(values2).build();
        long[] values3 = new long[]{DATE_6.getDaysSinceEpoch(), DATE_7.getDaysSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(2L).low(DATE_6).high(DATE_7).hll(values3).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(7L).low(DATE_1).high(DATE_7).hll(values1).kll(Longs.concat((long[][])new long[][]{values1, values2, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsWhenUnmergeableBitVectors() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(3L).low(DATE_1).high(DATE_3).fmSketch(values1).kll(values1).build();
        long[] values2 = new long[]{DATE_3.getDaysSinceEpoch(), DATE_4.getDaysSinceEpoch(), DATE_5.getDaysSinceEpoch()};
        ColumnStatisticsData data2 = new ColStatsBuilder<Date>(Date.class).numNulls(2L).numDVs(3L).low(DATE_3).high(DATE_5).hll(values2).kll(values2).build();
        long[] values3 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch(), DATE_6.getDaysSinceEpoch(), DATE_8.getDaysSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(4L).low(DATE_1).high(DATE_8).hll(values3).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data2, TABLE, COL, partitions.get(1)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        long[] values = Longs.concat((long[][])new long[][]{values1, values2, values3});
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(4L).low(DATE_1).high(DATE_8).fmSketch(values1).kll(values).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, true);
        expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(6L).low(DATE_1).high(DATE_8).fmSketch(values1).kll(values).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = false;
        double[] tunerValues = new double[]{0.0, 0.5, 0.75, 1.0};
        long[] expectedNDVs = new long[]{4L, 7L, 8L, 10L};
        for (int i = 0; i < tunerValues.length; ++i) {
            aggregator.ndvTuner = tunerValues[i];
            computedStatsObj = aggregator.aggregate(statsList, partitions, true);
            expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(expectedNDVs[i]).low(DATE_1).high(DATE_8).fmSketch(values1).kll(values).build();
            StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        }
    }

    @Test
    public void testAggregateMultiStatsWhenOnlySomeAvailable() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3", "part4");
        long[] values1 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch(), DATE_3.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(3L).low(DATE_1).high(DATE_3).hll(values1).kll(values1).build();
        long[] values3 = new long[]{DATE_7.getDaysSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(1L).low(DATE_7).high(DATE_7).hll(DATE_7.getDaysSinceEpoch()).kll(values3).build();
        long[] values4 = new long[]{DATE_3.getDaysSinceEpoch(), DATE_4.getDaysSinceEpoch(), DATE_5.getDaysSinceEpoch()};
        ColumnStatisticsData data4 = new ColStatsBuilder<Date>(Date.class).numNulls(2L).numDVs(3L).low(DATE_3).high(DATE_5).hll(values4).kll(values4).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)), StatisticsTestUtils.createStatsWithInfo(data4, TABLE, COL, partitions.get(3)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(8L).numDVs(4L).low(DATE_1).high(DATE_9).kll(Longs.concat((long[][])new long[][]{values1, values3, values4})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }

    @Test
    public void testAggregateMultiStatsOnlySomeAvailableButUnmergeableBitVector() throws MetaException {
        List<String> partitions = Arrays.asList("part1", "part2", "part3");
        long[] values1 = new long[]{DATE_1.getDaysSinceEpoch(), DATE_2.getDaysSinceEpoch(), DATE_6.getDaysSinceEpoch()};
        ColumnStatisticsData data1 = new ColStatsBuilder<Date>(Date.class).numNulls(1L).numDVs(3L).low(DATE_1).high(DATE_6).fmSketch(values1).kll(values1).build();
        long[] values3 = new long[]{DATE_7.getDaysSinceEpoch()};
        ColumnStatisticsData data3 = new ColStatsBuilder<Date>(Date.class).numNulls(3L).numDVs(1L).low(DATE_7).high(DATE_7).hll(DATE_7.getDaysSinceEpoch()).kll(values3).build();
        List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> statsList = Arrays.asList(StatisticsTestUtils.createStatsWithInfo(data1, TABLE, COL, partitions.get(0)), StatisticsTestUtils.createStatsWithInfo(data3, TABLE, COL, partitions.get(2)));
        DateColumnStatsAggregator aggregator = new DateColumnStatsAggregator();
        ColumnStatisticsObj computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        ColumnStatisticsData expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(3L).low(DATE_1).high(DATE_7).kll(Longs.concat((long[][])new long[][]{values1, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
        aggregator.useDensityFunctionForNDVEstimation = true;
        computedStatsObj = aggregator.aggregate(statsList, partitions, false);
        expectedStats = new ColStatsBuilder<Date>(Date.class).numNulls(6L).numDVs(4L).low(DATE_1).high(DATE_7).kll(Longs.concat((long[][])new long[][]{values1, values3})).build();
        StatisticsTestUtils.assertEqualStatistics(expectedStats, computedStatsObj.getStatsData());
    }
}

