/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats;

import java.lang.reflect.InvocationTargetException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Timestamp;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;

public class ColStatsBuilder<T> {
    private final Class<T> type;
    private T lowValue;
    private T highValue;
    private Double avgColLen;
    private Long maxColLen;
    private Long numTrues;
    private Long numFalses;
    private Long numNulls;
    private Long numDVs;
    private byte[] bitVector;
    private byte[] kll;

    public ColStatsBuilder(Class<T> type) {
        this.type = type;
    }

    public ColStatsBuilder<T> numNulls(long num) {
        this.numNulls = num;
        return this;
    }

    public ColStatsBuilder<T> numDVs(long num) {
        this.numDVs = num;
        return this;
    }

    public ColStatsBuilder<T> numFalses(long num) {
        this.numFalses = num;
        return this;
    }

    public ColStatsBuilder<T> numTrues(long num) {
        this.numTrues = num;
        return this;
    }

    public ColStatsBuilder<T> avgColLen(double val) {
        this.avgColLen = val;
        return this;
    }

    public ColStatsBuilder<T> maxColLen(long val) {
        this.maxColLen = val;
        return this;
    }

    public ColStatsBuilder<T> low(T val) {
        this.lowValue = val;
        return this;
    }

    public ColStatsBuilder<T> high(T val) {
        this.highValue = val;
        return this;
    }

    public ColStatsBuilder<T> hll(long ... values) {
        HyperLogLog hll = StatisticsTestUtils.createHll(values);
        this.bitVector = hll.serialize();
        return this;
    }

    public ColStatsBuilder<T> hll(String ... values) {
        HyperLogLog hll = StatisticsTestUtils.createHll(values);
        this.bitVector = hll.serialize();
        return this;
    }

    public ColStatsBuilder<T> hll(double ... values) {
        HyperLogLog hll = StatisticsTestUtils.createHll(values);
        this.bitVector = hll.serialize();
        return this;
    }

    public ColStatsBuilder<T> fmSketch(long ... values) {
        FMSketch fm = StatisticsTestUtils.createFMSketch(values);
        this.bitVector = fm.serialize();
        return this;
    }

    public ColStatsBuilder<T> fmSketch(String ... values) {
        FMSketch fm = StatisticsTestUtils.createFMSketch(values);
        this.bitVector = fm.serialize();
        return this;
    }

    public ColStatsBuilder<T> kll(long ... values) {
        KllFloatsSketch kll = StatisticsTestUtils.createKll(values);
        this.kll = kll.toByteArray();
        return this;
    }

    public ColStatsBuilder<T> kll(double ... values) {
        KllFloatsSketch kll = StatisticsTestUtils.createKll(values);
        this.kll = kll.toByteArray();
        return this;
    }

    public ColumnStatisticsData build() {
        ColumnStatisticsData data = new ColumnStatisticsData();
        if (this.type == byte[].class) {
            data.setBinaryStats(this.newColData(BinaryColumnStatsData.class));
        } else if (this.type == Boolean.class) {
            data.setBooleanStats(this.newColData(BooleanColumnStatsData.class));
        } else if (this.type == Date.class) {
            data.setDateStats((DateColumnStatsData)this.newColData(DateColumnStatsDataInspector.class));
        } else if (this.type == Decimal.class) {
            data.setDecimalStats((DecimalColumnStatsData)this.newColData(DecimalColumnStatsDataInspector.class));
        } else if (this.type == Double.TYPE) {
            data.setDoubleStats((DoubleColumnStatsData)this.newColData(DoubleColumnStatsDataInspector.class));
        } else if (this.type == Long.TYPE) {
            data.setLongStats((LongColumnStatsData)this.newColData(LongColumnStatsDataInspector.class));
        } else if (this.type == String.class) {
            data.setStringStats((StringColumnStatsData)this.newColData(StringColumnStatsDataInspector.class));
        } else if (this.type == Timestamp.class) {
            data.setTimestampStats((TimestampColumnStatsData)this.newColData(TimestampColumnStatsDataInspector.class));
        } else {
            throw new IllegalStateException(this.type.getSimpleName() + " is not supported");
        }
        return data;
    }

    private <X> X newColData(Class<X> clazz) {
        try {
            X data = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.numNulls != null) {
                clazz.getMethod("setNumNulls", Long.TYPE).invoke(data, this.numNulls);
            }
            if (this.numDVs != null) {
                clazz.getMethod("setNumDVs", Long.TYPE).invoke(data, this.numDVs);
            }
            if (this.bitVector != null) {
                clazz.getMethod("setBitVectors", byte[].class).invoke(data, new Object[]{this.bitVector});
            }
            if (this.kll != null) {
                clazz.getMethod("setHistogram", byte[].class).invoke(data, new Object[]{this.kll});
            }
            if (this.avgColLen != null) {
                clazz.getMethod("setAvgColLen", Double.TYPE).invoke(data, this.avgColLen);
            }
            if (this.maxColLen != null) {
                clazz.getMethod("setMaxColLen", Long.TYPE).invoke(data, this.maxColLen);
            }
            if (this.numFalses != null) {
                clazz.getMethod("setNumFalses", Long.TYPE).invoke(data, this.numFalses);
            }
            if (this.numTrues != null) {
                clazz.getMethod("setNumTrues", Long.TYPE).invoke(data, this.numTrues);
            }
            if (this.lowValue != null) {
                if (this.type.isPrimitive()) {
                    clazz.getMethod("setLowValue", this.type).invoke(data, this.lowValue);
                } else {
                    clazz.getMethod("setLowValue", this.type).invoke(data, this.type.cast(this.lowValue));
                }
            }
            if (this.highValue != null) {
                if (this.type.isPrimitive()) {
                    clazz.getMethod("setHighValue", this.type).invoke(data, this.highValue);
                } else {
                    clazz.getMethod("setHighValue", this.type).invoke(data, this.type.cast(this.highValue));
                }
            }
            clazz.getMethod("validate", new Class[0]).invoke(data, new Object[0]);
            return data;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Reflection error", e);
        }
    }
}

