/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLNotNullConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestNotNullConstraint
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_uc_other_database";
    private static final String OTHER_CATALOG = "test_uc_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_uc_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[3];
    private Database inOtherCatalog;

    public TestNotNullConstraint(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.inOtherCatalog = new DatabaseBuilder().setName(DATABASE_IN_OTHER_CATALOG).setCatalogName(OTHER_CATALOG).create(this.client, this.metaStore.getConf());
        this.testTables[0] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_3").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void createGetDrop() throws TException {
        Table table = this.testTables[0];
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addNotNullConstraint(nn);
        rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        ((SQLNotNullConstraint)nn.get(0)).setNn_name(((SQLNotNullConstraint)fetched.get(0)).getNn_name());
        Assert.assertEquals((Object)nn, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLNotNullConstraint)nn.get(0)).getNn_name());
        rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addNotNullConstraint(nn);
    }

    @Test
    public void inOtherCatalog() throws TException {
        String constraintName = "ocuc";
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(this.testTables[2])).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.addNotNullConstraint(nn);
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertEquals((Object)nn, (Object)fetched);
        this.client.dropConstraint(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new NotNullConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPk() throws TException {
        String constraintName = "ctwcuc";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, null, nn, null, null);
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertEquals((Object)nn, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPkInOtherCatalog() throws TException {
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_in_other_catalog_with_constraints").inDb(this.inOtherCatalog).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, null, nn, null, null);
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        ((SQLNotNullConstraint)nn.get(0)).setNn_name(((SQLNotNullConstraint)fetched.get(0)).getNn_name());
        Assert.assertEquals((Object)nn, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLNotNullConstraint)nn.get(0)).getNn_name());
        rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void doubleAddNotNullConstraint() throws TException {
        Table table = this.testTables[0];
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addNotNullConstraint(nn);
        try {
            nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().onTable(table)).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addNotNullConstraint(nn);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void addNoSuchTable() throws TException {
        try {
            List nn = ((SQLNotNullConstraintBuilder)((SQLNotNullConstraintBuilder)new SQLNotNullConstraintBuilder().setTableName("nosuch")).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addNotNullConstraint(nn);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void getNoSuchTable() throws TException {
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest("hive", "default", "nosuch");
        List nn = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)nn.isEmpty());
    }

    @Test
    public void getNoSuchDb() throws TException {
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest("hive", "nosuch", this.testTables[0].getTableName());
        List nn = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)nn.isEmpty());
    }

    @Test
    public void getNoSuchCatalog() throws TException {
        NotNullConstraintsRequest rqst = new NotNullConstraintsRequest("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName());
        List nn = this.client.getNotNullConstraints(rqst);
        Assert.assertTrue((boolean)nn.isEmpty());
    }
}

