/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.ObjectStoreTestHook;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.QueryState;
import org.apache.hadoop.hive.metastore.api.ScheduledQuery;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryMaintenanceRequestType;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.model.MScheduledExecution;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreUnitTest.class})
public class TestMetastoreScheduledQueries
extends MetaStoreClientTest {
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    public TestMetastoreScheduledQueries(String name, AbstractMetaStoreService metaStore) throws Exception {
        metaStore.getConf().set("scheduled.queries.progress.timeout", "3");
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_AUTODISABLE_COUNT.getVarname(), "-1");
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_SKIP_OPPORTUNITIES_AFTER_FAILURES.getVarname(), "0");
        this.client = this.metaStore.getClient();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.client = null;
    }

    @Test(expected=NoSuchObjectException.class)
    public void testNonExistent() throws Exception {
        this.client.getScheduledQuery(new ScheduledQueryKey("nonExistent", "x"));
    }

    @Test
    public void testCreate() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("create", "c1"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        ScheduledQuery schq2 = this.client.getScheduledQuery(new ScheduledQueryKey("create", "c1"));
        schq.setNextExecution(schq2.getNextExecution());
        Assert.assertEquals((Object)schq2, (Object)schq);
    }

    @Test(expected=InvalidInputException.class)
    public void testCreateWithInvalidSchedule() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("createInvalidSch", "c1"));
        schq.setSchedule("asd asd");
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test(expected=AlreadyExistsException.class)
    public void testDuplicateCreate() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("duplicate", "c1"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test
    public void testUpdate() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("update", "ns1"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        r.setType(ScheduledQueryMaintenanceRequestType.ALTER);
        ScheduledQuery schq2 = this.createScheduledQuery2(this.createKey("update", "ns1"));
        schq2.getScheduleKey().setClusterNamespace("ns1");
        r.setScheduledQuery(schq2);
        this.client.scheduledQueryMaintenance(r);
        ScheduledQuery schq3 = this.client.getScheduledQuery(new ScheduledQueryKey("update", "ns1"));
        schq2.setNextExecution(schq3.getNextExecution());
        Assert.assertEquals((Object)schq2, (Object)schq3);
    }

    @Test
    public void testNormalDelete() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("q1", "nsdel"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        r.setType(ScheduledQueryMaintenanceRequestType.DROP);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test
    public void testNormalDeleteWithExec() throws Exception {
        String testCaseNS = "delwithexec";
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("del2", testCaseNS));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        Thread.sleep(2000L);
        ScheduledQueryPollRequest pollRequest = new ScheduledQueryPollRequest(testCaseNS);
        this.client.scheduledQueryPoll(pollRequest);
        r.setType(ScheduledQueryMaintenanceRequestType.DROP);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testDeleteNonExistent() throws Exception {
        ScheduledQuery schq = this.createScheduledQuery(this.createKey("nonexistent", "nsdel"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.DROP);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test
    public void testDeleteWithOpenTxn() throws Exception {
        Statement stmt;
        if (!Objects.equals(this.client.getConfigValue(String.valueOf(MetastoreConf.ConfVars.THRIFT_URIS), ""), "")) {
            System.out.println("It is not possible to create open transaction from here in Remote mode. So, skipping the test case");
            return;
        }
        String testCaseNS = "delwithopentxn";
        String replPolicy = "db100";
        ScheduledQuery schq = this.createScheduledQuery3(this.createKey(replPolicy, testCaseNS));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        Thread.sleep(2000L);
        ScheduledQueryPollRequest pollRequest = new ScheduledQueryPollRequest(testCaseNS);
        this.client.scheduledQueryPoll(pollRequest);
        Configuration conf = this.metaStore.getConf();
        TestTxnDbUtil.cleanDb(conf);
        TestTxnDbUtil.setConfValues(conf);
        TestTxnDbUtil.prepDb(conf);
        Object query = "select \"DB_ID\" from \"DBS\" where \"NAME\" = 'default' and \"CTLG_NAME\" = 'hive'";
        String[] output = TestTxnDbUtil.queryToString(conf, (String)query).split("\n");
        if (output.length == 1) {
            query = "INSERT INTO \"DBS\"(\"DB_ID\", \"NAME\", \"CTLG_NAME\", \"DB_LOCATION_URI\")  VALUES (1, 'default','hive','dummy')";
            stmt = TestTxnDbUtil.getConnection(conf).createStatement();
            try {
                stmt.executeUpdate((String)query);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        query = "INSERT INTO \"DBS\"(\"DB_ID\", \"NAME\", \"CTLG_NAME\", \"DB_LOCATION_URI\")  VALUES (2, '" + replPolicy + "','hive','dummy')";
        stmt = TestTxnDbUtil.getConnection(conf).createStatement();
        try {
            stmt.executeUpdate((String)query);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        ArrayList<Long> openTxnIds = new ArrayList<Long>(Arrays.asList(1L, 2L));
        this.client.replOpenTxn(replPolicy + ".*", openTxnIds, "hive", TxnType.REPL_CREATED);
        String[] replTxnMapOutput = TestTxnDbUtil.queryToString(conf, "SELECT \"RTM_SRC_TXN_ID\" FROM \"REPL_TXN_MAP\"").split("\n");
        Assert.assertEquals((long)3L, (long)replTxnMapOutput.length);
        r.setType(ScheduledQueryMaintenanceRequestType.DROP);
        this.client.scheduledQueryMaintenance(r);
        replTxnMapOutput = TestTxnDbUtil.queryToString(conf, "SELECT \"RTM_SRC_TXN_ID\" FROM \"REPL_TXN_MAP\"").split("\n");
        Assert.assertEquals((long)1L, (long)replTxnMapOutput.length);
        TestTxnDbUtil.cleanDb(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExclusivePoll() throws Exception {
        try {
            ObjectStoreTestHook.instance = new ObjectStoreTestHook(){

                public void scheduledQueryPoll() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            ScheduledQuery schq = this.createScheduledQuery(new ScheduledQueryKey("q1", "exclusive"));
            ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
            r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
            r.setScheduledQuery(schq);
            this.client.scheduledQueryMaintenance(r);
            Thread.sleep(1000L);
            ExecutorService pool = Executors.newCachedThreadPool();
            Future<ScheduledQueryPollResponse> f1 = pool.submit(new AsyncPollCall("exclusive"));
            Future<ScheduledQueryPollResponse> f2 = pool.submit(new AsyncPollCall("exclusive"));
            ScheduledQueryPollResponse resp1 = f1.get();
            ScheduledQueryPollResponse resp2 = f2.get();
            Assert.assertTrue((boolean)(resp1.isSetQuery() ^ resp2.isSetQuery()));
            pool.shutdown();
        }
        finally {
            ObjectStoreTestHook.instance = null;
        }
    }

    @Test
    public void testDisable1() throws Exception {
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_AUTODISABLE_COUNT.getVarname(), "1");
        this.client.close();
        this.client = this.metaStore.getClient();
        this.testDisableInternal(2, 5, "dis1");
    }

    @Test
    public void testDisable2() throws Exception {
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_AUTODISABLE_COUNT.getVarname(), "2");
        this.client.close();
        this.client = this.metaStore.getClient();
        this.testDisableInternal(3, 5, "dis2");
    }

    @Test
    public void testSkip2() throws Exception {
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_AUTODISABLE_COUNT.getVarname(), "4");
        this.metaStore.getConf().set(MetastoreConf.ConfVars.SCHEDULED_QUERIES_SKIP_OPPORTUNITIES_AFTER_FAILURES.getVarname(), "2");
        this.client.close();
        this.client = this.metaStore.getClient();
        this.testDisableInternal(5, 6, "skip2");
        try (PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();){
            ScheduledQueryKey key = new ScheduledQueryKey("q1", "skip2");
            Query query = pm.newQuery(MScheduledExecution.class);
            query.setOrdering("scheduledExecutionId descending");
            query.setRange(0L, 20L);
            List list = (List)query.execute();
            ArrayList<MScheduledExecution> q1list = new ArrayList<MScheduledExecution>();
            List<Object> tList = new ArrayList();
            for (MScheduledExecution schqExec : list) {
                if (!schqExec.getScheduledQuery().getScheduleKey().equals(key)) continue;
                q1list.add(schqExec);
                tList.add(schqExec.getStartTime());
            }
            tList = Lists.reverse(tList);
            Integer startTime = (Integer)tList.get(0);
            tList = tList.stream().map(e -> e - startTime).collect(Collectors.toList());
            Assert.assertArrayEquals((Object[])new Integer[]{0, 1, 2, 4, 6, 6}, (Object[])tList.toArray());
        }
    }

    public void testDisableInternal(int q1NumberOfExecutions, int seconds, String testNamespace) throws Exception {
        int q2NumberOfExecutions = seconds - 1;
        ScheduledQueryKey schqKey1 = new ScheduledQueryKey("q1", testNamespace);
        ScheduledQueryKey schqKey2 = new ScheduledQueryKey("q2", testNamespace);
        this.createEverySecondSchq(schqKey1);
        this.createEverySecondSchq(schqKey2);
        ScheduledQueryPollRequest request = new ScheduledQueryPollRequest();
        request.setClusterNamespace(testNamespace);
        ScheduledQueryPollResponse pollResult = null;
        int idx1 = 0;
        int idx2 = 0;
        for (int i = 0; i < seconds * 10 + 9; ++i) {
            pollResult = this.client.scheduledQueryPoll(request);
            if (pollResult.isSetQuery()) {
                ScheduledQueryProgressInfo info;
                if (pollResult.getScheduleKey().equals(schqKey1)) {
                    if (++idx1 == 1) {
                        info = new ScheduledQueryProgressInfo(pollResult.getExecutionId(), QueryState.FINISHED, "executor-query-id");
                        this.client.scheduledQueryProgress(info);
                    } else {
                        info = new ScheduledQueryProgressInfo(pollResult.getExecutionId(), QueryState.FAILED, "executor-query-id");
                        info.setErrorMessage("some issue happened");
                        this.client.scheduledQueryProgress(info);
                    }
                    ScheduledQuery schq = this.client.getScheduledQuery(pollResult.getScheduleKey());
                    if (idx1 > q1NumberOfExecutions) {
                        Assert.fail((String)"unexpected execution of q1 happened");
                    }
                    if (idx1 == q1NumberOfExecutions) {
                        Assert.assertFalse((String)"Scheduled query q1 must be disabled at this point", (boolean)schq.isEnabled());
                    } else {
                        Assert.assertTrue((String)"Scheduled query q1 must be enabled at this point", (boolean)schq.isEnabled());
                    }
                }
                if (pollResult.getScheduleKey().equals(schqKey2)) {
                    ++idx2;
                    info = new ScheduledQueryProgressInfo(pollResult.getExecutionId(), QueryState.FINISHED, "executor-query-id");
                    this.client.scheduledQueryProgress(info);
                    ScheduledQuery schq = this.client.getScheduledQuery(pollResult.getScheduleKey());
                    Assert.assertTrue((String)"Scheduled query q2 must be enabled", (boolean)schq.isEnabled());
                }
            }
            Thread.sleep(100L);
        }
        if (idx1 != q1NumberOfExecutions) {
            Assert.fail((String)("expected " + q1NumberOfExecutions + " execution of q1; only " + idx1 + " happened"));
        }
        if (idx2 < q2NumberOfExecutions) {
            Assert.fail((String)("at least " + q2NumberOfExecutions + " expected for q2"));
        }
    }

    private void createEverySecondSchq(ScheduledQueryKey schqKey) throws MetaException, TException {
        ScheduledQuery schq = this.createScheduledQuery(schqKey);
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
    }

    @Test
    public void testPoll() throws Exception {
        MScheduledExecution q;
        ScheduledQuery schq = this.createScheduledQuery(new ScheduledQueryKey("q1", "polltest"));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        this.client.scheduledQueryMaintenance(r);
        schq.setScheduleKey(new ScheduledQueryKey("q1", "polltestOther"));
        this.client.scheduledQueryMaintenance(r);
        schq.setScheduleKey(new ScheduledQueryKey("q2disabled", "polltest"));
        schq.setEnabled(false);
        this.client.scheduledQueryMaintenance(r);
        ScheduledQueryPollRequest request = new ScheduledQueryPollRequest();
        request.setClusterNamespace("polltest");
        ScheduledQueryPollResponse pollResult = null;
        for (int i = 0; i < 30 && !(pollResult = this.client.scheduledQueryPoll(request)).isSetQuery(); ++i) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)pollResult.isSetQuery());
        Assert.assertTrue((boolean)pollResult.isSetScheduleKey());
        Assert.assertTrue((boolean)pollResult.isSetExecutionId());
        ScheduledQueryPollResponse pollResult2 = this.client.scheduledQueryPoll(request);
        Assert.assertTrue((!pollResult2.isSetQuery() ? 1 : 0) != 0);
        try (PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();){
            MScheduledExecution q2 = (MScheduledExecution)pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
            Assert.assertNotNull((Object)q2);
            Assert.assertEquals((Object)QueryState.INITED, (Object)q2.getState());
            Assert.assertTrue((q2.getStartTime() <= this.getEpochSeconds() ? 1 : 0) != 0);
            Assert.assertTrue((q2.getStartTime() >= this.getEpochSeconds() - 1 ? 1 : 0) != 0);
            Assert.assertTrue((q2.getEndTime() == null ? 1 : 0) != 0);
            Assert.assertTrue((q2.getLastUpdateTime() <= this.getEpochSeconds() ? 1 : 0) != 0);
            Assert.assertTrue((q2.getLastUpdateTime() >= this.getEpochSeconds() - 1 ? 1 : 0) != 0);
        }
        Thread.sleep(1000L);
        ScheduledQueryProgressInfo info = new ScheduledQueryProgressInfo(pollResult.getExecutionId(), QueryState.EXECUTING, "executor-query-id");
        this.client.scheduledQueryProgress(info);
        try (PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();){
            q = (MScheduledExecution)pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
            Assert.assertEquals((Object)QueryState.EXECUTING, (Object)q.getState());
            Assert.assertEquals((Object)"executor-query-id", (Object)q.getExecutorQueryId());
            Assert.assertTrue((q.getLastUpdateTime() <= this.getEpochSeconds() ? 1 : 0) != 0);
            Assert.assertTrue((q.getLastUpdateTime() >= this.getEpochSeconds() - 1 ? 1 : 0) != 0);
        }
        Thread.sleep(1000L);
        info = new ScheduledQueryProgressInfo(pollResult.getExecutionId(), QueryState.FAILED, "executor-query-id");
        info.setErrorMessage(this.generateLongErrorMessage());
        this.client.scheduledQueryProgress(info);
        pm = PersistenceManagerProvider.getPersistenceManager();
        try {
            q = (MScheduledExecution)pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
            Assert.assertEquals((Object)QueryState.FAILED, (Object)q.getState());
            Assert.assertEquals((Object)"executor-query-id", (Object)q.getExecutorQueryId());
            Assert.assertNull((Object)q.getLastUpdateTime());
            Assert.assertTrue((q.getEndTime() <= this.getEpochSeconds() ? 1 : 0) != 0);
            Assert.assertTrue((q.getEndTime() >= this.getEpochSeconds() - 1 ? 1 : 0) != 0);
            Assert.assertTrue((q.getErrorMessage().length() < 2000 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)q.getErrorMessage().contains("x"));
        }
        finally {
            if (pm != null) {
                pm.close();
            }
        }
        request.setClusterNamespace("polltestSomethingElse");
        pollResult = this.client.scheduledQueryPoll(request);
        Assert.assertFalse((boolean)pollResult.isSetQuery());
    }

    private String generateLongErrorMessage() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2500; ++i) {
            sb.append("e");
        }
        for (int j = 0; j < 10; ++j) {
            sb.append("\nx");
        }
        return sb.toString();
    }

    @Test
    public void testCleanup() throws Exception {
        String namespace = "cleanup";
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteScheduledExecutions(0);
        ScheduledQuery schq = this.createScheduledQuery(new ScheduledQueryKey("q1", namespace));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        objStore.scheduledQueryMaintenance(r);
        Thread.sleep(1000L);
        ScheduledQueryPollRequest request = new ScheduledQueryPollRequest(namespace);
        ScheduledQueryPollResponse pollResult = objStore.scheduledQueryPoll(request);
        try (PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();){
            MScheduledExecution q = (MScheduledExecution)pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
            Assert.assertEquals((Object)QueryState.INITED, (Object)q.getState());
        }
        Thread.sleep(1000L);
        objStore.deleteScheduledExecutions(0);
        pm = PersistenceManagerProvider.getPersistenceManager();
        try {
            try {
                pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
                Assert.fail((String)"The execution is expected to be deleted at this point...");
            }
            catch (JDOObjectNotFoundException jDOObjectNotFoundException) {
                // empty catch block
            }
        }
        finally {
            if (pm != null) {
                pm.close();
            }
        }
    }

    @Test
    public void testOutdatedCleanup() throws Exception {
        String namespace = "outdatedcleanup";
        ObjectStore objStore = new ObjectStore();
        objStore.setConf(this.metaStore.getConf());
        objStore.deleteScheduledExecutions(0);
        ScheduledQuery schq = this.createScheduledQuery(new ScheduledQueryKey("q1", namespace));
        ScheduledQueryMaintenanceRequest r = new ScheduledQueryMaintenanceRequest();
        r.setType(ScheduledQueryMaintenanceRequestType.CREATE);
        r.setScheduledQuery(schq);
        objStore.scheduledQueryMaintenance(r);
        Thread.sleep(1000L);
        ScheduledQueryPollRequest request = new ScheduledQueryPollRequest(namespace);
        ScheduledQueryPollResponse pollResult = objStore.scheduledQueryPoll(request);
        Thread.sleep(1000L);
        objStore.markScheduledExecutionsTimedOut(0);
        try (PersistenceManager pm = PersistenceManagerProvider.getPersistenceManager();){
            MScheduledExecution execution = (MScheduledExecution)pm.getObjectById(MScheduledExecution.class, (Object)pollResult.getExecutionId());
            Assert.assertEquals((Object)QueryState.TIMED_OUT, (Object)execution.getState());
        }
    }

    @Test
    public void testDisabledMaintenance() throws MetaException, TException {
        try {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)false);
            ObjectStore objStore = new ObjectStore();
            objStore.setConf(this.metaStore.getConf());
            this.thrown.expect(MetaException.class);
            this.thrown.expectMessage(ArgumentMatchers.contains((String)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED.getVarname()));
            objStore.scheduledQueryMaintenance(new ScheduledQueryMaintenanceRequest());
        }
        finally {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)true);
        }
    }

    @Test
    public void testDisabledPoll() throws MetaException, TException {
        try {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)false);
            ObjectStore objStore = new ObjectStore();
            objStore.setConf(this.metaStore.getConf());
            this.thrown.expect(MetaException.class);
            this.thrown.expectMessage(ArgumentMatchers.contains((String)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED.getVarname()));
            objStore.scheduledQueryPoll(new ScheduledQueryPollRequest());
        }
        finally {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)true);
        }
    }

    @Test
    public void testDisabledProgress() throws MetaException, TException {
        try {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)false);
            ObjectStore objStore = new ObjectStore();
            objStore.setConf(this.metaStore.getConf());
            this.thrown.expect(MetaException.class);
            this.thrown.expectMessage(ArgumentMatchers.contains((String)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED.getVarname()));
            objStore.scheduledQueryProgress(new ScheduledQueryProgressInfo());
        }
        finally {
            MetastoreConf.setBoolVar((Configuration)this.metaStore.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SCHEDULED_QUERIES_ENABLED, (boolean)true);
        }
    }

    private int getEpochSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    private ScheduledQuery createScheduledQuery(ScheduledQueryKey key) {
        ScheduledQuery schq = new ScheduledQuery();
        schq.setScheduleKey(key);
        schq.setEnabled(true);
        schq.setSchedule("* * * * * ? *");
        schq.setUser("user");
        schq.setQuery("select 1");
        return schq;
    }

    private ScheduledQueryKey createKey(String name, String string) {
        ScheduledQueryKey ret = new ScheduledQueryKey();
        ret.setScheduleName(name);
        ret.setClusterNamespace(string);
        return ret;
    }

    private ScheduledQuery createScheduledQuery2(ScheduledQueryKey key) {
        ScheduledQuery schq = new ScheduledQuery();
        schq.setScheduleKey(key);
        schq.setEnabled(true);
        schq.setSchedule("* * * 22 * ? *");
        schq.setUser("user22");
        schq.setQuery("select 12");
        return schq;
    }

    private ScheduledQuery createScheduledQuery3(ScheduledQueryKey key) {
        ScheduledQuery schq = new ScheduledQuery();
        schq.setScheduleKey(key);
        schq.setEnabled(true);
        schq.setSchedule("* * * * * ? *");
        schq.setUser("user");
        schq.setQuery("REPL LOAD db100 INTO db100");
        return schq;
    }

    class AsyncPollCall
    implements Callable<ScheduledQueryPollResponse> {
        private String ns;

        AsyncPollCall(String string) {
            this.ns = string;
        }

        @Override
        public ScheduledQueryPollResponse call() throws Exception {
            try (HiveMetaStoreClient client1 = null;){
                client1 = TestMetastoreScheduledQueries.this.metaStore.getClient();
                ScheduledQueryPollRequest request = new ScheduledQueryPollRequest();
                request.setClusterNamespace(this.ns);
                ScheduledQueryPollResponse pollResult = null;
                ScheduledQueryPollResponse scheduledQueryPollResponse = pollResult = client1.scheduledQueryPoll(request);
                return scheduledQueryPollResponse;
            }
        }
    }
}

