/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLForeignKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLPrimaryKeyBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestForeignKey
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_fk_other_database";
    private static final String OTHER_CATALOG = "test_fk_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_fk_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[4];
    private Database inOtherCatalog;

    public TestForeignKey(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.inOtherCatalog = new DatabaseBuilder().setName(DATABASE_IN_OTHER_CATALOG).setCatalogName(OTHER_CATALOG).create(this.client, this.metaStore.getConf());
        this.testTables[0] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_3").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[3] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_4").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void createGetDrop() throws TException {
        Table parentTable = this.testTables[1];
        Table table = this.testTables[0];
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addForeignKey(fk);
        rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getForeignKeys(rqst);
        ((SQLForeignKey)fk.get(0)).setFk_name(((SQLForeignKey)fetched.get(0)).getFk_name());
        Assert.assertEquals((Object)fk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLForeignKey)fk.get(0)).getFk_name());
        rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getForeignKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addForeignKey(fk);
    }

    @Test
    public void createGetDrop2Column() throws TException {
        Table parentTable = this.testTables[1];
        Table table = this.testTables[0];
        String constraintName = "2colfk";
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).addColumn("col2")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).addColumn("col2")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.addForeignKey(fk);
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        Assert.assertEquals((Object)fk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getForeignKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addForeignKey(fk);
    }

    @Test
    public void inOtherCatalog() throws TException {
        Table parentTable = this.testTables[2];
        Table table = this.testTables[3];
        String constraintName = "othercatfk";
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.addForeignKey(fk);
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        ((SQLForeignKey)fk.get(0)).setFk_name(((SQLForeignKey)fetched.get(0)).getFk_name());
        Assert.assertEquals((Object)fk, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        fetched = this.client.getForeignKeys(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addForeignKey(fk);
    }

    @Test
    public void createTableWithConstraints() throws TException {
        String constraintName = "ctwckk";
        Table parentTable = this.testTables[0];
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").setDbName(parentTable.getDbName()).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, fk, null, null, null, null);
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        Assert.assertEquals((Object)fk, (Object)fetched);
    }

    @Test
    public void createTableWithConstraintsInOtherCatalog() throws TException {
        String constraintName = "ctwcocfk";
        Table parentTable = this.testTables[2];
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").inDb(this.inOtherCatalog).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).setConstraintName(constraintName)).build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, fk, null, null, null, null);
        ForeignKeysRequest rqst = new ForeignKeysRequest(parentTable.getDbName(), parentTable.getTableName(), table.getDbName(), table.getTableName());
        rqst.setCatName(table.getCatName());
        List fetched = this.client.getForeignKeys(rqst);
        Assert.assertEquals((Object)fk, (Object)fetched);
    }

    @Test(expected=MetaException.class)
    public void noSuchPk() throws TException {
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(this.testTables[1])).addColumn("col1")).build(this.metaStore.getConf());
        List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().onTable(this.testTables[0])).fromPrimaryKey(pk).addColumn("col2")).build(this.metaStore.getConf());
        this.client.addForeignKey(fk);
        Assert.fail();
    }

    @Test
    public void addNoSuchTable() throws TException {
        Table parentTable = this.testTables[0];
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        try {
            List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().setTableName("nosuch")).fromPrimaryKey(pk).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addForeignKey(fk);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void addNoSuchDb() throws TException {
        Table parentTable = this.testTables[0];
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        try {
            List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().setTableName(this.testTables[0].getTableName())).setDbName("nosuch")).fromPrimaryKey(pk).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addForeignKey(fk);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void addNoSuchCatalog() throws TException {
        Table parentTable = this.testTables[0];
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        try {
            List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().setTableName(this.testTables[0].getTableName())).setDbName(this.testTables[0].getDbName())).setCatName("nosuch")).fromPrimaryKey(pk).addColumn("col2")).build(this.metaStore.getConf());
            this.client.addForeignKey(fk);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void foreignKeyAcrossCatalogs() throws TException {
        Table parentTable = this.testTables[2];
        Table table = this.testTables[0];
        List pk = ((SQLPrimaryKeyBuilder)((SQLPrimaryKeyBuilder)new SQLPrimaryKeyBuilder().onTable(parentTable)).addColumn("col1")).build(this.metaStore.getConf());
        this.client.addPrimaryKey(pk);
        try {
            List fk = ((SQLForeignKeyBuilder)((SQLForeignKeyBuilder)new SQLForeignKeyBuilder().fromPrimaryKey(pk).onTable(table)).addColumn("col1")).build(this.metaStore.getConf());
            this.client.addForeignKey(fk);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }
}

