/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.SQLCheckConstraintBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestCheckConstraint
extends MetaStoreClientTest {
    private static final String OTHER_DATABASE = "test_uc_other_database";
    private static final String OTHER_CATALOG = "test_uc_other_catalog";
    private static final String DATABASE_IN_OTHER_CATALOG = "test_uc_database_in_other_catalog";
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;
    private Table[] testTables = new Table[3];
    private Database inOtherCatalog;

    public TestCheckConstraint(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
        this.client.dropDatabase(OTHER_DATABASE, true, true, true);
        for (String tableName : this.client.getAllTables("default")) {
            this.client.dropTable("default", tableName, true, true, true);
        }
        this.client.dropDatabase(OTHER_CATALOG, DATABASE_IN_OTHER_CATALOG, true, true, true);
        try {
            this.client.dropCatalog(OTHER_CATALOG);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.metaStore.cleanWarehouseDirs();
        new DatabaseBuilder().setName(OTHER_DATABASE).create(this.client, this.metaStore.getConf());
        Catalog cat = new CatalogBuilder().setName(OTHER_CATALOG).setLocation(MetaStoreTestUtils.getTestWarehouseDir(OTHER_CATALOG)).build();
        this.client.createCatalog(cat);
        this.inOtherCatalog = new DatabaseBuilder().setName(DATABASE_IN_OTHER_CATALOG).setCatalogName(OTHER_CATALOG).create(this.client, this.metaStore.getConf());
        this.testTables[0] = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("test_table_1").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[1] = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(OTHER_DATABASE).setTableName("test_table_2").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        this.testTables[2] = ((TableBuilder)((TableBuilder)new TableBuilder().inDb(this.inOtherCatalog).setTableName("test_table_3").addCol("col1", "int")).addCol("col2", "varchar(32)")).create(this.client, this.metaStore.getConf());
        for (int i = 0; i < this.testTables.length; ++i) {
            this.testTables[i] = this.client.getTable(this.testTables[i].getCatName(), this.testTables[i].getDbName(), this.testTables[i].getTableName());
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void createGetDrop() throws TException {
        Table table = this.testTables[0];
        CheckConstraintsRequest rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col1")).setCheckExpression("= 5").build(this.metaStore.getConf());
        this.client.addCheckConstraint(cc);
        rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getCheckConstraints(rqst);
        ((SQLCheckConstraint)cc.get(0)).setDc_name(((SQLCheckConstraint)fetched.get(0)).getDc_name());
        Assert.assertEquals((Object)cc, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLCheckConstraint)cc.get(0)).getDc_name());
        rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        this.client.addCheckConstraint(cc);
    }

    @Test
    public void inOtherCatalog() throws TException {
        String constraintName = "occc";
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(this.testTables[2])).addColumn("col1")).setConstraintName(constraintName)).setCheckExpression("like s%").build(this.metaStore.getConf());
        this.client.addCheckConstraint(cc);
        CheckConstraintsRequest rqst = new CheckConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        List fetched = this.client.getCheckConstraints(rqst);
        Assert.assertEquals((Object)cc, (Object)fetched);
        this.client.dropConstraint(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName(), constraintName);
        rqst = new CheckConstraintsRequest(this.testTables[2].getCatName(), this.testTables[2].getDbName(), this.testTables[2].getTableName());
        fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPk() throws TException {
        String constraintName = "ctwccc";
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_with_constraints").addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col1")).setConstraintName(constraintName)).setCheckExpression("> 0").build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, null, null, null, cc);
        CheckConstraintsRequest rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getCheckConstraints(rqst);
        Assert.assertEquals((Object)cc, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), constraintName);
        rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void createTableWithConstraintsPkInOtherCatalog() throws TException {
        Table table = ((TableBuilder)((TableBuilder)new TableBuilder().setTableName("table_in_other_catalog_with_constraints").inDb(this.inOtherCatalog).addCol("col1", "int")).addCol("col2", "varchar(32)")).build(this.metaStore.getConf());
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col1")).setCheckExpression("> 0").build(this.metaStore.getConf());
        this.client.createTableWithConstraints(table, null, null, null, null, null, cc);
        CheckConstraintsRequest rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getCheckConstraints(rqst);
        ((SQLCheckConstraint)cc.get(0)).setDc_name(((SQLCheckConstraint)fetched.get(0)).getDc_name());
        Assert.assertEquals((Object)cc, (Object)fetched);
        this.client.dropConstraint(table.getCatName(), table.getDbName(), table.getTableName(), ((SQLCheckConstraint)cc.get(0)).getDc_name());
        rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
    }

    @Test
    public void doubleAddUniqueConstraint() throws TException {
        Table table = this.testTables[0];
        CheckConstraintsRequest rqst = new CheckConstraintsRequest(table.getCatName(), table.getDbName(), table.getTableName());
        List fetched = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)fetched.isEmpty());
        List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col1")).setCheckExpression("> 0").build(this.metaStore.getConf());
        this.client.addCheckConstraint(cc);
        try {
            cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().onTable(table)).addColumn("col2")).setCheckExpression("= 'this string intentionally left empty'").build(this.metaStore.getConf());
            this.client.addCheckConstraint(cc);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void addNoSuchTable() throws TException {
        try {
            List cc = ((SQLCheckConstraintBuilder)((SQLCheckConstraintBuilder)new SQLCheckConstraintBuilder().setTableName("nosuch")).addColumn("col2")).setCheckExpression("= 'this string intentionally left empty'").build(this.metaStore.getConf());
            this.client.addCheckConstraint(cc);
            Assert.fail();
        }
        catch (InvalidObjectException | TApplicationException throwable) {
            // empty catch block
        }
    }

    @Test
    public void getNoSuchTable() throws TException {
        CheckConstraintsRequest rqst = new CheckConstraintsRequest("hive", "default", "nosuch");
        List cc = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)cc.isEmpty());
    }

    @Test
    public void getNoSuchDb() throws TException {
        CheckConstraintsRequest rqst = new CheckConstraintsRequest("hive", "nosuch", this.testTables[0].getTableName());
        List cc = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)cc.isEmpty());
    }

    @Test
    public void getNoSuchCatalog() throws TException {
        CheckConstraintsRequest rqst = new CheckConstraintsRequest("nosuch", this.testTables[0].getDbName(), this.testTables[0].getTableName());
        List cc = this.client.getCheckConstraints(rqst);
        Assert.assertTrue((boolean)cc.isEmpty());
    }
}

