/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientTest;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestCatalogs
extends MetaStoreClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestCatalogs.class);
    private final AbstractMetaStoreService metaStore;
    private IMetaStoreClient client;

    public TestCatalogs(String name, AbstractMetaStoreService metaStore) throws Exception {
        this.metaStore = metaStore;
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.metaStore.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        List catalogs = this.client.getCatalogs();
        for (String catName : catalogs) {
            List databases;
            if (!catName.equalsIgnoreCase("hive")) {
                databases = this.client.getAllDatabases(catName);
                for (String db : databases) {
                    this.client.dropDatabase(catName, db, true, false, true);
                }
                this.client.dropCatalog(catName);
                continue;
            }
            databases = this.client.getAllDatabases(catName);
            for (String db : databases) {
                if (db.equalsIgnoreCase("default")) continue;
                this.client.dropDatabase(catName, db, true, false, true);
            }
        }
        try {
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.client = null;
        }
    }

    @Test
    public void catalogOperations() throws TException {
        File dir;
        Catalog cat;
        int i;
        String[] catNames = new String[]{"cat1", "cat2", "ADifferentName"};
        String[] description = new String[]{"a description", "super descriptive", null};
        String[] location = new String[]{MetaStoreTestUtils.getTestWarehouseDir("cat1"), MetaStoreTestUtils.getTestWarehouseDir("cat2"), MetaStoreTestUtils.getTestWarehouseDir("different")};
        for (i = 0; i < catNames.length; ++i) {
            cat = new CatalogBuilder().setName(catNames[i]).setLocation(location[i]).setDescription(description[i]).build();
            this.client.createCatalog(cat);
            dir = new File(cat.getLocationUri());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
        }
        for (i = 0; i < catNames.length; ++i) {
            cat = this.client.getCatalog(catNames[i]);
            Assert.assertTrue((boolean)catNames[i].equalsIgnoreCase(cat.getName()));
            Assert.assertEquals((Object)description[i], (Object)cat.getDescription());
            Assert.assertEquals((Object)location[i], (Object)cat.getLocationUri());
            Assert.assertTrue((String)"Create time of catalog should be set", (boolean)cat.isSetCreateTime());
            Assert.assertTrue((String)"Create time of catalog should be non-zero", (cat.getCreateTime() > 0 ? 1 : 0) != 0);
            dir = new File(cat.getLocationUri());
            Assert.assertTrue((dir.exists() && dir.isDirectory() ? 1 : 0) != 0);
            Database db = this.client.getDatabase(catNames[i], "default");
            Assert.assertEquals((Object)("file:" + cat.getLocationUri()), (Object)db.getLocationUri());
        }
        List catalogs = this.client.getCatalogs();
        Assert.assertEquals((long)4L, (long)catalogs.size());
        catalogs.sort(Comparator.naturalOrder());
        ArrayList<String> expected = new ArrayList<String>(catNames.length + 1);
        expected.add("hive");
        expected.addAll(Arrays.asList(catNames));
        expected.sort(Comparator.naturalOrder());
        for (int i2 = 0; i2 < catalogs.size(); ++i2) {
            Assert.assertTrue((String)("Expected " + (String)expected.get(i2) + " actual " + (String)catalogs.get(i2)), (boolean)((String)catalogs.get(i2)).equalsIgnoreCase((String)expected.get(i2)));
        }
        Catalog newCat = new Catalog(this.client.getCatalog(catNames[0]));
        String newLocation = MetaStoreTestUtils.getTestWarehouseDir("a_different_location");
        newCat.setLocationUri(newLocation);
        this.client.alterCatalog(catNames[0], newCat);
        Catalog fetchedNewCat = this.client.getCatalog(catNames[0]);
        Assert.assertEquals((Object)newLocation, (Object)fetchedNewCat.getLocationUri());
        Assert.assertEquals((Object)description[0], (Object)fetchedNewCat.getDescription());
        newCat = new Catalog(this.client.getCatalog(catNames[1]));
        String newDescription = "an even more descriptive description";
        newCat.setDescription(newDescription);
        this.client.alterCatalog(catNames[1], newCat);
        fetchedNewCat = this.client.getCatalog(catNames[1]);
        Assert.assertEquals((Object)location[1], (Object)fetchedNewCat.getLocationUri());
        Assert.assertEquals((Object)newDescription, (Object)fetchedNewCat.getDescription());
        for (int i3 = 0; i3 < catNames.length; ++i3) {
            this.client.dropCatalog(catNames[i3]);
            File dir2 = new File(location[i3]);
            Assert.assertFalse((boolean)dir2.exists());
        }
        catalogs = this.client.getCatalogs();
        Assert.assertEquals((long)1L, (long)catalogs.size());
        Assert.assertTrue((boolean)((String)catalogs.get(0)).equalsIgnoreCase("hive"));
    }

    @Test(expected=NoSuchObjectException.class)
    public void getNonExistentCatalog() throws TException {
        this.client.getCatalog("noSuchCatalog");
    }

    @Test(expected=MetaException.class)
    @Ignore
    public void createCatalogWithBadLocation() throws TException {
        Catalog cat = new CatalogBuilder().setName("goodluck").setLocation("/nosuch/nosuch").build();
        this.client.createCatalog(cat);
    }

    @Test(expected=NoSuchObjectException.class)
    public void dropNonExistentCatalog() throws TException {
        this.client.dropCatalog("noSuchCatalog", false);
        Assert.assertTrue((String)"dropCatalog completed without throwing an exception", (boolean)true);
    }

    @Test
    public void dropCatalogIfExists() throws TException {
        this.client.dropCatalog("noSuchCatalog");
    }

    @Test(expected=MetaException.class)
    public void dropHiveCatalog() throws TException {
        this.client.dropCatalog("hive");
    }

    @Test(expected=InvalidOperationException.class)
    public void dropNonEmptyCatalog() throws TException {
        String catName = "toBeDropped";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.createCatalog(cat);
        String dbName = "dontDropMe";
        new DatabaseBuilder().setName(dbName).setCatalogName(catName).create(this.client, this.metaStore.getConf());
        this.client.dropCatalog(catName);
    }

    @Test(expected=InvalidOperationException.class)
    public void dropCatalogWithNonEmptyDefaultDb() throws TException {
        String catName = "toBeDropped2";
        new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).create(this.client);
        ((TableBuilder)new TableBuilder().setTableName("not_droppable").setCatName(catName).addCol("cola1", "bigint")).create(this.client, this.metaStore.getConf());
        this.client.dropCatalog(catName);
    }

    @Test(expected=NoSuchObjectException.class)
    public void alterNonExistentCatalog() throws TException {
        String catName = "alter_no_such_catalog";
        Catalog cat = new CatalogBuilder().setName(catName).setLocation(MetaStoreTestUtils.getTestWarehouseDir(catName)).build();
        this.client.alterCatalog(catName, cat);
    }

    @Test(expected=InvalidOperationException.class)
    public void alterChangeName() throws TException {
        String catName = "alter_change_name";
        String location = MetaStoreTestUtils.getTestWarehouseDir(catName);
        String description = "I have a bad feeling about this";
        new CatalogBuilder().setName(catName).setLocation(location).setDescription(description).create(this.client);
        Catalog newCat = this.client.getCatalog(catName);
        newCat.setName("you_may_call_me_tim");
        this.client.alterCatalog(catName, newCat);
    }
}

