/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.minihms.MiniHMS;

public final class MetaStoreFactoryForTests {
    private static final int DEFAULT_LIMIT_PARTITION_REQUEST = 100;

    private MetaStoreFactoryForTests() {
    }

    public static List<Object[]> getMetaStores() throws Exception {
        ArrayList<Object[]> metaStores = new ArrayList<Object[]>();
        Configuration conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METRICS_ENABLED, (boolean)true);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_OBJECTS_MAX, (long)2L);
        MetastoreConf.setLongVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.LIMIT_PARTITION_REQUEST, (long)100L);
        MetaStoreTestUtils.setConfForStandloneMode(conf);
        conf.set("datanucleus.autoCreateTables", "false");
        String testHMSClientConfiguration = System.getProperty("test.hms.client.configs");
        if (testHMSClientConfiguration != null) {
            String[] configurationFiles;
            Configuration clusterConf = new Configuration(conf);
            for (String configurationFile : configurationFiles = testHMSClientConfiguration.split(",")) {
                clusterConf.addResource(new Path(configurationFile));
            }
            AbstractMetaStoreService cluster = new MiniHMS.Builder().setConf(clusterConf).setType(MiniHMS.MiniHMSType.CLUSTER).build();
            metaStores.add(new Object[]{"Cluster", cluster});
        }
        conf.set("javax.jdo.option.ConnectionURL", "jdbc:derby:memory:${test.tmp.dir}/junit_metastore_db1;create=true");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL, (boolean)false);
        AbstractMetaStoreService embedded = new MiniHMS.Builder().setConf(conf).setType(MiniHMS.MiniHMSType.EMBEDDED).build();
        metaStores.add(new Object[]{"Embedded", embedded});
        conf.set("javax.jdo.option.ConnectionURL", "jdbc:derby:memory:${test.tmp.dir}/junit_metastore_db2;create=true");
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TRY_DIRECT_SQL, (boolean)true);
        AbstractMetaStoreService remote = new MiniHMS.Builder().setConf(conf).setType(MiniHMS.MiniHMSType.REMOTE).build();
        metaStores.add(new Object[]{"Remote", remote});
        return metaStores;
    }
}

